/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.item;

import java.util.Locale;
import javax.annotation.Nonnull;
import mekanism.common.base.IMetaItem;
import mekanism.common.base.ITierUpgradeable;
import mekanism.common.item.ItemMekanism;
import mekanism.common.tier.BaseTier;
import mekanism.common.tile.prefab.TileEntityBasicBlock;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemTierInstaller
extends ItemMekanism
implements IMetaItem {
    public ItemTierInstaller() {
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @Nonnull
    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (world.field_72995_K) {
            return EnumActionResult.PASS;
        }
        TileEntity tile = world.func_175625_s(pos);
        ItemStack stack = player.func_184586_b(hand);
        BaseTier tier = BaseTier.values()[stack.func_77952_i()];
        if (tile instanceof ITierUpgradeable) {
            if (tile instanceof TileEntityBasicBlock && ((TileEntityBasicBlock)tile).playersUsing.size() > 0) {
                return EnumActionResult.FAIL;
            }
            if (((ITierUpgradeable)tile).upgrade(tier)) {
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return EnumActionResult.SUCCESS;
            }
            return EnumActionResult.PASS;
        }
        return EnumActionResult.PASS;
    }

    @Override
    public String getTexture(int meta) {
        return BaseTier.values()[meta].getSimpleName() + "TierInstaller";
    }

    @Override
    public int getVariants() {
        return BaseTier.values().length - 1;
    }

    public void func_150895_a(@Nonnull CreativeTabs tabs, @Nonnull NonNullList<ItemStack> itemList) {
        if (this.func_194125_a(tabs)) {
            for (BaseTier tier : BaseTier.values()) {
                if (!tier.isObtainable()) continue;
                itemList.add((Object)new ItemStack((Item)this, 1, tier.ordinal()));
            }
        }
    }

    @Nonnull
    public String func_77667_c(ItemStack item) {
        return "item." + BaseTier.values()[item.func_77952_i()].getSimpleName().toLowerCase(Locale.ROOT) + "TierInstaller";
    }
}

