/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui;

import java.io.IOException;
import mekanism.api.TileNetworkList;
import mekanism.client.gui.GuiMekanismTile;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.GuiRedstoneControl;
import mekanism.client.gui.element.GuiSlot;
import mekanism.client.gui.element.tab.GuiSecurityTab;
import mekanism.client.gui.element.tab.GuiSideConfigurationTab;
import mekanism.client.gui.element.tab.GuiTransporterConfigTab;
import mekanism.client.sound.SoundHandler;
import mekanism.common.Mekanism;
import mekanism.common.inventory.container.ContainerGasTank;
import mekanism.common.network.PacketTileEntity;
import mekanism.common.tile.TileEntityGasTank;
import mekanism.common.util.LangUtils;
import mekanism.common.util.MekanismUtils;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class GuiGasTank
extends GuiMekanismTile<TileEntityGasTank> {
    public GuiGasTank(InventoryPlayer inventory, TileEntityGasTank tile) {
        super(tile, new ContainerGasTank(inventory, tile));
        ResourceLocation resource = this.getGuiLocation();
        this.addGuiElement(new GuiRedstoneControl(this, this.tileEntity, resource));
        this.addGuiElement(new GuiSecurityTab((IGuiWrapper)this, this.tileEntity, resource));
        this.addGuiElement(new GuiSideConfigurationTab(this, this.tileEntity, resource));
        this.addGuiElement(new GuiTransporterConfigTab(this, 34, this.tileEntity, resource));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.OUTPUT, this, resource, 7, 7).with(GuiSlot.SlotOverlay.PLUS));
        this.addGuiElement(new GuiSlot(GuiSlot.SlotType.INPUT, this, resource, 7, 39).with(GuiSlot.SlotOverlay.MINUS));
    }

    @Override
    protected void func_146979_b(int mouseX, int mouseY) {
        String stored = "" + (((TileEntityGasTank)this.tileEntity).gasTank.getStored() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(((TileEntityGasTank)this.tileEntity).gasTank.getStored()));
        String capacityInfo = stored + " / " + (((TileEntityGasTank)this.tileEntity).tier.getStorage() == Integer.MAX_VALUE ? LangUtils.localize("gui.infinite") : Integer.valueOf(((TileEntityGasTank)this.tileEntity).tier.getStorage()));
        this.field_146289_q.func_78276_b(((TileEntityGasTank)this.tileEntity).func_70005_c_(), this.field_146999_f / 2 - this.field_146289_q.func_78256_a(((TileEntityGasTank)this.tileEntity).func_70005_c_()) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(capacityInfo, 45, 40, 0x404040);
        this.renderScaledText(LangUtils.localize("gui.gas") + ": " + (((TileEntityGasTank)this.tileEntity).gasTank.getGas() != null ? ((TileEntityGasTank)this.tileEntity).gasTank.getGas().getGas().getLocalizedName() : LangUtils.localize("gui.none")), 45, 49, 0x404040, 112);
        this.field_146289_q.func_78276_b(LangUtils.localize("container.inventory"), 8, this.field_147000_g - 96 + 2, 0x404040);
        String name = LangUtils.localize(((TileEntityGasTank)this.tileEntity).dumping.getLangKey());
        this.field_146289_q.func_78276_b(name, 156 - this.field_146289_q.func_78256_a(name), 73, 0x404040);
        super.func_146979_b(mouseX, mouseY);
    }

    @Override
    protected void drawGuiContainerBackgroundLayer(int xAxis, int yAxis) {
        super.drawGuiContainerBackgroundLayer(xAxis, yAxis);
        int displayInt = TileEntityGasTank.GasMode.chooseByMode(((TileEntityGasTank)this.tileEntity).dumping, 10, 18, 26);
        this.func_73729_b(this.field_147003_i + 160, this.field_147009_r + 73, 176, displayInt, 8, 8);
        if (((TileEntityGasTank)this.tileEntity).gasTank.getGas() != null) {
            int scale = (int)((double)((TileEntityGasTank)this.tileEntity).gasTank.getStored() / (double)((TileEntityGasTank)this.tileEntity).tier.getStorage() * 72.0);
            this.func_73729_b(this.field_147003_i + 65, this.field_147009_r + 17, 176, 0, scale, 10);
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int button) throws IOException {
        super.func_73864_a(x, y, button);
        int xAxis = x - this.field_147003_i;
        int yAxis = y - this.field_147009_r;
        if (xAxis > 160 && xAxis < 169 && yAxis > 73 && yAxis < 82) {
            TileNetworkList data = TileNetworkList.withContents(0);
            Mekanism.packetHandler.sendToServer(new PacketTileEntity.TileEntityMessage(this.tileEntity, data));
            SoundHandler.playSound(SoundEvents.field_187909_gi);
        }
    }

    @Override
    protected ResourceLocation getGuiLocation() {
        return MekanismUtils.getResource(MekanismUtils.ResourceType.GUI, "GuiGasTank.png");
    }
}

