/*
 * Decompiled with CFR 0.152.
 */
package techreborn.compatmod.opencomputers;

import java.util.Arrays;
import li.cil.oc.api.Network;
import li.cil.oc.api.driver.DriverBlock;
import li.cil.oc.api.driver.NamedBlock;
import li.cil.oc.api.machine.Arguments;
import li.cil.oc.api.machine.Callback;
import li.cil.oc.api.machine.Context;
import li.cil.oc.api.network.Environment;
import li.cil.oc.api.network.ManagedEnvironment;
import li.cil.oc.api.network.Visibility;
import li.cil.oc.api.prefab.AbstractManagedEnvironment;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import reborncore.api.recipe.IRecipeCrafterProvider;
import reborncore.api.tile.IUpgradeable;
import reborncore.common.powerSystem.TilePowerAcceptor;

public class DriverMachine
implements DriverBlock {
    public boolean worksWith(World world, BlockPos blockPos, EnumFacing enumFacing) {
        return world.func_175625_s(blockPos) instanceof TilePowerAcceptor;
    }

    public ManagedEnvironment createEnvironment(World world, BlockPos blockPos, EnumFacing enumFacing) {
        return new MachineEnvironment((TilePowerAcceptor)world.func_175625_s(blockPos));
    }

    public static class MachineEnvironment
    extends AbstractManagedEnvironment
    implements NamedBlock {
        TilePowerAcceptor machine;

        public MachineEnvironment(TilePowerAcceptor machine) {
            this.machine = machine;
            this.setNode(Network.newNode((Environment)this, (Visibility)Visibility.Network).withComponent("tr_machine", Visibility.Network).create());
        }

        @Callback(value="getTeir", getter=true, doc="Gets the current teir of the machine, this changes with upgrades")
        public Object[] getTeir(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine.getTier().name());
        }

        @Callback(value="getEnergy", getter=true, doc="Gets the currentally stored energy of the machine. in EU")
        public Object[] getEnergy(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine.getEnergy());
        }

        @Callback(value="getMaxPower", getter=true, doc="Gets the maximum energy that can be stored in the machine. in EU")
        public Object[] getMaxPower(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine.getMaxPower());
        }

        @Callback(value="getMaxInput", getter=true, doc="Gets the maximum energy that can be inputted in to the machine. in EU")
        public Object[] getMaxInput(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine.getMaxInput());
        }

        @Callback(value="getMaxOutput", getter=true, doc="Gets the maximum energy that can be extracted from the machine. in EU")
        public Object[] getMaxOutput(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine.getMaxOutput());
        }

        @Callback(value="canBeUprgraded", getter=true, doc="Returns true if the machine can be upgraded")
        public Object[] canBeUprgraded(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine instanceof IUpgradeable && this.machine.canBeUpgraded());
        }

        @Callback(value="hasRecipeCrafter", getter=true, doc="Returns true if the machine has a recipe crafter")
        public Object[] hasRecipeCrafter(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine instanceof IRecipeCrafterProvider);
        }

        @Callback(value="getRecipeName", getter=true, doc="Gets the name of the recipe that the machine crafts")
        public Object[] getRecipeName(Context context, Arguments arguments) throws Exception {
            if (!(this.machine instanceof IRecipeCrafterProvider)) {
                return null;
            }
            return this.getObjects(((IRecipeCrafterProvider)this.machine).getRecipeCrafter().recipeName);
        }

        @Callback(value="getInputSlots", getter=true, doc="Gets the slot ids that the crafter uses to look for inputs")
        public Object[] getInputSlots(Context context, Arguments arguments) throws Exception {
            if (!(this.machine instanceof IRecipeCrafterProvider)) {
                return null;
            }
            return Arrays.stream(((IRecipeCrafterProvider)this.machine).getRecipeCrafter().inputSlots).mapToObj(value -> value).toArray();
        }

        @Callback(value="getOutputSlots", getter=true, doc="Gets the slot ids that the crafter uses for outputs")
        public Object[] getOutputSlots(Context context, Arguments arguments) throws Exception {
            if (!(this.machine instanceof IRecipeCrafterProvider)) {
                return null;
            }
            return Arrays.stream(((IRecipeCrafterProvider)this.machine).getRecipeCrafter().outputSlots).mapToObj(value -> value).toArray();
        }

        @Callback(value="isActive", getter=true, doc="Returns a boolean if the machine is actice")
        public Object[] isActive(Context context, Arguments arguments) throws Exception {
            return this.getObjects(this.machine.isActive());
        }

        @Callback(value="getFacing", getter=true, doc="Gets the facing for the machine")
        public Object[] getFacing(Context context, Arguments arguments) throws Exception {
            EnumFacing facing = this.machine.getFacing();
            if (facing == null) {
                return null;
            }
            return this.getObjects(facing.func_176610_l());
        }

        private Object[] getObjects(Object ... objects) {
            return objects;
        }

        public String preferredName() {
            return "tr_machine";
        }

        public int priority() {
            return 10;
        }
    }
}

