/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import java.util.Collection;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.block.BlockBait;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.config.ModConfig;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class TileBait
extends TileEntity
implements ITickable {
    private static final int ENVIRONMENTAL_CHECK_INTERVAL = 200;
    private static final int MAX_BAITS_IN_AREA = 2;
    private static final int MIN_ENV_IN_AREA = 10;
    private static final int MAX_ANIMALS_IN_AREA = 2;
    private static final int SPAWN_CHECK_INTERVAL = 20;
    private static final int MIN_DISTANCE_NO_PLAYERS = 6;
    private ItemStack renderItemMain = ItemStack.field_190927_a;
    private ItemStack renderItemSub = ItemStack.field_190927_a;
    private EnvironmentalCondition environmentStatus;
    private int ticksSinceEnvironmentalCheck;
    private int ticksSinceSpawnCheck;

    public void func_73660_a() {
        if (this.renderItemMain.func_190926_b()) {
            this.renderItemMain = TileBait.getBaitDisplayItem(this.func_145832_p(), 0);
        }
        if (this.renderItemSub.func_190926_b()) {
            this.renderItemSub = TileBait.getBaitDisplayItem(this.func_145832_p(), 1);
        }
        ++this.ticksSinceEnvironmentalCheck;
        ++this.ticksSinceSpawnCheck;
        if (this.ticksSinceSpawnCheck >= 20) {
            int metadata = this.func_145832_p();
            if (!this.field_145850_b.field_72995_K && this.field_145850_b.field_73012_v.nextFloat() <= this.getBaitChance(metadata) && this.checkSpawnConditions(true) == EnvironmentalCondition.CanSpawn) {
                float range = 6.0f;
                if (this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)this.field_174879_c.func_177958_n() - 6.0f), (double)((float)this.field_174879_c.func_177956_o() - 6.0f), (double)((float)this.field_174879_c.func_177952_p() - 6.0f), (double)((float)this.field_174879_c.func_177958_n() + 6.0f), (double)((float)this.field_174879_c.func_177956_o() + 6.0f), (double)((float)this.field_174879_c.func_177952_p() + 6.0f))).isEmpty()) {
                    EntityLiving entityLiving = TileBait.getBaitEntityLiving(this.field_145850_b, metadata);
                    if (entityLiving != null) {
                        if (entityLiving instanceof EntityAgeable && this.field_145850_b.field_73012_v.nextFloat() <= ModConfig.baits.childChance) {
                            ((EntityAgeable)entityLiving).func_70873_a(-24000);
                        }
                        entityLiving.func_70107_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5);
                        this.field_145850_b.func_72838_d((Entity)entityLiving);
                        ((WorldServer)this.field_145850_b).func_180505_a(EnumParticleTypes.EXPLOSION_LARGE, false, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 1, 0.0, 0.0, 0.0, 0.0, new int[0]);
                        this.field_145850_b.func_184133_a(null, this.field_174879_c, SoundEvents.field_187665_Y, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    }
                    this.field_145850_b.func_175698_g(this.field_174879_c);
                }
            }
            this.ticksSinceSpawnCheck = 0;
        }
    }

    private static ItemStack getBaitDisplayItem(int metadata, int i) {
        BlockBait.Type type = BlockBait.Type.fromId(metadata);
        if (type != null) {
            return i == 0 ? type.getDisplayItemFirst() : type.getDisplayItemSecond();
        }
        return ItemStack.field_190927_a;
    }

    @Nullable
    private static EntityLiving getBaitEntityLiving(World world, int metadata) {
        BlockBait.Type type = BlockBait.Type.fromId(metadata);
        return type != null ? type.createEntity(world) : null;
    }

    private float getBaitChance(int metadata) {
        BlockBait.Type type = BlockBait.Type.fromId(metadata);
        return type != null ? type.getChance() : 0.0f;
    }

    public ItemStack getRenderItem(int i) {
        return i == 0 ? this.renderItemMain : this.renderItemSub;
    }

    public EnvironmentalCondition checkSpawnConditions(boolean checkNow) {
        if (checkNow || this.ticksSinceEnvironmentalCheck > 200) {
            Collection<BaitBlockCondition> envBlocks;
            int metadata = this.func_145832_p();
            BlockBait.Type baitType = BlockBait.Type.fromId(metadata);
            Collection<BaitBlockCondition> collection = envBlocks = baitType != null ? baitType.getEnvironmentConditions() : null;
            if (envBlocks == null) {
                throw new RuntimeException("The bait you placed (metadata " + metadata + ") was not properly defined - this should not happen - please report to the mod developer!");
            }
            int range = 5;
            int rangeVertical = 3;
            int countBait = 0;
            int countEnvBlocks = 0;
            boolean foundWater = false;
            for (int x = this.field_174879_c.func_177958_n() - 5; x < this.field_174879_c.func_177958_n() + 5; ++x) {
                for (int y = this.field_174879_c.func_177956_o() - 3; y < this.field_174879_c.func_177956_o() + 3; ++y) {
                    for (int z = this.field_174879_c.func_177952_p() - 5; z < this.field_174879_c.func_177952_p() + 5; ++z) {
                        BlockPos testPos = new BlockPos(x, y, z);
                        IBlockState state = this.field_145850_b.func_180495_p(testPos);
                        if (state.func_177230_c() == ModBlocks.bait) {
                            ++countBait;
                        } else if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_150358_i) {
                            foundWater = true;
                        }
                        for (BaitBlockCondition envBlock : envBlocks) {
                            int envMeta;
                            int meta;
                            if (envBlock == null || envBlock.getState() == null) {
                                ++countEnvBlocks;
                                continue;
                            }
                            if (state.func_177230_c() != envBlock.getState().func_177230_c() || !envBlock.isWildcard() && (meta = state.func_177230_c().func_176201_c(state)) != (envMeta = envBlock.getState().func_177230_c().func_176201_c(envBlock.getState()))) continue;
                            ++countEnvBlocks;
                        }
                    }
                }
            }
            this.environmentStatus = !foundWater ? EnvironmentalCondition.NoWater : (countBait > 2 ? EnvironmentalCondition.NearbyBait : (countEnvBlocks < 10 ? EnvironmentalCondition.WrongEnv : (this.field_145850_b.func_72872_a(EntityAnimal.class, new AxisAlignedBB((double)(this.field_174879_c.func_177958_n() - 10), (double)(this.field_174879_c.func_177956_o() - 3), (double)(this.field_174879_c.func_177952_p() - 10), (double)(this.field_174879_c.func_177958_n() + 10), (double)(this.field_174879_c.func_177956_o() + 3), (double)(this.field_174879_c.func_177952_p() + 10))).size() > 2 ? EnvironmentalCondition.NearbyAnimal : EnvironmentalCondition.CanSpawn)));
            this.ticksSinceEnvironmentalCheck = 0;
        }
        return this.environmentStatus;
    }

    public static class BaitBlockCondition {
        private final IBlockState state;
        private final boolean isWildcard;

        public BaitBlockCondition(IBlockState state, boolean isWildcard) {
            this.state = state;
            this.isWildcard = isWildcard;
        }

        public IBlockState getState() {
            return this.state;
        }

        public boolean isWildcard() {
            return this.isWildcard;
        }
    }

    public static enum EnvironmentalCondition {
        CanSpawn("info.excompressum:baitCanSpawn"),
        NearbyBait("info.excompressum:baitNearbyBait"),
        WrongEnv("info.excompressum:baitWrongEnv"),
        NearbyAnimal("info.excompressum:baitNearbyAnimal"),
        NoWater("info.excompressum:baitNoWater");

        public final String langKey;

        private EnvironmentalCondition(String langKey) {
            this.langKey = langKey;
        }
    }
}

