/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.tile;

import cofh.redstoneflux.api.IEnergyReceiver;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.tile.TileAutoSieveBase;
import net.blay09.mods.excompressum.utils.EnergyStorageModifiable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.fml.common.Optional;

@Optional.Interface(modid="redstoneflux", iface="cofh.redstoneflux.api.IEnergyReceiver")
public class TileAutoSieve
extends TileAutoSieveBase
implements IEnergyReceiver {
    private final EnergyStorageModifiable energyStorage = new EnergyStorageModifiable(32000){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            if (!simulate) {
                TileAutoSieve.this.func_70296_d();
            }
            return super.receiveEnergy(maxReceive, simulate);
        }
    };

    @Override
    protected void writeToNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        super.writeToNBTSynced(tagCompound, isSync);
        NBTBase energyStorageNBT = CapabilityEnergy.ENERGY.writeNBT((Object)this.energyStorage, null);
        if (energyStorageNBT != null) {
            tagCompound.func_74782_a("EnergyStorage", energyStorageNBT);
        }
    }

    @Override
    protected void readFromNBTSynced(NBTTagCompound tagCompound, boolean isSync) {
        super.readFromNBTSynced(tagCompound, isSync);
        if (tagCompound.func_74764_b("EnergyStorage")) {
            CapabilityEnergy.ENERGY.readNBT((Object)this.energyStorage, null, tagCompound.func_74781_a("EnergyStorage"));
        }
    }

    @Override
    public int getEnergyStored(@Nullable EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    @Override
    public void setEnergyStored(int energy) {
        this.energyStorage.setEnergyStored(energy);
    }

    @Override
    public int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    @Override
    public int extractEnergy(int maxExtract, boolean simulate) {
        if (!simulate) {
            this.isDirty = true;
        }
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)((Object)this.energyStorage);
        }
        return super.getCapability(capability, facing);
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    public EnergyStorageModifiable getEnergyStorage() {
        return this.energyStorage;
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }
}

