/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.registry;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class RegistryKey {
    public static final int WILDCARD_VALUE = Short.MAX_VALUE;
    private final ResourceLocation registryName;
    private int metadata;

    public RegistryKey(ResourceLocation registryName, int metadata) {
        this.registryName = registryName;
        this.metadata = metadata;
    }

    public RegistryKey(ItemStack itemStack) {
        this.registryName = itemStack.func_77973_b().getRegistryName();
        this.metadata = itemStack.func_77952_i();
    }

    public RegistryKey(IBlockState state, boolean isWildcard) {
        this.registryName = state.func_177230_c().getRegistryName();
        this.metadata = isWildcard ? Short.MAX_VALUE : state.func_177230_c().func_176201_c(state);
    }

    public RegistryKey withWildcard() {
        this.metadata = Short.MAX_VALUE;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistryKey that = (RegistryKey)o;
        return this.metadata == that.metadata && this.registryName.equals((Object)that.registryName);
    }

    public int hashCode() {
        int result = this.registryName.hashCode();
        result = 31 * result + this.metadata;
        return result;
    }
}

