/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.item;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipe;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipeRegistry;
import net.minecraft.block.state.IBlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemOreSmasher
extends ItemTool {
    private static final List<String> ORE_BLOCKS = Lists.newArrayList();
    private static final List<String> ORE_ITEMS = Lists.newArrayList();
    private static final List<String> ORE_BLOCKS_OREDICT = Lists.newArrayList((Object[])new String[]{"oreGravel", "oreNetherGravel", "oreSand"});
    private static final List<String> ORE_ITEMS_OREDICT = Lists.newArrayList((Object[])new String[]{"oreBroken", "oreNetherBroken", "oreCrushed"});
    public static final String name = "ore_smasher";
    public static final ResourceLocation registryName = new ResourceLocation("excompressum", "ore_smasher");

    public ItemOreSmasher() {
        super(0.0f, 0.0f, Item.ToolMaterial.DIAMOND, new HashSet());
        this.func_77655_b(registryName.toString());
        this.func_77637_a(ExCompressum.creativeTab);
    }

    public boolean canHarvestBlock(IBlockState state, ItemStack stack) {
        return this.isOreBlock(new ItemStack(state.func_177230_c()));
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        if (this.isOreBlock(new ItemStack(state.func_177230_c()))) {
            return this.field_77864_a;
        }
        return 0.8f;
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.func_72855_b(new AxisAlignedBB((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)(pos.func_177958_n() + 1), (double)(pos.func_177956_o() + 2), (double)(pos.func_177952_p() + 1)))) {
            return EnumActionResult.FAIL;
        }
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            CompressedRecipe recipe;
            ItemStack inventoryStack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            if (inventoryStack.func_190926_b()) continue;
            if (this.isOreItem(inventoryStack) && (recipe = CompressedRecipeRegistry.getRecipe(inventoryStack)) != null && recipe.getResultStack().func_190916_E() == 1 && inventoryStack.func_190916_E() >= recipe.getCount()) {
                IBlockState oldState = world.func_180495_p(pos);
                ItemStack resultStack = recipe.getResultStack().func_77946_l();
                resultStack.func_77973_b().func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
                world.func_184138_a(pos, oldState, world.func_180495_p(pos), 3);
                if (resultStack.func_190926_b()) {
                    inventoryStack.func_190918_g(recipe.getCount());
                    if (inventoryStack.func_190926_b()) {
                        player.field_71071_by.field_70462_a.remove(i);
                    }
                    player.func_184609_a(hand);
                    return EnumActionResult.SUCCESS;
                }
            }
            if (!this.isOreBlock(inventoryStack)) continue;
            IBlockState oldState = world.func_180495_p(pos);
            inventoryStack.func_77973_b().func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
            world.func_184138_a(pos, oldState, world.func_180495_p(pos), 3);
            if (inventoryStack.func_190926_b()) {
                player.field_71071_by.field_70462_a.remove(i);
            }
            player.func_184609_a(hand);
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean func_179218_a(ItemStack itemStack, World world, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if (!world.field_72995_K && this.canHarvestBlock(state, itemStack) && ExRegistro.isHammerable(state)) {
            world.func_175698_g(pos);
            Collection<ItemStack> rewards = ExRegistro.rollHammerRewards(state, this.field_77862_b.func_77996_d(), (float)EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185308_t, (ItemStack)itemStack), world.field_73012_v);
            for (ItemStack rewardStack : rewards) {
                world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, rewardStack));
            }
        }
        return super.func_179218_a(itemStack, world, state, pos, entityLiving);
    }

    private boolean isOreItem(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        if (registryName == null) {
            return false;
        }
        if (ORE_ITEMS.contains(registryName.toString())) {
            return true;
        }
        return this.matchesOreDict(itemStack, ORE_ITEMS_OREDICT);
    }

    private boolean isOreBlock(ItemStack itemStack) {
        ResourceLocation registryName = itemStack.func_77973_b().getRegistryName();
        if (registryName == null || itemStack.func_190926_b()) {
            return false;
        }
        if (ORE_BLOCKS.contains(registryName.toString())) {
            return true;
        }
        return this.matchesOreDict(itemStack, ORE_BLOCKS_OREDICT);
    }

    private boolean matchesOreDict(ItemStack itemStack, List<String> oreDictEntries) {
        int[] oreIDs;
        for (int oreID : oreIDs = OreDictionary.getOreIDs((ItemStack)itemStack)) {
            String oreName = OreDictionary.getOreName((int)oreID);
            for (String dictName : oreDictEntries) {
                if (!oreName.startsWith(dictName)) continue;
                return true;
            }
        }
        return false;
    }
}

