/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.top;

import com.google.common.base.Function;
import javax.annotation.Nullable;
import mcjty.theoneprobe.api.IProbeHitData;
import mcjty.theoneprobe.api.IProbeInfo;
import mcjty.theoneprobe.api.IProbeInfoProvider;
import mcjty.theoneprobe.api.ITheOneProbe;
import mcjty.theoneprobe.api.ProbeMode;
import net.blay09.mods.excompressum.block.BlockAutoSieveBase;
import net.blay09.mods.excompressum.block.BlockBait;
import net.blay09.mods.excompressum.block.BlockHeavySieve;
import net.blay09.mods.excompressum.block.BlockWoodenCrucible;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.tile.TileAutoSieveBase;
import net.blay09.mods.excompressum.tile.TileBait;
import net.blay09.mods.excompressum.tile.TileHeavySieve;
import net.blay09.mods.excompressum.tile.TileWoodenCrucible;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TheOneProbeAddon
implements Function<ITheOneProbe, Void> {
    @Nullable
    public Void apply(@Nullable ITheOneProbe top) {
        if (top != null) {
            top.registerProvider((IProbeInfoProvider)new ProbeInfoProvider());
        }
        return null;
    }

    @Nullable
    private static <T extends TileEntity> T tryGetTileEntity(World world, BlockPos pos, Class<T> tileClass) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null && tileClass.isAssignableFrom(tileEntity.getClass())) {
            return (T)tileEntity;
        }
        return null;
    }

    public static class ProbeInfoProvider
    implements IProbeInfoProvider {
        public String getID() {
            return "excompressum";
        }

        public void addProbeInfo(ProbeMode mode, IProbeInfo info, EntityPlayer player, World world, IBlockState state, IProbeHitData data) {
            TileHeavySieve tileEntity;
            if (state.func_177230_c() instanceof BlockAutoSieveBase) {
                TileAutoSieveBase tileEntity2 = (TileAutoSieveBase)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), TileAutoSieveBase.class);
                if (tileEntity2 != null) {
                    this.addAutoSieveInfo(tileEntity2, mode, info);
                }
            } else if (state.func_177230_c() instanceof BlockBait) {
                TileBait tileEntity3 = (TileBait)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), TileBait.class);
                if (tileEntity3 != null) {
                    this.addBaitInfo(tileEntity3, mode, info);
                }
            } else if (state.func_177230_c() instanceof BlockWoodenCrucible) {
                TileWoodenCrucible tileEntity4 = (TileWoodenCrucible)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), TileWoodenCrucible.class);
                if (tileEntity4 != null) {
                    this.addWoodenCrucibleInfo(tileEntity4, mode, info);
                }
            } else if (state.func_177230_c() instanceof BlockHeavySieve && (tileEntity = (TileHeavySieve)TheOneProbeAddon.tryGetTileEntity(world, data.getPos(), TileHeavySieve.class)) != null) {
                this.addHeavySieveInfo(tileEntity, mode, info);
            }
        }

        private void addAutoSieveInfo(TileAutoSieveBase tileEntity, ProbeMode mode, IProbeInfo info) {
            if (tileEntity.getCustomSkin() != null) {
                info.text(String.format("Skin: %s", tileEntity.getCustomSkin().getName()));
            }
            if (tileEntity.getFoodBoost() > 1.0f) {
                info.text(String.format("Speed Boost: %.1f", Float.valueOf(tileEntity.getFoodBoost())));
            }
            if (tileEntity.getEffectiveLuck() > 1.0f) {
                info.text(String.format("Luck Bonus: %.1f", Float.valueOf(tileEntity.getEffectiveLuck() - 1.0f)));
            }
        }

        private void addBaitInfo(TileBait tileEntity, ProbeMode mode, IProbeInfo info) {
            TileBait.EnvironmentalCondition environmentalStatus = tileEntity.checkSpawnConditions(true);
            if (environmentalStatus == TileBait.EnvironmentalCondition.CanSpawn) {
                info.text("You are too close.");
                info.text("The animals are scared away.");
            } else {
                info.text("Unable to lure animals. Right-click for more info.");
            }
        }

        private void addWoodenCrucibleInfo(TileWoodenCrucible tileEntity, ProbeMode mode, IProbeInfo info) {
            if ((float)tileEntity.getSolidVolume() > 0.0f) {
                info.text(String.format("Solid Volume: %d", tileEntity.getSolidVolume()));
            }
            if ((float)tileEntity.getFluidTank().getFluidAmount() > 0.0f) {
                info.text(String.format("Fluid Volume: %d", tileEntity.getFluidTank().getFluidAmount()));
            }
        }

        private void addHeavySieveInfo(TileHeavySieve tileEntity, ProbeMode mode, IProbeInfo info) {
            ItemStack meshStack;
            if (tileEntity.getProgress() > 0.0f) {
                info.progress((int)(tileEntity.getProgress() * 100.0f), 100);
            }
            if (!(meshStack = tileEntity.getMeshStack()).func_190926_b()) {
                if (ExRegistro.doMeshesHaveDurability()) {
                    info.text(String.format("%s %d/%d", meshStack.func_82833_r(), meshStack.func_77958_k() - meshStack.func_77952_i(), meshStack.func_77958_k()));
                } else {
                    info.text(meshStack.func_82833_r());
                }
            } else {
                info.text("No Mesh");
            }
        }
    }
}

