/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.compat.jei;

import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IDrawableStatic;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import net.blay09.mods.excompressum.api.compressedhammer.CompressedHammerReward;
import net.blay09.mods.excompressum.compat.jei.CompressedHammerRecipe;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class CompressedHammerRecipeCategory
implements IRecipeCategory<CompressedHammerRecipe> {
    private static final ResourceLocation texture = new ResourceLocation("excompressum", "textures/gui/jei_compressed_hammer.png");
    public static final String UID = "excompressum:compressedHammer";
    private final IDrawableStatic background;
    private final IDrawableStatic slotHighlight;
    private boolean hasHighlight;
    private int highlightX;
    private int highlightY;

    public CompressedHammerRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(texture, 0, 0, 166, 63);
        this.slotHighlight = guiHelper.createDrawable(texture, 166, 0, 18, 18);
    }

    @Nonnull
    public String getUid() {
        return UID;
    }

    @Nonnull
    public String getTitle() {
        return I18n.func_135052_a((String)"jei.excompressum:compressedHammer", (Object[])new Object[0]);
    }

    public String getModName() {
        return "Ex Compressum";
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    public void drawExtras(@Nonnull Minecraft minecraft) {
        if (this.hasHighlight) {
            this.slotHighlight.draw(minecraft, this.highlightX, this.highlightY);
        }
    }

    public void setRecipe(IRecipeLayout recipeLayout, CompressedHammerRecipe recipeWrapper, IIngredients ingredients) {
        recipeLayout.getItemStacks().init(0, true, 74, 9);
        recipeLayout.getItemStacks().set(0, (List)ingredients.getInputs(ItemStack.class).get(0));
        IFocus focus = recipeLayout.getFocus();
        this.hasHighlight = focus != null && focus.getMode() == IFocus.Mode.OUTPUT;
        List outputs = ingredients.getOutputs(ItemStack.class);
        boolean INPUT_SLOTS = true;
        int slotNumber = 0;
        for (List output : outputs) {
            int slotX = 2 + slotNumber * 18;
            int slotY = 36;
            recipeLayout.getItemStacks().init(1 + slotNumber, false, slotX, 36);
            recipeLayout.getItemStacks().set(1 + slotNumber, output);
            if (focus != null) {
                ItemStack focusStack;
                Object focusValue = focus.getValue();
                if (focus.getMode() == IFocus.Mode.OUTPUT && focusValue instanceof ItemStack && (focusStack = (ItemStack)focusValue).func_77973_b() == ((ItemStack)output.get(0)).func_77973_b() && focusStack.func_77952_i() == ((ItemStack)output.get(0)).func_77952_i()) {
                    this.highlightX = slotX;
                    this.highlightY = 36;
                }
            }
            ++slotNumber;
        }
        recipeLayout.getItemStacks().addTooltipCallback((slotIndex, input, ingredient, tooltip) -> {
            if (!input) {
                CompressedHammerReward reward = recipeWrapper.getRewardAt(slotIndex - 1);
                tooltip.add(I18n.func_135052_a((String)"jei.excompressum:compressedHammer.dropChance", (Object[])new Object[0]));
                String s = String.format(" * %3d%%", (int)(reward.getBaseChance() * 100.0f));
                if (reward.getLuckMultiplier() > 0.0f) {
                    s = s + TextFormatting.BLUE + String.format(" (+ %1.1f " + I18n.func_135052_a((String)"jei.excompressum:compressedHammer.luck", (Object[])new Object[0]) + ")", Float.valueOf(reward.getLuckMultiplier()));
                }
                tooltip.add(s);
            }
        });
    }
}

