/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.client;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.client.render.entity.RenderAngryChicken;
import net.blay09.mods.excompressum.client.render.tile.RenderAutoHammer;
import net.blay09.mods.excompressum.client.render.tile.RenderAutoSieve;
import net.blay09.mods.excompressum.client.render.tile.RenderBait;
import net.blay09.mods.excompressum.client.render.tile.RenderHeavySieve;
import net.blay09.mods.excompressum.client.render.tile.RenderWoodenCrucible;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.entity.EntityAngryChicken;
import net.blay09.mods.excompressum.handler.ChickenStickHandler;
import net.blay09.mods.excompressum.tile.TileAutoCompressedHammer;
import net.blay09.mods.excompressum.tile.TileAutoHammer;
import net.blay09.mods.excompressum.tile.TileAutoHeavySieve;
import net.blay09.mods.excompressum.tile.TileAutoSieve;
import net.blay09.mods.excompressum.tile.TileAutoSieveMana;
import net.blay09.mods.excompressum.tile.TileBait;
import net.blay09.mods.excompressum.tile.TileHeavySieve;
import net.blay09.mods.excompressum.tile.TileWoodenCrucible;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelChicken;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;

public class ClientProxy
extends CommonProxy {
    private final Set<GameProfile> skinRequested = Sets.newHashSet();
    public static TextureAtlasSprite iconEmptyBookSlot;
    public static TextureAtlasSprite iconEmptyMeshSlot;
    public static TextureAtlasSprite iconEmptyHammerSlot;
    public static TextureAtlasSprite iconEmptyCompressedHammerSlot;
    public static TextureAtlasSprite ironMeshSprite;
    public static TextureAtlasSprite stringMeshSprite;
    public static TextureAtlasSprite flintMeshSprite;
    public static TextureAtlasSprite diamondMeshSprite;
    public static final TextureAtlasSprite[] destroyBlockIcons;
    private static Map<String, String> customChickenStickNames;

    @Override
    public void registerModels() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileHeavySieve.class, (TileEntitySpecialRenderer)new RenderHeavySieve());
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoSieve.class, (TileEntitySpecialRenderer)new RenderAutoSieve(false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoSieveMana.class, (TileEntitySpecialRenderer)new RenderAutoSieve(false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoHeavySieve.class, (TileEntitySpecialRenderer)new RenderAutoSieve(true));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoHammer.class, (TileEntitySpecialRenderer)new RenderAutoHammer(false));
        ClientRegistry.bindTileEntitySpecialRenderer(TileAutoCompressedHammer.class, (TileEntitySpecialRenderer)new RenderAutoHammer(true));
        ClientRegistry.bindTileEntitySpecialRenderer(TileWoodenCrucible.class, (TileEntitySpecialRenderer)new RenderWoodenCrucible());
        ClientRegistry.bindTileEntitySpecialRenderer(TileBait.class, (TileEntitySpecialRenderer)new RenderBait());
        ModelChicken modelChicken = new ModelChicken();
        RenderingRegistry.registerEntityRenderingHandler(EntityAngryChicken.class, manager -> new RenderAngryChicken(manager, (ModelBase)modelChicken, 0.3f));
    }

    @Override
    public void preloadSkin(GameProfile customSkin) {
        if (!this.skinRequested.contains(customSkin)) {
            Minecraft.func_71410_x().func_152342_ad().func_152790_a(customSkin, (typeIn, location, profileTexture) -> {}, true);
            this.skinRequested.add(customSkin);
        }
    }

    @SubscribeEvent
    public void onPlayerConnected(FMLNetworkEvent.ClientConnectedToServerEvent event) {
        String customName = ClientProxy.getChickenStickName(null);
        if (customName == null) {
            customName = ClientProxy.getChickenStickName("*");
        }
        if (customName != null) {
            ChickenStickHandler.chickenStickName = customName;
        }
    }

    @SubscribeEvent
    public void onTextureStitch(TextureStitchEvent.Pre event) {
        if (event.getMap() == Minecraft.func_71410_x().func_147117_R()) {
            iconEmptyBookSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_enchanted_book_slot"));
            iconEmptyMeshSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_mesh_slot"));
            iconEmptyHammerSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_hammer_slot"));
            iconEmptyCompressedHammerSlot = event.getMap().func_174942_a(new ResourceLocation("excompressum", "items/empty_compressed_hammer_slot"));
            stringMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/string_mesh"));
            flintMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/flint_mesh"));
            ironMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/iron_mesh"));
            diamondMeshSprite = event.getMap().func_174942_a(new ResourceLocation("excompressum", "blocks/diamond_mesh"));
        }
    }

    @SubscribeEvent
    public void afterTextureStitch(TextureStitchEvent.Post event) {
        for (int i = 0; i < destroyBlockIcons.length; ++i) {
            ClientProxy.destroyBlockIcons[i] = event.getMap().func_110572_b("minecraft:blocks/destroy_stage_" + i);
        }
    }

    @Nullable
    public static String getChickenStickName(@Nullable String key) {
        if (key == null) {
            key = Minecraft.func_71410_x().func_110432_I().func_111285_a().toLowerCase(Locale.ENGLISH);
        }
        if (customChickenStickNames == null) {
            customChickenStickNames = Maps.newHashMap();
            for (String name : ModConfig.tools.chickenStickNames) {
                String[] s = name.split("=");
                if (s.length < 2) continue;
                customChickenStickNames.put(s[0].toLowerCase(Locale.ENGLISH), s[1]);
            }
        }
        return customChickenStickNames.get(key);
    }

    static {
        destroyBlockIcons = new TextureAtlasSprite[10];
    }
}

