/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.api.ExNihiloProvider;
import net.blay09.mods.excompressum.config.ModConfig;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.tile.TileBait;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockNewLog;
import net.minecraft.block.BlockOldLog;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.BlockSapling;
import net.minecraft.block.BlockTallGrass;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntityPolarBear;
import net.minecraft.entity.passive.EntityChicken;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityDonkey;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityLlama;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.passive.EntityParrot;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntityRabbit;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntitySquid;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockBait
extends BlockContainer {
    public static final String name = "bait";
    public static final ResourceLocation registryName = new ResourceLocation("excompressum", "bait");
    private static final AxisAlignedBB BOUNDING_BOX = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0);
    public static final PropertyEnum<Type> VARIANT = PropertyEnum.func_177709_a((String)"variant", Type.class);

    public BlockBait() {
        super(Material.field_151578_c);
        this.func_149711_c(0.1f);
        this.func_149647_a(ExCompressum.creativeTab);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    public IBlockState func_176203_a(int meta) {
        if (meta < 0 || meta >= Type.values.length) {
            return this.func_176223_P();
        }
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)Type.values[meta]));
    }

    public int func_176201_c(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, ((Type)((Object)state.func_177229_b(VARIANT))).ordinal());
    }

    public int func_180651_a(IBlockState state) {
        return ((Type)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return BOUNDING_BOX;
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return null;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        for (int i = 0; i < Type.values.length; ++i) {
            items.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public TileEntity func_149915_a(World world, int metadata) {
        return new TileBait();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileBait tileEntity = (TileBait)world.func_175625_s(pos);
        if (tileEntity != null) {
            TileBait.EnvironmentalCondition environmentStatus = tileEntity.checkSpawnConditions(true);
            if (!world.field_72995_K) {
                TextComponentTranslation chatComponent = new TextComponentTranslation(environmentStatus.langKey, new Object[0]);
                chatComponent.func_150256_b().func_150238_a(environmentStatus != TileBait.EnvironmentalCondition.CanSpawn ? TextFormatting.RED : TextFormatting.GREEN);
                player.func_145747_a((ITextComponent)chatComponent);
            }
        }
        return true;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileBait tileEntity;
        if (placer instanceof EntityPlayer && (tileEntity = (TileBait)world.func_175625_s(pos)) != null) {
            TileBait.EnvironmentalCondition environmentStatus = tileEntity.checkSpawnConditions(true);
            if (!world.field_72995_K) {
                TextComponentTranslation chatComponent = new TextComponentTranslation(environmentStatus.langKey, new Object[0]);
                chatComponent.func_150256_b().func_150238_a(environmentStatus != TileBait.EnvironmentalCondition.CanSpawn ? TextFormatting.RED : TextFormatting.GREEN);
                placer.func_145747_a((ITextComponent)chatComponent);
            }
        }
    }

    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        TileBait tileEntity;
        if (!ModConfig.client.disableParticles && (tileEntity = (TileBait)world.func_175625_s(pos)) != null && tileEntity.checkSpawnConditions(false) == TileBait.EnvironmentalCondition.CanSpawn && rand.nextFloat() <= 0.2f) {
            world.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)((float)pos.func_177958_n() + rand.nextFloat()), (double)((float)pos.func_177956_o() + rand.nextFloat() * 0.5f), (double)((float)pos.func_177952_p() + rand.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        }
    }

    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        Type type = Type.fromId(stack.func_77952_i());
        if (type == Type.SQUID) {
            tooltip.add(I18n.func_135052_a((String)"info.excompressum:baitPlaceInWater", (Object[])new Object[0]));
        }
    }

    public static enum Type implements IStringSerializable
    {
        WOLF(new ItemStack(Items.field_151082_bd), new ItemStack(Items.field_151103_aS), EntityWolf::new, () -> Float.valueOf(ModConfig.baits.wolfChance)),
        OCELOT(new ItemStack(Items.field_151016_H), new ItemStack(Items.field_151115_aP), EntityOcelot::new, () -> Float.valueOf(ModConfig.baits.ocelotChance)),
        COW(new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151015_O), EntityCow::new, () -> Float.valueOf(ModConfig.baits.cowChance)),
        PIG(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151172_bF), EntityPig::new, () -> Float.valueOf(ModConfig.baits.pigChance)),
        CHICKEN(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151014_N), EntityChicken::new, () -> Float.valueOf(ModConfig.baits.chickenChance)),
        SHEEP(new ItemStack(Items.field_151014_N), new ItemStack(Items.field_151015_O), EntitySheep::new, () -> Float.valueOf(ModConfig.baits.sheepChance)),
        SQUID(new ItemStack(Items.field_151115_aP), new ItemStack(Items.field_151115_aP), EntitySquid::new, () -> Float.valueOf(ModConfig.baits.squidChance)),
        RABBIT(new ItemStack(Items.field_151172_bF), new ItemStack(Items.field_151081_bc), EntityRabbit::new, () -> Float.valueOf(ModConfig.baits.rabbitChance)),
        HORSE(new ItemStack(Items.field_151153_ao), new ItemStack(Items.field_151153_ao), EntityHorse::new, () -> Float.valueOf(ModConfig.baits.horseChance)),
        DONKEY(new ItemStack(Items.field_151150_bK), new ItemStack(Items.field_151150_bK), EntityDonkey::new, () -> Float.valueOf(ModConfig.baits.donkeyChance)),
        POLAR_BEAR(new ItemStack(Items.field_151126_ay), new ItemStack(Items.field_151115_aP), EntityPolarBear::new, () -> Float.valueOf(ModConfig.baits.polarBearChance)),
        LLAMA(new ItemStack(Items.field_151015_O), new ItemStack(Items.field_151102_aT), EntityLlama::new, () -> Float.valueOf(ModConfig.baits.llamaChance)),
        PARROT(new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.RED.func_176767_b()), new ItemStack(Items.field_151100_aR, 1, EnumDyeColor.GREEN.func_176767_b()), EntityParrot::new, () -> Float.valueOf(ModConfig.baits.parrotChance));

        public static Type[] values;
        private ItemStack displayItemFirst;
        private ItemStack displayItemSecond;
        private Function<World, EntityLiving> entityFactory;
        private Supplier<Float> chanceSupplier;
        private List<TileBait.BaitBlockCondition> environmentConditions;

        private Type(ItemStack displayItemFirst, ItemStack displayItemSecond, Function<World, EntityLiving> entityFactory, Supplier<Float> chanceSupplier) {
            this.displayItemFirst = displayItemFirst;
            this.displayItemSecond = displayItemSecond;
            this.entityFactory = entityFactory;
            this.chanceSupplier = chanceSupplier;
        }

        @Nullable
        public static Type fromId(int id) {
            return id >= 0 && id < values.length ? values[id] : null;
        }

        public String func_176610_l() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }

        public EntityLiving createEntity(World world) {
            return this.entityFactory.apply(world);
        }

        public ItemStack getDisplayItemFirst() {
            ItemStack grassSeeds;
            if (this == SHEEP && !(grassSeeds = ExRegistro.getNihiloItem(ExNihiloProvider.NihiloItems.SEEDS_GRASS)).func_190926_b()) {
                return grassSeeds;
            }
            return this.displayItemFirst;
        }

        public ItemStack getDisplayItemSecond() {
            return this.displayItemSecond;
        }

        public float getChance() {
            return this.chanceSupplier.get().floatValue();
        }

        public Collection<TileBait.BaitBlockCondition> getEnvironmentConditions() {
            if (this.environmentConditions == null) {
                if (this == OCELOT || this == PARROT) {
                    this.environmentConditions = Lists.newArrayList((Object[])new TileBait.BaitBlockCondition[]{new TileBait.BaitBlockCondition(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)BlockPlanks.EnumType.JUNGLE), false), new TileBait.BaitBlockCondition(Blocks.field_150395_bd.func_176223_P(), true), new TileBait.BaitBlockCondition(Blocks.field_150392_bi.func_176223_P(), false), new TileBait.BaitBlockCondition(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)BlockPlanks.EnumType.JUNGLE), false)});
                } else if (this == SQUID) {
                    this.environmentConditions = Lists.newArrayList((Object[])new TileBait.BaitBlockCondition[]{new TileBait.BaitBlockCondition(Blocks.field_150355_j.func_176223_P(), true), new TileBait.BaitBlockCondition(Blocks.field_150358_i.func_176223_P(), true)});
                } else if (this == POLAR_BEAR) {
                    this.environmentConditions = Lists.newArrayList((Object[])new TileBait.BaitBlockCondition[]{new TileBait.BaitBlockCondition(Blocks.field_150355_j.func_176223_P(), true), new TileBait.BaitBlockCondition(Blocks.field_150358_i.func_176223_P(), true), new TileBait.BaitBlockCondition(Blocks.field_150433_aE.func_176223_P(), true), new TileBait.BaitBlockCondition(Blocks.field_150355_j.func_176223_P(), true), new TileBait.BaitBlockCondition(Blocks.field_150431_aC.func_176223_P(), true)});
                } else {
                    BlockPlanks.EnumType[] acceptedTrees = new BlockPlanks.EnumType[]{BlockPlanks.EnumType.OAK, BlockPlanks.EnumType.BIRCH, BlockPlanks.EnumType.SPRUCE, BlockPlanks.EnumType.ACACIA, BlockPlanks.EnumType.DARK_OAK};
                    this.environmentConditions = Lists.newArrayList((Object[])new TileBait.BaitBlockCondition[]{new TileBait.BaitBlockCondition(Blocks.field_150349_c.func_176223_P(), false), new TileBait.BaitBlockCondition(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.GRASS), false), new TileBait.BaitBlockCondition(Blocks.field_150329_H.func_176223_P().func_177226_a((IProperty)BlockTallGrass.field_176497_a, (Comparable)BlockTallGrass.EnumType.FERN), false)});
                    for (BlockPlanks.EnumType treeType : acceptedTrees) {
                        this.environmentConditions.add(new TileBait.BaitBlockCondition(Blocks.field_150345_g.func_176223_P().func_177226_a((IProperty)BlockSapling.field_176480_a, (Comparable)treeType), false));
                        if (BlockOldLog.field_176301_b.func_177700_c().contains(treeType)) {
                            this.environmentConditions.add(new TileBait.BaitBlockCondition(Blocks.field_150364_r.func_176223_P().func_177226_a((IProperty)BlockOldLog.field_176301_b, (Comparable)treeType), false));
                        }
                        if (!BlockNewLog.field_176300_b.func_177700_c().contains(treeType)) continue;
                        this.environmentConditions.add(new TileBait.BaitBlockCondition(Blocks.field_150363_s.func_176223_P().func_177226_a((IProperty)BlockNewLog.field_176300_b, (Comparable)treeType), false));
                    }
                }
            }
            return this.environmentConditions;
        }

        static {
            values = Type.values();
        }
    }
}

