/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum.block;

import com.mojang.authlib.GameProfile;
import java.util.List;
import javax.annotation.Nullable;
import net.blay09.mods.excompressum.ExCompressum;
import net.blay09.mods.excompressum.block.IUglyfiable;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.tile.TileAutoSieveBase;
import net.blay09.mods.excompressum.utils.DefaultItemHandler;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public abstract class BlockAutoSieveBase
extends BlockContainer
implements IUglyfiable {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;
    public static final PropertyBool UGLY = PropertyBool.func_177716_a((String)"ugly");
    private ItemStack lastHoverStack = ItemStack.field_190927_a;
    private String currentRandomName;

    protected BlockAutoSieveBase(Material material) {
        super(material);
        this.func_149647_a(ExCompressum.creativeTab);
        this.func_149711_c(2.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, UGLY});
    }

    public int func_176201_c(IBlockState state) {
        int i = ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal();
        if (((Boolean)state.func_177229_b((IProperty)UGLY)).booleanValue()) {
            i |= 8;
        }
        return i;
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta & 7));
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing).func_177226_a((IProperty)UGLY, (Comparable)Boolean.valueOf((meta & 8) == 8));
    }

    protected ItemStack func_180643_i(IBlockState state) {
        return new ItemStack((Block)this, 1, ((EnumFacing)state.func_177229_b((IProperty)FACING)).ordinal());
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K) {
            TileAutoSieveBase tileEntity;
            ItemStack heldItem = player.func_184586_b(hand);
            if (!heldItem.func_190926_b() && (tileEntity = (TileAutoSieveBase)world.func_175625_s(pos)) != null) {
                if (heldItem.func_77973_b() instanceof ItemFood) {
                    ItemFood itemFood = (ItemFood)heldItem.func_77973_b();
                    if (tileEntity.getFoodBoost() <= 1.0f) {
                        ItemStack returnStack;
                        tileEntity.setFoodBoost((int)(itemFood.func_150906_h(heldItem) * 640.0f), Math.max(1.0f, (float)itemFood.func_150905_g(heldItem) * 0.75f));
                        if (!player.field_71075_bZ.field_75098_d && (returnStack = itemFood.func_77654_b(heldItem, world, (EntityLivingBase)FakePlayerFactory.getMinecraft((WorldServer)((WorldServer)world)))) != heldItem) {
                            player.func_184611_a(hand, returnStack);
                        }
                        world.func_175718_b(2005, pos, 0);
                    }
                    return true;
                }
                if (heldItem.func_77973_b() == Items.field_151057_cb && heldItem.func_82837_s()) {
                    tileEntity.setCustomSkin(new GameProfile(null, heldItem.func_82833_r()));
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    return true;
                }
            }
            if (!player.func_70093_af()) {
                player.openGui((Object)ExCompressum.instance, 2, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity != null) {
            DefaultItemHandler itemHandler = ((TileAutoSieveBase)tileEntity).getItemHandler();
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack itemStack = itemHandler.getStackInSlot(i);
                if (itemStack.func_190926_b()) continue;
                EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), itemStack);
                double motion = 0.05;
                entityItem.field_70159_w = world.field_73012_v.nextGaussian() * motion;
                entityItem.field_70181_x = 0.2;
                entityItem.field_70179_y = world.field_73012_v.nextGaussian() * motion;
                world.func_72838_d((Entity)entityItem);
            }
            ItemStack currentStack = ((TileAutoSieveBase)tileEntity).getCurrentStack();
            if (!currentStack.func_190926_b()) {
                EntityItem entityItem = new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), currentStack);
                double motion = 0.05;
                entityItem.field_70159_w = world.field_73012_v.nextGaussian() * motion;
                entityItem.field_70181_x = 0.2;
                entityItem.field_70179_y = world.field_73012_v.nextGaussian() * motion;
                world.func_72838_d((Entity)entityItem);
            }
        }
        if (((Boolean)state.func_177229_b((IProperty)UGLY)).booleanValue()) {
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), new ItemStack(ModItems.uglySteelPlating)));
        }
        super.func_180663_b(world, pos, state);
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        EnumFacing facing = EnumFacing.func_190914_a((BlockPos)pos, (EntityLivingBase)placer);
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing = EnumFacing.NORTH;
        }
        return this.func_176203_a(meta).func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileAutoSieveBase tileEntity = (TileAutoSieveBase)world.func_175625_s(pos);
        if (tileEntity != null) {
            GameProfile customSkin;
            boolean useRandomSkin = true;
            NBTTagCompound tagCompound = stack.func_77978_p();
            if (tagCompound != null && tagCompound.func_74764_b("CustomSkin") && (customSkin = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("CustomSkin"))) != null) {
                tileEntity.setCustomSkin(customSkin);
                useRandomSkin = false;
            }
            if (!world.field_72995_K && useRandomSkin) {
                tileEntity.setCustomSkin(new GameProfile(null, AutoSieveSkinRegistry.getRandomSkin()));
            }
        }
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos pos) {
        TileEntity tileEntity = world.func_175625_s(pos);
        return tileEntity != null ? ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)((IItemHandler)tileEntity.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null))) : 0;
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        if (tagCompound != null && tagCompound.func_74764_b("CustomSkin")) {
            GameProfile customSkin = NBTUtil.func_152459_a((NBTTagCompound)tagCompound.func_74775_l("CustomSkin"));
            if (customSkin != null) {
                tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip." + this.getRegistryName()), (Object[])new Object[]{customSkin.getName()}));
            }
        } else {
            if (this.currentRandomName == null) {
                this.currentRandomName = AutoSieveSkinRegistry.getRandomSkin();
            }
            tooltip.add(TextFormatting.GRAY + I18n.func_135052_a((String)("tooltip." + this.getRegistryName()), (Object[])new Object[]{this.currentRandomName}));
        }
        if (this.lastHoverStack != stack) {
            this.currentRandomName = AutoSieveSkinRegistry.getRandomSkin();
            this.lastHoverStack = stack;
        }
    }

    @Override
    public boolean uglify(EntityPlayer player, World world, BlockPos pos, IBlockState state, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!((Boolean)state.func_177229_b((IProperty)UGLY)).booleanValue()) {
            world.func_180501_a(pos, state.func_177226_a((IProperty)UGLY, (Comparable)Boolean.valueOf(true)), 3);
            return true;
        }
        return false;
    }
}

