/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.excompressum;

import com.google.common.collect.Lists;
import java.io.File;
import java.util.List;
import java.util.Optional;
import net.blay09.mods.excompressum.CommandExCompressum;
import net.blay09.mods.excompressum.CommonProxy;
import net.blay09.mods.excompressum.ExCompressumCreativeTab;
import net.blay09.mods.excompressum.InternalMethods;
import net.blay09.mods.excompressum.api.ExCompressumAPI;
import net.blay09.mods.excompressum.block.BlockCompressed;
import net.blay09.mods.excompressum.block.ModBlocks;
import net.blay09.mods.excompressum.compat.IAddon;
import net.blay09.mods.excompressum.entity.EntityAngryChicken;
import net.blay09.mods.excompressum.handler.ChickenStickHandler;
import net.blay09.mods.excompressum.handler.CompressedCrookHandler;
import net.blay09.mods.excompressum.handler.CompressedEnemyHandler;
import net.blay09.mods.excompressum.handler.CompressedHammerHandler;
import net.blay09.mods.excompressum.handler.GuiHandler;
import net.blay09.mods.excompressum.handler.HammerHandler;
import net.blay09.mods.excompressum.item.ModItems;
import net.blay09.mods.excompressum.registry.AbstractRegistry;
import net.blay09.mods.excompressum.registry.AutoSieveSkinRegistry;
import net.blay09.mods.excompressum.registry.ExRegistro;
import net.blay09.mods.excompressum.registry.NihilisticNihiloProvider;
import net.blay09.mods.excompressum.registry.chickenstick.ChickenStickRegistry;
import net.blay09.mods.excompressum.registry.compressedhammer.CompressedHammerRegistry;
import net.blay09.mods.excompressum.registry.compressor.CompressedRecipeRegistry;
import net.blay09.mods.excompressum.registry.heavysieve.HeavySieveRegistry;
import net.blay09.mods.excompressum.registry.sievemesh.SieveMeshRegistry;
import net.blay09.mods.excompressum.registry.woodencrucible.WoodenCrucibleRegistry;
import net.minecraft.block.Block;
import net.minecraft.command.ICommand;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.IGuiHandler;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod.EventBusSubscriber(modid="excompressum")
@Mod(modid="excompressum", name="Ex Compressum", dependencies="after:exnihiloomnia;after:exnihiloadscensio;after:exnihilocreatio;", acceptedMinecraftVersions="[1.12]")
public class ExCompressum {
    public static final String MOD_ID = "excompressum";
    public static final Logger logger = LogManager.getLogger((String)"excompressum");
    @Mod.Instance
    public static ExCompressum instance;
    @SidedProxy(serverSide="net.blay09.mods.excompressum.CommonProxy", clientSide="net.blay09.mods.excompressum.client.ClientProxy")
    public static CommonProxy proxy;
    public static File configDir;
    public static final ExCompressumCreativeTab creativeTab;
    public final List<IAddon> addons = Lists.newArrayList();

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        ExCompressumAPI.__internalMethods = new InternalMethods();
        configDir = new File(event.getModConfigurationDirectory(), "ExCompressum");
        if (!configDir.exists() && !configDir.mkdirs()) {
            throw new RuntimeException("Couldn't create Ex Compressum configuration directory");
        }
        ModBlocks.registerTileEntities();
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocation(MOD_ID, "angry_chicken"), EntityAngryChicken.class, (String)"AngryChicken", (int)0, (Object)instance, (int)64, (int)10, (boolean)true);
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)this, (IGuiHandler)new GuiHandler());
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)new HammerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedHammerHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedCrookHandler());
        MinecraftForge.EVENT_BUS.register((Object)new CompressedEnemyHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ChickenStickHandler());
        this.registerAddon("exnihiloomnia", "net.blay09.mods.excompressum.compat.exnihiloomnia.ExNihiloOmniaAddon");
        this.registerAddon("exnihiloadscensio", "net.blay09.mods.excompressum.compat.exnihiloadscensio.ExNihiloAdscensioAddon");
        this.registerAddon("exnihilocreatio", "net.blay09.mods.excompressum.compat.exnihilocreatio.ExNihiloCreatioAddon");
        if (ExRegistro.instance == null) {
            logger.warn("No Ex Nihilo mod installed - many things will be disabled. Why would you run Ex Compressum without Ex Nihilo? Pfft.");
            ExRegistro.instance = new NihilisticNihiloProvider();
        }
        this.registerAddon("botania", "net.blay09.mods.excompressum.compat.botania.BotaniaAddon");
        this.registerAddon("tconstruct", "net.blay09.mods.excompressum.compat.tconstruct.TConstructAddon");
        MinecraftForge.EVENT_BUS.register((Object)proxy);
        for (IAddon addon : this.addons) {
            addon.preInit();
        }
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        FMLInterModComms.sendFunctionMessage((String)"theoneprobe", (String)"getTheOneProbe", (String)"net.blay09.mods.excompressum.compat.top.TheOneProbeAddon");
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"net.blay09.mods.excompressum.compat.waila.WailaProvider.register");
        for (IAddon addon : this.addons) {
            addon.init();
        }
        ChickenStickRegistry.INSTANCE.load(configDir);
        WoodenCrucibleRegistry.INSTANCE.load(configDir);
        CompressedHammerRegistry.INSTANCE.load(configDir);
        HeavySieveRegistry.INSTANCE.load(configDir);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        CompressedRecipeRegistry.reload();
        SieveMeshRegistry.registerDefaults();
        AutoSieveSkinRegistry.load();
        for (IAddon addon : this.addons) {
            addon.postInit();
        }
    }

    private Optional<?> buildSoftDependProxy(String modId, String className) {
        if (Loader.isModLoaded((String)modId)) {
            try {
                Class<?> clz = Class.forName(className, true, (ClassLoader)Loader.instance().getModClassLoader());
                return Optional.ofNullable(clz.newInstance());
            }
            catch (Exception e) {
                return Optional.empty();
            }
        }
        return Optional.empty();
    }

    private void registerAddon(String modid, String className) {
        Optional<?> optional = this.buildSoftDependProxy(modid, className);
        optional.ifPresent(o -> this.addons.add((IAddon)o));
    }

    @Mod.EventHandler
    public void serverStarting(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandExCompressum());
    }

    @SubscribeEvent
    public void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (AbstractRegistry.registryErrors.size() > 0) {
            event.player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "There were errors loading the Ex Compressum registries:"));
            TextFormatting lastFormatting = TextFormatting.WHITE;
            for (String error : AbstractRegistry.registryErrors) {
                event.player.func_145747_a((ITextComponent)new TextComponentString(lastFormatting + "* " + error));
                lastFormatting = lastFormatting == TextFormatting.GRAY ? TextFormatting.WHITE : TextFormatting.GRAY;
            }
        }
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.getModID().equals(MOD_ID)) {
            ConfigManager.sync((String)MOD_ID, (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        ModBlocks.register((IForgeRegistry<Block>)event.getRegistry());
        for (IAddon addon : ExCompressum.instance.addons) {
            addon.registerBlocks((IForgeRegistry<Block>)event.getRegistry());
        }
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        ModBlocks.registerItemBlocks((IForgeRegistry<Item>)event.getRegistry());
        ModItems.register((IForgeRegistry<Item>)event.getRegistry());
        for (IAddon addon : ExCompressum.instance.addons) {
            addon.registerItems((IForgeRegistry<Item>)event.getRegistry());
        }
        OreDictionary.registerOre((String)"dustWood", (ItemStack)new ItemStack(ModItems.woodChipping));
        OreDictionary.registerOre((String)"compressed1xDust", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.DUST.ordinal()));
        OreDictionary.registerOre((String)"compressed1xCobblestone", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.COBBLESTONE.ordinal()));
        OreDictionary.registerOre((String)"compressed1xGravel", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.GRAVEL.ordinal()));
        OreDictionary.registerOre((String)"compressed1xSand", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.SAND.ordinal()));
        OreDictionary.registerOre((String)"compressed1xDirt", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.DIRT.ordinal()));
        OreDictionary.registerOre((String)"compressed1xFlint", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.FLINT.ordinal()));
        OreDictionary.registerOre((String)"compressed1xEnderGravel", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.ENDER_GRAVEL.ordinal()));
        OreDictionary.registerOre((String)"compressed1xNetherGravel", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHER_GRAVEL.ordinal()));
        OreDictionary.registerOre((String)"compressed1xSoulsand", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.SOUL_SAND.ordinal()));
        OreDictionary.registerOre((String)"compressed1xNetherrack", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.NETHERRACK.ordinal()));
        OreDictionary.registerOre((String)"compressed1xEndStone", (ItemStack)new ItemStack(ModBlocks.compressedBlock, 1, BlockCompressed.Type.END_STONE.ordinal()));
    }

    @SubscribeEvent
    public static void registerEnchantments(RegistryEvent.Register<Enchantment> event) {
        for (IAddon addon : ExCompressum.instance.addons) {
            addon.registriesComplete();
        }
    }

    @SubscribeEvent
    public static void registerModels(ModelRegistryEvent event) {
        proxy.registerModels();
        ModBlocks.registerModels();
        ModItems.registerModels();
        for (IAddon addon : ExCompressum.instance.addons) {
            addon.registerModels();
        }
    }

    static {
        creativeTab = new ExCompressumCreativeTab();
    }
}

