/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol;

import com.bartz24.voidislandcontrol.AdminCommand;
import com.bartz24.voidislandcontrol.PlatformCommand;
import com.bartz24.voidislandcontrol.StartingInvCommand;
import com.bartz24.voidislandcontrol.VoidIslandControlSaveData;
import com.bartz24.voidislandcontrol.api.IslandManager;
import com.bartz24.voidislandcontrol.config.ConfigOptions;
import com.bartz24.voidislandcontrol.proxy.CommonProxy;
import net.minecraft.command.ICommand;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Logger;

@Mod(modid="voidislandcontrol", name="Void Island Control", useMetadata=true, acceptedMinecraftVersions="[1.12.2]")
public class VoidIslandControl {
    @SidedProxy(clientSide="com.bartz24.voidislandcontrol.proxy.ClientProxy", serverSide="com.bartz24.voidislandcontrol.proxy.ServerProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static VoidIslandControl instance;
    public static Logger logger;

    @Mod.EventHandler
    public void serverLoading(FMLServerStartingEvent event) {
        logger.info("Registering Void Island Control commands.");
        event.registerServerCommand((ICommand)new PlatformCommand());
        event.registerServerCommand((ICommand)new StartingInvCommand());
        event.registerServerCommand((ICommand)new AdminCommand());
        logger.info("Finished registering Void Island Control commands.");
        if (FMLCommonHandler.instance().getEffectiveSide() == Side.SERVER) {
            IslandManager.CurrentIslandsList.clear();
            IslandManager.spawnedPlayers.clear();
            IslandManager.worldOneChunk = false;
            IslandManager.initialIslandDistance = ConfigOptions.islandSettings.islandDistance;
            World world = event.getServer().func_130014_f_();
            if (!world.field_72995_K) {
                VoidIslandControlSaveData worldData = (VoidIslandControlSaveData)world.func_72943_a(VoidIslandControlSaveData.class, "VICData");
                if (worldData == null) {
                    worldData = new VoidIslandControlSaveData("VICData");
                    world.func_72823_a("VICData", (WorldSavedData)worldData);
                }
                VoidIslandControlSaveData.setInstance(world.field_73011_w.getDimension(), worldData);
            }
        }
    }

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        logger = event.getModLog();
        proxy.preInit(event);
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        proxy.init(event);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        proxy.postInit(event);
    }

    public VoidIslandControl() {
        FluidRegistry.enableUniversalBucket();
    }
}

