/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol;

import com.bartz24.voidislandcontrol.StructureLoader;
import com.bartz24.voidislandcontrol.api.IslandGen;
import com.bartz24.voidislandcontrol.api.IslandManager;
import com.bartz24.voidislandcontrol.config.ConfigOptions;
import com.bartz24.voidislandcontrol.world.GoGSupport;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Biomes;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.Loader;

public class IslandRegistry {
    public static void initIslands() {
        if (ConfigOptions.islandSettings.grassSettings.enableGrassIsland) {
            IslandManager.registerIsland(new IslandGen("grass", new BlockPos(0, 7, 0)){

                @Override
                public void generate(World world, BlockPos spawn) {
                    for (int x = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); x <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++x) {
                        for (int z = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); z <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++z) {
                            BlockPos pos = new BlockPos(spawn.func_177958_n() + x, spawn.func_177956_o(), spawn.func_177952_p() + z);
                            IBlockState topBlock = null;
                            switch (ConfigOptions.islandSettings.grassSettings.grassBlockType) {
                                case GRASS: {
                                    topBlock = Blocks.field_150349_c.func_176223_P();
                                    break;
                                }
                                case DIRT: {
                                    topBlock = Blocks.field_150346_d.func_176223_P();
                                    break;
                                }
                                case COARSEDIRT: {
                                    topBlock = Blocks.field_150346_d.func_176203_a(1);
                                }
                            }
                            world.func_180501_a(pos.func_177979_c(3), topBlock, 2);
                            if (ConfigOptions.islandSettings.bottomBlockType == ConfigOptions.IslandSettings.BottomBlockType.BEDROCK) {
                                world.func_180501_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P(), 2);
                                continue;
                            }
                            if (ConfigOptions.islandSettings.bottomBlockType != ConfigOptions.IslandSettings.BottomBlockType.SECONDARYBLOCK) continue;
                            world.func_180501_a(pos.func_177979_c(4), Blocks.field_150346_d.func_176223_P(), 2);
                        }
                    }
                    if (ConfigOptions.islandSettings.grassSettings.spawnTree) {
                        for (int y = 0; y < 5; ++y) {
                            for (int x = -2; x < 3; ++x) {
                                for (int z = -2; z < 3; ++z) {
                                    BlockPos pos = new BlockPos(spawn.func_177958_n() + x, spawn.func_177956_o() - 2 + y, spawn.func_177952_p() + z);
                                    if (x == 0 && z == 0) {
                                        if (y < 3) {
                                            world.func_180501_a(pos, Blocks.field_150364_r.func_176223_P(), 2);
                                            continue;
                                        }
                                        world.func_180501_a(pos, Blocks.field_150362_t.func_176223_P(), 2);
                                        continue;
                                    }
                                    if (y == 2 || y == 3) {
                                        world.func_180501_a(pos, Blocks.field_150362_t.func_176223_P(), 2);
                                        continue;
                                    }
                                    if (y != 4 || x < -1 || x > 1 || z < -1 || z > 1) continue;
                                    world.func_180501_a(pos, Blocks.field_150362_t.func_176223_P(), 2);
                                }
                            }
                        }
                    }
                    if (ConfigOptions.islandSettings.spawnChest) {
                        BlockPos pos = new BlockPos(spawn.func_177958_n(), spawn.func_177956_o() - 2, spawn.func_177952_p() - 1);
                        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                    }
                    IslandRegistry.changeBiome(spawn.func_177958_n(), spawn.func_177952_p(), world);
                }
            });
        }
        if (ConfigOptions.islandSettings.sandSettings.enableSandIsland) {
            IslandManager.registerIsland(new IslandGen("sand", new BlockPos(0, 2, 0)){

                @Override
                public void generate(World world, BlockPos spawn) {
                    for (int x = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); x <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++x) {
                        for (int z = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); z <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++z) {
                            BlockPos pos = new BlockPos(spawn.func_177958_n() + x, spawn.func_177956_o(), spawn.func_177952_p() + z);
                            world.func_180501_a(pos.func_177979_c(3), Blocks.field_150354_m.func_176203_a(ConfigOptions.islandSettings.sandSettings.sandBlockType == ConfigOptions.IslandSettings.SandBlockType.RED ? 1 : 0), 2);
                            if (ConfigOptions.islandSettings.bottomBlockType == ConfigOptions.IslandSettings.BottomBlockType.BEDROCK) {
                                world.func_180501_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P(), 2);
                                continue;
                            }
                            if (ConfigOptions.islandSettings.bottomBlockType != ConfigOptions.IslandSettings.BottomBlockType.SECONDARYBLOCK) continue;
                            world.func_180501_a(pos.func_177979_c(4), ConfigOptions.islandSettings.sandSettings.sandBlockType == ConfigOptions.IslandSettings.SandBlockType.NORMAL ? Blocks.field_150322_A.func_176223_P() : Blocks.field_180395_cM.func_176223_P(), 2);
                        }
                    }
                    BlockPos pos = new BlockPos(spawn.func_177958_n() - 1, spawn.func_177956_o(), spawn.func_177952_p() + 1);
                    if (ConfigOptions.islandSettings.sandSettings.spawnCactus) {
                        world.func_180501_a(pos.func_177979_c(2), Blocks.field_150434_aF.func_176223_P(), 2);
                        world.func_180501_a(pos.func_177979_c(1), Blocks.field_150434_aF.func_176223_P(), 2);
                        world.func_180501_a(pos, Blocks.field_150434_aF.func_176223_P(), 2);
                    }
                    if (ConfigOptions.islandSettings.spawnChest) {
                        pos = new BlockPos(spawn.func_177958_n(), spawn.func_177956_o() - 2, spawn.func_177952_p() - 1);
                        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                    }
                    IslandRegistry.changeBiome(spawn.func_177958_n(), spawn.func_177952_p(), world);
                }
            });
        }
        if (ConfigOptions.islandSettings.snowSettings.enableSnowIsland) {
            IslandManager.registerIsland(new IslandGen("snow", new BlockPos(0, 2, 0)){

                @Override
                public void generate(World world, BlockPos spawn) {
                    for (int x = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)) - 1; x <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f) + 1; ++x) {
                        for (int z = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)) - 1; z <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f) + 1; ++z) {
                            BlockPos pos = new BlockPos(spawn.func_177958_n() + x, spawn.func_177956_o(), spawn.func_177952_p() + z);
                            BlockPos blockPos = new BlockPos((Vec3i)pos);
                            if (world.func_180494_b(pos).func_180626_a(blockPos) > 1.0f) {
                                world.func_175726_f((BlockPos)pos).func_76605_m()[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)Biomes.field_76772_c);
                            }
                            if (x == -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)) - 1 || x == (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f) + 1 || z == -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)) - 1 || z == (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f) + 1) {
                                if (!ConfigOptions.islandSettings.snowSettings.spawnIgloo) continue;
                                world.func_180501_a(pos.func_177979_c(3), Blocks.field_150403_cj.func_176223_P(), 2);
                                world.func_180501_a(pos.func_177979_c(2), Blocks.field_150403_cj.func_176223_P(), 2);
                                world.func_180501_a(pos.func_177979_c(1), Blocks.field_150403_cj.func_176223_P(), 2);
                                continue;
                            }
                            if ((x != 0 || z != 0) && ConfigOptions.islandSettings.snowSettings.spawnIgloo) {
                                world.func_180501_a(pos, Blocks.field_150403_cj.func_176223_P(), 2);
                            }
                            world.func_180501_a(pos.func_177979_c(3), Blocks.field_150433_aE.func_176223_P(), 2);
                            if (ConfigOptions.islandSettings.bottomBlockType == ConfigOptions.IslandSettings.BottomBlockType.BEDROCK) {
                                world.func_180501_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P(), 2);
                            } else if (ConfigOptions.islandSettings.bottomBlockType == ConfigOptions.IslandSettings.BottomBlockType.SECONDARYBLOCK) {
                                world.func_180501_a(pos.func_177979_c(4), Blocks.field_150403_cj.func_176223_P(), 2);
                            }
                            if ((x == -1 && z == 1 || x == 1 && z == 1) && ConfigOptions.islandSettings.snowSettings.spawnPumpkins) {
                                world.func_180501_a(pos.func_177979_c(2), Blocks.field_150423_aK.func_176223_P(), 2);
                                continue;
                            }
                            world.func_180501_a(pos.func_177979_c(2), Blocks.field_150431_aC.func_176223_P(), 2);
                        }
                    }
                    if (ConfigOptions.islandSettings.spawnChest) {
                        BlockPos pos = new BlockPos(spawn.func_177958_n(), spawn.func_177956_o() - 2, spawn.func_177952_p() - 1);
                        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                    }
                    IslandRegistry.changeBiome(spawn.func_177958_n(), spawn.func_177952_p(), world);
                }
            });
        }
        if (ConfigOptions.islandSettings.woodSettings.enableWoodIsland) {
            IslandManager.registerIsland(new IslandGen("wood", new BlockPos(0, 2, 0)){

                @Override
                public void generate(World world, BlockPos spawn) {
                    for (int x = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); x <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++x) {
                        for (int z = -((int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f)); z <= (int)Math.floor((float)ConfigOptions.islandSettings.islandSize / 2.0f); ++z) {
                            BlockPos pos = new BlockPos(spawn.func_177958_n() + x, spawn.func_177956_o(), spawn.func_177952_p() + z);
                            BlockPos blockPos = new BlockPos((Vec3i)pos);
                            if (world.func_180494_b(pos).func_180626_a(blockPos) < 0.5f) {
                                world.func_175726_f((BlockPos)pos).func_76605_m()[(pos.func_177952_p() & 0xF) << 4 | pos.func_177958_n() & 0xF] = (byte)Biome.func_185362_a((Biome)Biomes.field_76772_c);
                            }
                            if (x == 0 && z == 0 && ConfigOptions.islandSettings.woodSettings.spawnWater) {
                                world.func_180501_a(pos.func_177979_c(3), Blocks.field_150355_j.func_176223_P(), 2);
                            } else {
                                world.func_180501_a(pos.func_177979_c(3), Blocks.field_150344_f.func_176203_a(ConfigOptions.islandSettings.woodSettings.woodBlockType.ordinal()), 2);
                            }
                            if (ConfigOptions.islandSettings.bottomBlockType == ConfigOptions.IslandSettings.BottomBlockType.BEDROCK) {
                                world.func_180501_a(pos.func_177979_c(4), Blocks.field_150357_h.func_176223_P(), 2);
                                continue;
                            }
                            if (ConfigOptions.islandSettings.bottomBlockType != ConfigOptions.IslandSettings.BottomBlockType.SECONDARYBLOCK) continue;
                            world.func_180501_a(pos.func_177979_c(4), Blocks.field_150344_f.func_176203_a(ConfigOptions.islandSettings.woodSettings.woodBlockType.ordinal()), 2);
                        }
                    }
                    BlockPos pos = new BlockPos(spawn.func_177958_n() - 1, spawn.func_177956_o(), spawn.func_177952_p() + 1);
                    if (ConfigOptions.islandSettings.woodSettings.spawnString) {
                        world.func_180501_a(pos.func_177979_c(2), Blocks.field_150473_bD.func_176223_P(), 2);
                    }
                    if (ConfigOptions.islandSettings.spawnChest) {
                        pos = new BlockPos(spawn.func_177958_n(), spawn.func_177956_o() - 2, spawn.func_177952_p() - 1);
                        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                    }
                    IslandRegistry.changeBiome(spawn.func_177958_n(), spawn.func_177952_p(), world);
                }
            });
        }
        if (IslandRegistry.isValidGoG()) {
            IslandManager.registerIsland(new IslandGen("gog", new BlockPos(0, 2, 0)){

                @Override
                public void generate(World world, BlockPos spawn) {
                    GoGSupport.spawnGoGIsland(world, spawn);
                    if (ConfigOptions.islandSettings.spawnChest) {
                        BlockPos pos = new BlockPos(spawn.func_177958_n(), spawn.func_177956_o() - 2, spawn.func_177952_p() - 1);
                        world.func_175656_a(pos, Blocks.field_150486_ae.func_176223_P());
                    }
                    IslandRegistry.changeBiome(spawn.func_177958_n(), spawn.func_177952_p(), world);
                }
            });
        }
        if (ConfigOptions.islandSettings.customIslands.length > 0) {
            for (final String s : ConfigOptions.islandSettings.customIslands) {
                IslandManager.registerIsland(new IslandGen(s, IslandRegistry.getCustomIslandSpawnPoint(s)){

                    @Override
                    public void generate(World world, BlockPos spawn) {
                        IslandRegistry.generateCustomIsland(s, world, spawn);
                        IslandRegistry.changeBiome(spawn.func_177958_n(), spawn.func_177952_p(), world);
                    }
                });
            }
        }
    }

    public static boolean isValidGoG() {
        return ConfigOptions.islandSettings.gogSettings.enableGoGIsland && Loader.isModLoaded((String)"botania") && Loader.isModLoaded((String)"gardenofglass");
    }

    private static void changeBiome(int xIs, int zIs, World world) {
        if (ConfigOptions.islandSettings.islandBiomeID >= 0) {
            for (int x = xIs - (int)Math.floor((float)ConfigOptions.islandSettings.islandBiomeRange / 2.0f); x <= xIs + (int)Math.floor((float)ConfigOptions.islandSettings.islandBiomeRange / 2.0f); ++x) {
                for (int z = zIs - (int)Math.floor((float)ConfigOptions.islandSettings.islandBiomeRange / 2.0f); z <= zIs + (int)Math.floor((float)ConfigOptions.islandSettings.islandBiomeRange / 2.0f); ++z) {
                    world.func_175726_f((BlockPos)new BlockPos((int)x, (int)64, (int)z)).func_76605_m()[(new BlockPos((int)x, (int)64, (int)z).func_177952_p() & 0xF) << 4 | new BlockPos((int)x, (int)64, (int)z).func_177958_n() & 0xF] = (byte)ConfigOptions.islandSettings.islandBiomeID;
                }
            }
        }
    }

    private static BlockPos getCustomIslandSpawnPoint(String id) {
        Template t = StructureLoader.tempManager.get(null, new ResourceLocation(id));
        if (t != null) {
            PlacementSettings settings = new PlacementSettings().func_186226_b(false);
            BlockPos genPos = new BlockPos(-t.func_186259_a().func_177958_n() / 2, 0, -t.func_186259_a().func_177952_p() / 2);
            Map dataBlocks = t.func_186258_a(new BlockPos(0, 0, 0), settings);
            for (BlockPos dataPos : dataBlocks.keySet()) {
                switch ((String)dataBlocks.get(dataPos)) {
                    case "spawn_point": {
                        return dataPos.func_177971_a((Vec3i)genPos);
                    }
                }
            }
        }
        return new BlockPos(0, 0, 0);
    }

    private static void generateCustomIsland(String id, World world, BlockPos pos) {
        Template t = StructureLoader.tempManager.get(world.func_73046_m(), new ResourceLocation(id));
        if (t != null) {
            BlockPos genPos = new BlockPos(pos.func_177958_n() - t.func_186259_a().func_177958_n() / 2, pos.func_177956_o(), pos.func_177952_p() - t.func_186259_a().func_177952_p() / 2);
            PlacementSettings settings = new PlacementSettings().func_186226_b(false);
            t.func_189962_a(world, genPos, settings, 3);
            Map dataBlocks = t.func_186258_a(genPos, settings);
            for (BlockPos dataPos : dataBlocks.keySet()) {
                switch ((String)dataBlocks.get(dataPos)) {
                    case "spawn_point": {
                        world.func_175698_g(dataPos);
                    }
                }
            }
        } else {
            world.func_175656_a(pos.func_177979_c(2), Blocks.field_150357_h.func_176223_P());
        }
    }
}

