/*
 * Decompiled with CFR 0.152.
 */
package com.bartz24.voidislandcontrol;

import com.bartz24.voidislandcontrol.EventHandler;
import com.bartz24.voidislandcontrol.api.IslandManager;
import com.bartz24.voidislandcontrol.api.IslandPos;
import com.bartz24.voidislandcontrol.config.ConfigOptions;
import com.bartz24.voidislandcontrol.world.WorldTypeVoid;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.GameType;
import net.minecraft.world.World;

public class AdminCommand
extends CommandBase
implements ICommand {
    private static List<String> aliases;

    public AdminCommand() {
        aliases = new ArrayList<String>();
        aliases.add("islandAdmin");
    }

    public List<String> func_71514_a() {
        return aliases;
    }

    public int func_82362_a() {
        return 2;
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            return AdminCommand.func_71530_a((String[])args, (String[])new String[]{"assign", "kick", "getIslandHere", "assignOwner"});
        }
        String subCommand = args[0];
        if ((subCommand = subCommand.trim()).equals("kick") || subCommand.equals("assign") || subCommand.equals("assignOwner")) {
            return args.length == 2 ? AdminCommand.func_71530_a((String[])args, (String[])server.func_71213_z()) : Collections.emptyList();
        }
        return Collections.emptyList();
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        World world = sender.func_130014_f_();
        EntityPlayerMP player = (EntityPlayerMP)world.func_72924_a(sender.func_174793_f().func_70005_c_());
        if (!(world.func_72912_H().func_76067_t() instanceof WorldTypeVoid)) {
            player.func_145747_a((ITextComponent)new TextComponentString("You are not in a void world type."));
            return;
        }
        if (args.length == 0) {
            this.showHelp(player);
        } else {
            String subCommand = args[0];
            if ((subCommand = subCommand.trim()).equals("kick")) {
                AdminCommand.kick(player, args);
            } else if (subCommand.equals("assign")) {
                AdminCommand.assign(player, args);
            } else if (subCommand.equals("assignOwner")) {
                AdminCommand.assignOwner(player, args);
            } else if (subCommand.equals("getIslandHere")) {
                AdminCommand.getIsland(player, args);
            } else if (subCommand.equals("list")) {
                AdminCommand.listIslands(player, args);
            }
        }
    }

    public static void kick(EntityPlayerMP player, String[] args) throws CommandException {
        if (args.length != 2) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 1 argument."));
            return;
        }
        if (IslandManager.worldOneChunk) {
            player.func_145747_a((ITextComponent)new TextComponentString("Can't use this command in this mode."));
            return;
        }
        EntityPlayerMP player2 = (EntityPlayerMP)player.func_130014_f_().func_72924_a(args[1]);
        IslandPos isPos = IslandManager.getPlayerIsland(player2.func_146103_bH().getId());
        if (args[1].equals(player.func_70005_c_())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Why are you kicking yourself."));
            return;
        }
        if (isPos == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("Player doesn't exist or player doesn't have an island."));
            return;
        }
        if (!isPos.getPlayerUUIDs().contains(player2.func_146103_bH().getId())) {
            player.func_145747_a((ITextComponent)new TextComponentString("Player isn't on your island."));
            return;
        }
        for (int i = 0; i < player2.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player2.field_71071_by.func_70301_a(i).func_77946_l();
            EntityItem item = new EntityItem(player.field_70170_p);
            item.func_92058_a(stack);
            item.field_70165_t = player.field_70165_t;
            item.field_70163_u = player.field_70163_u;
            item.field_70161_v = player.field_70161_v;
            player.field_70170_p.func_72838_d((Entity)item);
        }
        EventHandler.spawnPlayer((EntityPlayer)player2, new BlockPos(0, ConfigOptions.islandSettings.islandYLevel, 0), false);
        player2.func_145747_a((ITextComponent)new TextComponentString("You have been kicked..."));
    }

    public static void assignOwner(EntityPlayerMP player, String[] args) throws CommandException {
        if (args.length != 2) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 1 argument."));
            return;
        }
        EntityPlayerMP player2 = (EntityPlayerMP)player.func_130014_f_().func_72924_a(args[1]);
        IslandPos isPos = IslandManager.getPlayerIsland(player2.func_146103_bH().getId());
        isPos.getPlayerUUIDs().set(0, isPos.getPlayerUUIDs().remove(isPos.getPlayerUUIDs().indexOf(player2.func_146103_bH().getId())));
        for (String name : isPos.getPlayerUUIDs()) {
            EntityPlayerMP p = (EntityPlayerMP)player.field_70170_p.func_72924_a(name);
            if (p == null) continue;
            p.func_145747_a((ITextComponent)new TextComponentString(player2.func_70005_c_() + " is now the owner of the island!"));
        }
        player.func_145747_a((ITextComponent)new TextComponentString(player2.func_70005_c_() + " is now the owner of the island!"));
    }

    void showHelp(EntityPlayerMP player) {
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "kick <player>" + TextFormatting.WHITE + " : Kick a player from their island"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "assign <player> islandX islandY" + TextFormatting.WHITE + " : Assign a player to an island. Use island coordinates (found using getIslandHere), not real coordinates"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "assignOwner <player>" + TextFormatting.WHITE + " : Sets the player as the owner of their island"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "getIslandHere" + TextFormatting.WHITE + " : Shows the island coordinates of the island the player is at and what players are on that island"));
        player.func_145747_a((ITextComponent)new TextComponentString(TextFormatting.RED + "list" + TextFormatting.WHITE + " : Lists the islands"));
    }

    public static void assign(EntityPlayerMP player, String[] args) throws CommandException {
        EntityPlayerMP player2 = (EntityPlayerMP)player.func_130014_f_().func_72924_a(args[1]);
        if (args.length != 4) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have 3 arguments."));
            return;
        }
        IslandPos position = IslandManager.getIslandAtPos(Integer.parseInt(args[2]), Integer.parseInt(args[3]));
        if (position == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("This island does not exist"));
            return;
        }
        IslandManager.addPlayer(player2.func_146103_bH().getId(), position);
        for (String name : position.getPlayerUUIDs()) {
            EntityPlayerMP p = (EntityPlayerMP)player.field_70170_p.func_72924_a(name);
            if (p == null) continue;
            p.func_145747_a((ITextComponent)new TextComponentString(player2.func_70005_c_() + " joined your island!"));
        }
        if (IslandManager.hasVisitLoc((EntityPlayer)player2)) {
            player2.func_71033_a(GameType.SURVIVAL);
            IslandManager.removeVisitLoc((EntityPlayer)player2);
        }
        IslandManager.tpPlayerToPosSpawn((EntityPlayer)player2, new BlockPos(position.getX() * ConfigOptions.islandSettings.islandDistance, ConfigOptions.islandSettings.islandYLevel, position.getY() * ConfigOptions.islandSettings.islandDistance), position);
    }

    public static void getIsland(EntityPlayerMP player, String[] args) throws CommandException {
        if (args.length != 1) {
            player.func_145747_a((ITextComponent)new TextComponentString("Must have no arguments."));
            return;
        }
        IslandPos position = IslandManager.getIslandAtPos((int)Math.round(player.field_70165_t / (double)ConfigOptions.islandSettings.islandDistance), (int)Math.round(player.field_70161_v / (double)ConfigOptions.islandSettings.islandDistance));
        if (position == null) {
            player.func_145747_a((ITextComponent)new TextComponentString("No island here"));
            return;
        }
        player.func_145747_a((ITextComponent)new TextComponentString("X: " + position.getX() + ", Y: " + position.getY()));
        player.func_145747_a((ITextComponent)new TextComponentString("Player UUIDs: "));
        for (String s : position.getPlayerUUIDs()) {
            player.func_145747_a((ITextComponent)new TextComponentString(s));
        }
    }

    public static void listIslands(EntityPlayerMP player, String[] args) throws CommandException {
        int index = 0;
        for (IslandPos position : IslandManager.CurrentIslandsList) {
            if (position == null) continue;
            player.func_145747_a((ITextComponent)new TextComponentString("Island " + index));
            player.func_145747_a((ITextComponent)new TextComponentString("X: " + position.getX() + ", Y: " + position.getY()));
            player.func_145747_a((ITextComponent)new TextComponentString("Player UUIDs: "));
            for (String s : position.getPlayerUUIDs()) {
                player.func_145747_a((ITextComponent)new TextComponentString(s));
            }
            ++index;
        }
    }

    public String func_71517_b() {
        return aliases.get(0);
    }

    public String func_71518_a(ICommandSender sender) {
        return ConfigOptions.commandSettings.commandName;
    }
}

