/*
 * Decompiled with CFR 0.152.
 */
package thelm.packagedexcrafting.proxy;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thelm.packagedauto.api.IRecipeType;
import thelm.packagedauto.api.RecipeTypeRegistry;
import thelm.packagedexcrafting.block.BlockAdvancedCrafter;
import thelm.packagedexcrafting.block.BlockBasicCrafter;
import thelm.packagedexcrafting.block.BlockCombinationCrafter;
import thelm.packagedexcrafting.block.BlockEliteCrafter;
import thelm.packagedexcrafting.block.BlockEnderCrafter;
import thelm.packagedexcrafting.block.BlockMarkedPedestal;
import thelm.packagedexcrafting.block.BlockUltimateCrafter;
import thelm.packagedexcrafting.config.PackagedExCraftingConfig;
import thelm.packagedexcrafting.recipe.RecipeTypeAdvanced;
import thelm.packagedexcrafting.recipe.RecipeTypeBasic;
import thelm.packagedexcrafting.recipe.RecipeTypeCombination;
import thelm.packagedexcrafting.recipe.RecipeTypeElite;
import thelm.packagedexcrafting.recipe.RecipeTypeEnder;
import thelm.packagedexcrafting.recipe.RecipeTypeUltimate;
import thelm.packagedexcrafting.tile.TileAdvancedCrafter;
import thelm.packagedexcrafting.tile.TileBasicCrafter;
import thelm.packagedexcrafting.tile.TileCombinationCrafter;
import thelm.packagedexcrafting.tile.TileEliteCrafter;
import thelm.packagedexcrafting.tile.TileEnderCrafter;
import thelm.packagedexcrafting.tile.TileMarkedPedestal;
import thelm.packagedexcrafting.tile.TileUltimateCrafter;

public class CommonProxy {
    public void registerBlock(Block block) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)block);
    }

    public void registerItem(Item item) {
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)item);
    }

    public void register(FMLPreInitializationEvent event) {
        this.registerConfig(event);
        this.registerBlocks();
        this.registerItems();
        this.registerModels();
        this.registerTileEntities();
        this.registerRecipeTypes();
    }

    protected void registerConfig(FMLPreInitializationEvent event) {
        PackagedExCraftingConfig.init(event.getSuggestedConfigurationFile());
    }

    protected void registerBlocks() {
        if (TileBasicCrafter.enabled) {
            this.registerBlock((Block)BlockBasicCrafter.INSTANCE);
        }
        if (TileAdvancedCrafter.enabled) {
            this.registerBlock((Block)BlockAdvancedCrafter.INSTANCE);
        }
        if (TileEliteCrafter.enabled) {
            this.registerBlock((Block)BlockEliteCrafter.INSTANCE);
        }
        if (TileUltimateCrafter.enabled) {
            this.registerBlock((Block)BlockUltimateCrafter.INSTANCE);
        }
        if (TileEnderCrafter.enabled) {
            this.registerBlock((Block)BlockEnderCrafter.INSTANCE);
        }
        if (TileCombinationCrafter.enabled) {
            this.registerBlock((Block)BlockCombinationCrafter.INSTANCE);
            this.registerBlock((Block)BlockMarkedPedestal.INSTANCE);
        }
    }

    protected void registerItems() {
        if (TileBasicCrafter.enabled) {
            this.registerItem(BlockBasicCrafter.ITEM_INSTANCE);
        }
        if (TileAdvancedCrafter.enabled) {
            this.registerItem(BlockAdvancedCrafter.ITEM_INSTANCE);
        }
        if (TileEliteCrafter.enabled) {
            this.registerItem(BlockEliteCrafter.ITEM_INSTANCE);
        }
        if (TileUltimateCrafter.enabled) {
            this.registerItem(BlockUltimateCrafter.ITEM_INSTANCE);
        }
        if (TileEnderCrafter.enabled) {
            this.registerItem(BlockEnderCrafter.ITEM_INSTANCE);
        }
        if (TileCombinationCrafter.enabled) {
            this.registerItem(BlockCombinationCrafter.ITEM_INSTANCE);
            this.registerItem(BlockMarkedPedestal.ITEM_INSTANCE);
        }
    }

    protected void registerModels() {
    }

    protected void registerTileEntities() {
        if (TileBasicCrafter.enabled) {
            GameRegistry.registerTileEntity(TileBasicCrafter.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:basic_crafter"));
        }
        if (TileAdvancedCrafter.enabled) {
            GameRegistry.registerTileEntity(TileAdvancedCrafter.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:advanced_crafter"));
        }
        if (TileEliteCrafter.enabled) {
            GameRegistry.registerTileEntity(TileEliteCrafter.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:elite_crafter"));
        }
        if (TileUltimateCrafter.enabled) {
            GameRegistry.registerTileEntity(TileUltimateCrafter.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:ultimate_crafter"));
        }
        if (TileEnderCrafter.enabled) {
            GameRegistry.registerTileEntity(TileEnderCrafter.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:ender_crafter"));
        }
        if (TileCombinationCrafter.enabled) {
            GameRegistry.registerTileEntity(TileCombinationCrafter.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:conbination_crafter"));
            GameRegistry.registerTileEntity(TileMarkedPedestal.class, (ResourceLocation)new ResourceLocation("packagedexcrafting:marked_pedestal"));
        }
    }

    protected void registerRecipeTypes() {
        if (TileBasicCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeBasic.INSTANCE);
        }
        if (TileAdvancedCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeAdvanced.INSTANCE);
        }
        if (TileEliteCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeElite.INSTANCE);
        }
        if (TileUltimateCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeUltimate.INSTANCE);
        }
        if (TileEnderCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeEnder.INSTANCE);
        }
        if (TileCombinationCrafter.enabled) {
            RecipeTypeRegistry.registerRecipeType((IRecipeType)RecipeTypeCombination.INSTANCE);
        }
    }
}

