/*
 * Decompiled with CFR 0.152.
 */
package com.enderio.core.common.util;

import com.enderio.core.EnderCore;
import com.enderio.core.common.vecmath.Vector3f;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class ItemUtil {
    public static void spawnItemInWorldWithRandomMotion(@Nonnull World world, @Nonnull ItemStack item, @Nonnull BlockPos pos) {
        ItemUtil.spawnItemInWorldWithRandomMotion(world, item, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
    }

    public static void spawnItemInWorldWithRandomMotion(@Nonnull World world, @Nonnull ItemStack item, int x, int y, int z) {
        if (!item.func_190926_b()) {
            ItemUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5, item));
        }
    }

    public static void spawnItemInWorldWithRandomMotion(@Nonnull World world, @Nonnull ItemStack item, @Nonnull BlockPos pos, float hitX, float hitY, float hitZ, float scale) {
        Vector3f v = new Vector3f(hitX - 0.5f, hitY - 0.5f, hitZ - 0.5f);
        v.normalize();
        v.scale(scale);
        float x = (float)pos.func_177958_n() + 0.5f + v.x;
        float y = (float)pos.func_177956_o() + 0.5f + v.y;
        float z = (float)pos.func_177952_p() + 0.5f + v.z;
        ItemUtil.spawnItemInWorldWithRandomMotion(new EntityItem(world, (double)x, (double)y, (double)z, item));
    }

    public static void spawnItemInWorldWithRandomMotion(@Nonnull EntityItem entity) {
        entity.func_174869_p();
        entity.field_70170_p.func_72838_d((Entity)entity);
    }

    public static boolean itemStackMatchesOredict(@Nonnull ItemStack stack, String oredict) {
        int[] ids;
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)stack)) {
            String name = OreDictionary.getOreName((int)i);
            if (!name.equals(oredict)) continue;
            return true;
        }
        return false;
    }

    public static String getDurabilityString(@Nonnull ItemStack item) {
        if (item.func_190926_b()) {
            return null;
        }
        return EnderCore.lang.localize("tooltip.durability") + " " + (item.func_77958_k() - item.func_77952_i()) + "/" + item.func_77958_k();
    }

    public static NBTTagCompound getOrCreateNBT(ItemStack stack) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static boolean isStackFull(@Nonnull ItemStack contents) {
        return contents.func_190916_E() >= contents.func_77976_d();
    }

    public static boolean areStackMergable(@Nonnull ItemStack s1, @Nonnull ItemStack s2) {
        if (s1.func_190926_b() || s2.func_190926_b() || !s1.func_77985_e() || !s2.func_77985_e()) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static boolean areStacksEqual(@Nonnull ItemStack s1, @Nonnull ItemStack s2) {
        if (s1.func_190926_b() || s2.func_190926_b()) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static boolean areStacksEqualIgnoringDamage(@Nonnull ItemStack s1, @Nonnull ItemStack s2) {
        if (s1.func_190926_b() || s2.func_190926_b()) {
            return false;
        }
        if (!s1.func_185136_b(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    @Nonnull
    public static ItemStack fakeItemPickup(@Nonnull EntityPlayer player, @Nonnull ItemStack itemstack) {
        if (!player.field_70170_p.field_72995_K) {
            EntityItem entityItem = new EntityItem(player.field_70170_p, player.field_70165_t, player.field_70163_u, player.field_70161_v, itemstack);
            entityItem.func_70100_b_(player);
            if (entityItem.field_70128_L) {
                return ItemStack.field_190927_a;
            }
            entityItem.func_70106_y();
            return entityItem.func_92059_d();
        }
        return itemstack;
    }
}

