/*
 * Decompiled with CFR 0.152.
 */
package p455w0rdslib.util;

import java.util.List;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import p455w0rdslib.util.EasyMappings;
import p455w0rdslib.util.MCUtils;
import p455w0rdslib.util.MathUtils;

public class EntityUtils {
    public static Entity getRenderViewEntity() {
        return Minecraft.func_71410_x().func_175606_aa();
    }

    public static List<Entity> getEntitiesInRange(Class<? extends Entity> entityType, World world, double x, double y, double z, double radius) {
        return world.func_72872_a(entityType, new AxisAlignedBB(x - radius, y - radius, z - radius, x + radius, y + radius, z + radius));
    }

    public static IBlockState getBlockStateBelowEntity(Entity entity, int depth) {
        int blockX = MathUtils.floor(entity.field_70165_t);
        int blockY = MathUtils.floor(entity.func_174813_aQ().field_72338_b - (double)depth);
        int blockZ = MathUtils.floor(entity.field_70161_v);
        return EasyMappings.world(entity).func_180495_p(new BlockPos(blockX, blockY, blockZ));
    }

    public static Block getBlockBelowEntity(Entity entity, int depth) {
        return EntityUtils.getBlockStateBelowEntity(entity, depth).func_177230_c();
    }

    public static IBlockState getBlockStateAboveEntity(Entity entity, int depth) {
        int blockX = MathUtils.floor(entity.field_70165_t);
        int blockY = MathUtils.floor(entity.func_174813_aQ().field_72337_e + (double)depth);
        int blockZ = MathUtils.floor(entity.field_70161_v);
        return EasyMappings.world(entity).func_180495_p(new BlockPos(blockX, blockY, blockZ));
    }

    public static Block getBlockAboveEntity(Entity entity, int depth) {
        return EntityUtils.getBlockStateAboveEntity(entity, depth).func_177230_c();
    }

    public static boolean isBlockAboveEntity(Entity entity, Block block, int depth) {
        World world = entity.func_130014_f_();
        int blockX = MathUtils.ceil(entity.field_70165_t - 1.0);
        int blockY = MathUtils.ceil(entity.field_70163_u + (double)depth);
        int blockZ = MathUtils.ceil(entity.field_70161_v - 1.0);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                if (!world.func_180495_p(new BlockPos(blockX + i + j, blockY, blockZ + i + j)).func_177230_c().equals(block)) continue;
                return true;
            }
        }
        return false;
    }

    public static BlockPos getPosBelowEntity(Entity entity, int depth) {
        int blockX = MathUtils.floor(entity.field_70165_t);
        int blockY = MathUtils.floor(entity.func_174813_aQ().field_72338_b - (double)depth);
        int blockZ = MathUtils.floor(entity.field_70161_v);
        return new BlockPos(blockX, blockY, blockZ);
    }

    public static Entity cloneEntity(Entity sourceEntity) {
        Entity clonedEntity = null;
        NBTTagCompound entityNBT = sourceEntity.serializeNBT();
        if (entityNBT != null && !entityNBT.func_82582_d() && entityNBT.func_186856_d() > 0) {
            clonedEntity = EntityList.func_75615_a((NBTTagCompound)entityNBT, (World)MCUtils.getWorld());
        } else {
            Class<?> clazz = sourceEntity.getClass();
            try {
                clonedEntity = (Entity)clazz.getConstructor(World.class).newInstance(MCUtils.getWorld());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return clonedEntity;
    }

    public static Entity getEntityByUUID(World world, UUID uuid) {
        for (Entity entity : world.func_72910_y()) {
            if (entity.func_110124_au() != uuid) continue;
            return entity;
        }
        return null;
    }

    public static void copyDataFromOld(Entity oldEntity, Entity newEntity) {
        NBTTagCompound nbttagcompound = oldEntity.func_189511_e(new NBTTagCompound());
        nbttagcompound.func_82580_o("Dimension");
        newEntity.func_70020_e(nbttagcompound);
        newEntity.field_71088_bW = oldEntity.field_71088_bW;
        newEntity.field_181016_an = oldEntity.field_181016_an;
        newEntity.field_181017_ao = oldEntity.func_181014_aG();
        newEntity.field_181018_ap = oldEntity.func_181012_aH();
    }
}

