/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.shared.lib;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.fml.common.Loader;
import quaternary.botaniatweaks.BotaniaTweaks;
import sun.reflect.Reflection;

public final class GeneratingFlowers {
    private static final Set<FlowerData> flowers = new HashSet<FlowerData>();
    private static final Map<String, FlowerData> classesToData;
    private static final Map<String, FlowerData> namesToData;
    private static final String BOTANIA_CLASS_PREFIX = "vazkii.botania.common.block.subtile.generating.SubTile";

    public static Collection<String> getAllFlowerClassesMayOrMayNotExist() {
        return classesToData.keySet();
    }

    public static Collection<FlowerData> getAllFlowerDatas() {
        return flowers;
    }

    public static FlowerData flowerDataFromName(String name) {
        return namesToData.get(name);
    }

    public static String flowerNameFromClass(String className) {
        return GeneratingFlowers.classesToData.get((Object)className).name;
    }

    public static Collection<String> getAllFlowerNames() {
        return namesToData.keySet();
    }

    public static boolean hasFlowerNamed(String name) {
        return namesToData.containsKey(name);
    }

    static {
        flowers.add(new FlowerData("botania", "arcanerose", "vazkii.botania.common.block.subtile.generating.SubTileArcaneRose", false));
        flowers.add(new FlowerData("botania", "dandelifeon", "vazkii.botania.common.block.subtile.generating.SubTileDandelifeon", false));
        flowers.add(new FlowerData("botania", "endoflame", "vazkii.botania.common.block.subtile.generating.SubTileEndoflame", false));
        flowers.add(new FlowerData("botania", "entropinnyum", "vazkii.botania.common.block.subtile.generating.SubTileEntropinnyum", false));
        flowers.add(new FlowerData("botania", "gourmaryllis", "vazkii.botania.common.block.subtile.generating.SubTileGourmaryllis", false));
        flowers.add(new FlowerData("botania", "kekimurus", "vazkii.botania.common.block.subtile.generating.SubTileKekimurus", false));
        flowers.add(new FlowerData("botania", "munchdew", "vazkii.botania.common.block.subtile.generating.SubTileMunchdew", false));
        flowers.add(new FlowerData("botania", "narslimmus", "vazkii.botania.common.block.subtile.generating.SubTileNarslimmus", false));
        flowers.add(new FlowerData("botania", "rafflowsia", "vazkii.botania.common.block.subtile.generating.SubTileRafflowsia", false));
        flowers.add(new FlowerData("botania", "shulkmenot", "vazkii.botania.common.block.subtile.generating.SubTileShulkMeNot", false));
        flowers.add(new FlowerData("botania", "spectrolus", "vazkii.botania.common.block.subtile.generating.SubTileSpectrolus", false));
        flowers.add(new FlowerData("botania", "thermalily", "vazkii.botania.common.block.subtile.generating.SubTileThermalily", false));
        flowers.add(new FlowerData("botania", "hydroangeas", "vazkii.botania.common.block.subtile.generating.SubTileHydroangeas", true));
        flowers.add(new FlowerData("floralchemy", "petropetunia", "com.minerarcana.floralchemy.block.flower.SubTilePetroPetunia", false));
        classesToData = new HashMap<String, FlowerData>();
        namesToData = new HashMap<String, FlowerData>();
        for (FlowerData data : flowers) {
            classesToData.put(data.className, data);
            namesToData.put(data.name, data);
        }
    }

    public static class PostInitHandler {
        public static void postinit() {
            for (FlowerData data : flowers) {
                if (!Loader.isModLoaded((String)data.modId)) continue;
                if (PostInitHandler.classExists(data.className)) {
                    data.markPresent();
                    continue;
                }
                BotaniaTweaks.LOG.error("Mod " + data.modId + " is loaded, but flower " + data.name + " is not present??");
                BotaniaTweaks.LOG.info("This is a bug in Botania Tweaks, not in " + data.modId + "!");
                BotaniaTweaks.LOG.info("Please report to me first so I can fix it! Thanks!");
            }
        }

        private static boolean classExists(String className) {
            try {
                return Class.forName(className) != null;
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }
    }

    public static final class FlowerData {
        public final String modId;
        public final String name;
        public final String className;
        public final boolean isPassive;
        private boolean isPresent = false;

        public FlowerData(String modId, String name, String className, boolean isPassive) {
            this.modId = modId;
            this.name = name;
            this.className = className;
            this.isPassive = isPassive;
        }

        public boolean isPresent() {
            return this.isPresent;
        }

        public void markPresent() {
            this.isPresent = true;
        }

        static {
            Reflection.registerFieldsToFilter(FlowerData.class, (String[])new String[]{"isPassive"});
        }
    }
}

