/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.shared.block;

import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import quaternary.botaniatweaks.modules.shared.tile.AbstractTileCompatCrate;
import vazkii.botania.api.lexicon.ILexiconable;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.api.wand.IWandable;

public class BlockCompatCrate
extends Block
implements IWandHUD,
IWandable,
ILexiconable {
    private final Supplier<LexiconEntry> entry;
    private final Supplier<AbstractTileCompatCrate<?>> tileFactory;

    public BlockCompatCrate(Supplier<LexiconEntry> entry, Supplier<AbstractTileCompatCrate<?>> tileFactory) {
        super(Material.field_151575_d);
        this.func_149711_c(2.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.entry = entry;
        this.tileFactory = tileFactory;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return (TileEntity)this.tileFactory.get();
    }

    public boolean onUsedByWand(EntityPlayer player, ItemStack stack, World world, BlockPos pos, EnumFacing facing) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractTileCompatCrate) {
            return ((AbstractTileCompatCrate)tile).onWanded(world, player, stack);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void renderHUD(Minecraft mc, ScaledResolution res, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof AbstractTileCompatCrate) {
            AbstractTileCompatCrate crate = (AbstractTileCompatCrate)tile;
            int STACK_SPACING = 18;
            int width = crate.getCrateWidth() * 18 - 2;
            int height = crate.getCrateHeight() * 18 - 2;
            int xc = res.func_78326_a() / 2 + 20;
            int yc = res.func_78328_b() / 2 - height / 2;
            Gui.func_73734_a((int)(xc - 6), (int)(yc - 6), (int)(xc + width + 6), (int)(yc + height + 6), (int)0x22000000);
            Gui.func_73734_a((int)(xc - 4), (int)(yc - 4), (int)(xc + width + 4), (int)(yc + height + 4), (int)0x22000000);
            for (int i = 0; i < crate.getCrateWidth(); ++i) {
                for (int j = 0; j < crate.getCrateHeight(); ++j) {
                    int index = i * crate.getCrateWidth() + j;
                    int xp = xc + j * 18;
                    int yp = yc + i * 18;
                    Gui.func_73734_a((int)xp, (int)yp, (int)(xp + 16), (int)(yp + 16), (int)0x22FFFFFF);
                    ItemStack item = crate.getItemHandler().getStackInSlot(index);
                    RenderHelper.func_74520_c();
                    GlStateManager.func_179091_B();
                    mc.func_175599_af().func_180450_b(item, xp, yp);
                    RenderHelper.func_74518_a();
                }
            }
        }
    }

    public LexiconEntry getEntry(World world, BlockPos pos, EntityPlayer player, ItemStack stack) {
        return this.entry.get();
    }
}

