/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.extendedcrafting;

import com.blakebr0.extendedcrafting.block.ModBlocks;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import quaternary.botaniatweaks.BotaniaTweaks;
import quaternary.botaniatweaks.modules.IModule;
import quaternary.botaniatweaks.modules.extendedcrafting.tile.AbstractTileExtCraftCrate;
import quaternary.botaniatweaks.modules.shared.block.BlockCompatCrate;
import quaternary.botaniatweaks.modules.shared.helper.ClientHelpers;
import quaternary.botaniatweaks.modules.shared.helper.ModCompatUtil;
import quaternary.botaniatweaks.modules.shared.helper.RegHelpers;
import quaternary.botaniatweaks.modules.shared.lexi.DoubleCompatLexiconEntry;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.lexicon.LexiconEntry;
import vazkii.botania.api.lexicon.LexiconPage;
import vazkii.botania.api.lexicon.LexiconRecipeMappings;
import vazkii.botania.api.recipe.RecipeElvenTrade;
import vazkii.botania.common.lexicon.page.PageElvenRecipe;
import vazkii.botania.common.lexicon.page.PageText;

public class ModuleExtendedCrafting
implements IModule {
    public static LexiconEntry extCrateEntry;
    public static Block basicExtCrate;
    public static Block advExtCrate;
    public static Block eliteExtCrate;
    public static Block ultExtCrate;

    public static boolean areCraftersEnabled() {
        return ModBlocks.blockBasicTable.isEnabled();
    }

    @Override
    public void preinit() {
        BotaniaTweaks.PROXY.registerSidedEventClasses(() -> CommonEvents.class, () -> ClientEvents.class);
    }

    @Override
    public void postinit() {
        if (!ModuleExtendedCrafting.areCraftersEnabled()) {
            return;
        }
        ArrayList elvenRecipes = new ArrayList();
        extCrateEntry = new DoubleCompatLexiconEntry("botania_tweaks.lexicon.category.extCrates", BotaniaAPI.categoryDevices, "Botania Tweaks", "Extended Crafting");
        BiConsumer<Block, Block> elvenRecipeFunc = (extCrate, extTable) -> {
            ItemStack extCrateStack = new ItemStack(Item.func_150898_a((Block)extCrate));
            ItemStack extTableStack = new ItemStack(Item.func_150898_a((Block)extTable));
            ItemStack crateStack = ModCompatUtil.getStackFor(new ResourceLocation("botania", "opencrate"), 1);
            elvenRecipes.add(BotaniaAPI.registerElvenTradeRecipe((ItemStack)extCrateStack, (Object[])new Object[]{extTableStack, crateStack}));
            LexiconRecipeMappings.map((ItemStack)extCrateStack, (LexiconEntry)extCrateEntry, (int)0);
        };
        elvenRecipeFunc.accept(basicExtCrate, (Block)ModBlocks.blockBasicTable);
        elvenRecipeFunc.accept(advExtCrate, (Block)ModBlocks.blockAdvancedTable);
        elvenRecipeFunc.accept(eliteExtCrate, (Block)ModBlocks.blockEliteTable);
        elvenRecipeFunc.accept(ultExtCrate, (Block)ModBlocks.blockUltimateTable);
        extCrateEntry.setKnowledgeType(BotaniaAPI.elvenKnowledge);
        extCrateEntry.setIcon(new ItemStack(Item.func_150898_a((Block)ultExtCrate)));
        extCrateEntry.addPage((LexiconPage)new PageText("botania_tweaks.lexicon.extCrates.0"));
        for (int i = 0; i < elvenRecipes.size(); ++i) {
            extCrateEntry.addPage((LexiconPage)new PageElvenRecipe("botania_tweaks.lexicon.extCrates.subtitle." + i, (RecipeElvenTrade)elvenRecipes.get(i)));
        }
    }

    public static class ClientEvents {
        @SubscribeEvent
        public static void models(ModelRegistryEvent e) {
            ClientHelpers.setModel(basicExtCrate.getRegistryName().func_110623_a());
            ClientHelpers.setModel(advExtCrate.getRegistryName().func_110623_a());
            ClientHelpers.setModel(eliteExtCrate.getRegistryName().func_110623_a());
            ClientHelpers.setModel(ultExtCrate.getRegistryName().func_110623_a());
        }
    }

    public static class CommonEvents {
        @SubscribeEvent
        public static void blocks(RegistryEvent.Register<Block> e) {
            IForgeRegistry reg = e.getRegistry();
            Supplier<LexiconEntry> entry = () -> extCrateEntry;
            basicExtCrate = new BlockCompatCrate(entry, AbstractTileExtCraftCrate.Basic::new);
            advExtCrate = new BlockCompatCrate(entry, AbstractTileExtCraftCrate.Advanced::new);
            eliteExtCrate = new BlockCompatCrate(entry, AbstractTileExtCraftCrate.Elite::new);
            ultExtCrate = new BlockCompatCrate(entry, AbstractTileExtCraftCrate.Ultimate::new);
            reg.register((IForgeRegistryEntry)RegHelpers.createBlock(basicExtCrate, "basic_extended_crafty_crate"));
            reg.register((IForgeRegistryEntry)RegHelpers.createBlock(advExtCrate, "advanced_extended_crafty_crate"));
            reg.register((IForgeRegistryEntry)RegHelpers.createBlock(eliteExtCrate, "elite_extended_crafty_crate"));
            reg.register((IForgeRegistryEntry)RegHelpers.createBlock(ultExtCrate, "ultimate_extended_crafty_crate"));
            GameRegistry.registerTileEntity(AbstractTileExtCraftCrate.Basic.class, (ResourceLocation)new ResourceLocation("botania_tweaks", "basic_ext_crafty_crate"));
            GameRegistry.registerTileEntity(AbstractTileExtCraftCrate.Advanced.class, (ResourceLocation)new ResourceLocation("botania_tweaks", "adv_ext_crafty_crate"));
            GameRegistry.registerTileEntity(AbstractTileExtCraftCrate.Elite.class, (ResourceLocation)new ResourceLocation("botania_tweaks", "elite_ext_crafty_crate"));
            GameRegistry.registerTileEntity(AbstractTileExtCraftCrate.Ultimate.class, (ResourceLocation)new ResourceLocation("botania_tweaks", "ult_ext_crafty_crate"));
        }

        @SubscribeEvent
        public static void items(RegistryEvent.Register<Item> e) {
            IForgeRegistry reg = e.getRegistry();
            reg.register((IForgeRegistryEntry)RegHelpers.createItemBlock(new ItemBlock(basicExtCrate)));
            reg.register((IForgeRegistryEntry)RegHelpers.createItemBlock(new ItemBlock(advExtCrate)));
            reg.register((IForgeRegistryEntry)RegHelpers.createItemBlock(new ItemBlock(eliteExtCrate)));
            reg.register((IForgeRegistryEntry)RegHelpers.createItemBlock(new ItemBlock(ultExtCrate)));
        }
    }
}

