/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.wsd;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraft.world.storage.MapStorage;
import net.minecraft.world.storage.WorldSavedData;

public class ManaStatisticsWsd
extends WorldSavedData {
    public static final String STAT_NAME = "botaniatweaks_mana_gen_stats";
    private Map<String, Long> totalFlowerManaMap = new HashMap<String, Long>();
    private long totalManaEver = 0L;

    public ManaStatisticsWsd() {
        this(STAT_NAME);
    }

    public ManaStatisticsWsd(String name) {
        super(name);
    }

    public static ManaStatisticsWsd get(World world) {
        MapStorage mapStorage = world.func_175693_T();
        ManaStatisticsWsd inst = (ManaStatisticsWsd)mapStorage.func_75742_a(ManaStatisticsWsd.class, STAT_NAME);
        if (inst == null) {
            inst = new ManaStatisticsWsd();
            mapStorage.func_75745_a(STAT_NAME, (WorldSavedData)inst);
        }
        return inst;
    }

    public void trackMana(String flowerName, int newMana) {
        this.totalManaEver += (long)newMana;
        long perFlowerMana = this.totalFlowerManaMap.getOrDefault(flowerName, 0L);
        this.totalFlowerManaMap.put(flowerName, perFlowerMana += (long)newMana);
        this.func_76185_a();
    }

    public long getTotalFlowerMana(String flowerName) {
        return this.totalFlowerManaMap.getOrDefault(flowerName, 0L);
    }

    public long getTotalMana() {
        return this.totalManaEver;
    }

    public void resetAllMana() {
        this.totalManaEver = 0L;
        this.totalFlowerManaMap.clear();
        this.func_76185_a();
    }

    public void resetManaFor(String flowerName) {
        if (!this.totalFlowerManaMap.containsKey(flowerName)) {
            return;
        }
        long manaToRemove = this.totalFlowerManaMap.get(flowerName);
        this.totalManaEver -= manaToRemove;
        this.totalFlowerManaMap.put(flowerName, 0L);
        this.func_76185_a();
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbt) {
        nbt.func_74772_a("TotalManaEver", this.totalManaEver);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<String, Long> entry : this.totalFlowerManaMap.entrySet()) {
            NBTTagCompound cmp = new NBTTagCompound();
            cmp.func_74778_a("Flower", entry.getKey());
            cmp.func_74772_a("Mana", entry.getValue().longValue());
            list.func_74742_a((NBTBase)cmp);
        }
        nbt.func_74782_a("PerFlowerManaEver", (NBTBase)list);
        return nbt;
    }

    public void func_76184_a(NBTTagCompound nbt) {
        this.totalManaEver = nbt.func_74763_f("TotalManaEver");
        NBTTagList list = nbt.func_150295_c("PerFlowerManaEver", 10);
        this.totalFlowerManaMap.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound cmp = list.func_150305_b(i);
            this.totalFlowerManaMap.put(cmp.func_74779_i("Flower"), cmp.func_74763_f("Mana"));
        }
    }
}

