/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.tile;

import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;
import quaternary.botaniatweaks.modules.botania.net.PacketAdvancedCrateFX;
import quaternary.botaniatweaks.modules.shared.net.BotaniaTweaksPacketHandler;
import vazkii.botania.api.mana.IManaReceiver;
import vazkii.botania.common.block.tile.TileCraftCrate;
import vazkii.botania.common.item.ModItems;

public class TileCustomCraftyCrate
extends TileCraftCrate
implements IManaReceiver {
    int mana = 0;
    int mySignal = 0;

    public boolean isFull() {
        return this.mana >= this.getMaxMana();
    }

    public void recieveMana(int m) {
        this.mana += m;
    }

    public boolean canRecieveManaFromBursts() {
        return !this.isFull() && BotaniaConfig.ADVANCED_CRAFTY_CRATE;
    }

    public int getCurrentMana() {
        return this.mana;
    }

    public int getMaxMana() {
        return this.getManaPerItem() * 20;
    }

    public int getManaPerItem() {
        return BotaniaConfig.ADVANCED_CRATE_MANA_PER_ITEM;
    }

    public int getItemCount() {
        int items = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || this.isLocked(i) || stack.func_77973_b() == ModItems.manaResource && stack.func_77952_i() == 11) continue;
            ++items;
        }
        return items;
    }

    public void func_73660_a() {
        int newSignal;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.canEject() && this.isCrateFull() && this.doCraft(true)) {
            this.doEjectAll();
        }
        for (newSignal = 0; newSignal < 9 && (this.isLocked(newSignal) || !this.itemHandler.getStackInSlot(newSignal).func_190926_b()); ++newSignal) {
        }
        if (newSignal != this.mySignal) {
            this.mySignal = newSignal;
            this.field_145850_b.func_175666_e(this.field_174879_c, this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c());
        }
    }

    protected boolean doCraft(boolean fullCheck) {
        if (fullCheck && !this.isCrateFull()) {
            return false;
        }
        InventoryCrafting craft = new InventoryCrafting(new Container(){

            public boolean func_75145_c(@Nonnull EntityPlayer player) {
                return false;
            }
        }, 3, 3);
        int recipeItems = 0;
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (stack.func_190926_b() || this.isLocked(i) || stack.func_77973_b() == ModItems.manaResource && stack.func_77952_i() == 11) continue;
            ++recipeItems;
            craft.func_70299_a(i, stack.func_77946_l());
        }
        if (BotaniaConfig.ADVANCED_CRAFTY_CRATE && !BotaniaConfig.ADVANCED_CRAFTY_CRATE_HARDMODE && recipeItems * this.getManaPerItem() > this.mana) {
            return false;
        }
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!recipe.func_77569_a(craft, this.field_145850_b)) continue;
            if (BotaniaConfig.ADVANCED_CRAFTY_CRATE && BotaniaConfig.ADVANCED_CRAFTY_CRATE_HARDMODE && recipeItems * this.getManaPerItem() > this.mana) {
                this.doEjectAll();
                return false;
            }
            this.itemHandler.setStackInSlot(9, recipe.func_77572_b(craft));
            for (int i = 0; i < 9; ++i) {
                ItemStack stack = this.itemHandler.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                ItemStack container = stack.func_77973_b().getContainerItem(stack);
                this.itemHandler.setStackInSlot(i, container);
            }
            return true;
        }
        return false;
    }

    protected void doEjectAll() {
        if (BotaniaConfig.ADVANCED_CRAFTY_CRATE) {
            if (this.field_145850_b instanceof WorldServer) {
                BotaniaTweaksPacketHandler.sendToAllAround(new PacketAdvancedCrateFX(this.field_174879_c), this.field_145850_b, this.field_174879_c);
            }
            this.mana = 0;
        }
        for (int i = 0; i < this.getSizeInventory(); ++i) {
            ItemStack stack = this.itemHandler.getStackInSlot(i);
            if (!stack.func_190926_b()) {
                this.eject(stack, false);
            }
            this.itemHandler.setStackInSlot(i, ItemStack.field_190927_a);
        }
        this.func_70296_d();
    }

    boolean isCrateFull() {
        for (int i = 0; i < 9; ++i) {
            if (this.isLocked(i) || !this.itemHandler.getStackInSlot(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public int getSignal() {
        return this.mySignal;
    }

    public boolean onWanded(World world, EntityPlayer player, ItemStack stack) {
        if (!world.field_72995_K && this.canEject()) {
            this.doCraft(false);
            this.doEjectAll();
        }
        return true;
    }

    public void writePacketNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("Mana", this.mana);
        super.writePacketNBT(nbt);
    }

    public void readPacketNBT(NBTTagCompound nbt) {
        super.readPacketNBT(nbt);
        this.mana = nbt.func_74762_e("Mana");
    }
}

