/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.recipe;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockDirectional;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import vazkii.botania.api.state.BotaniaStateProps;

public class AgglomerationRecipe {
    public final ImmutableList<ItemStack> recipeStacks;
    public final ImmutableList<String> recipeOreKeys;
    public final ItemStack recipeOutput;
    public final int manaCost;
    public final int color1;
    public final int color2;
    public final IBlockState multiblockCenter;
    public final IBlockState multiblockEdge;
    public final IBlockState multiblockCorner;
    @Nullable
    public final IBlockState multiblockCenterReplace;
    @Nullable
    public final IBlockState multiblockEdgeReplace;
    @Nullable
    public final IBlockState multiblockCornerReplace;
    final int totalInputs;
    private EnumFacing[] EAST_SOUTH_WEST = new EnumFacing[]{EnumFacing.EAST, EnumFacing.SOUTH, EnumFacing.WEST};

    private void verifyInputs(ImmutableList<Object> inputs) {
        if (inputs.isEmpty()) {
            throw new IllegalArgumentException("Can't make empty agglomeration recipe");
        }
        for (Object o : inputs) {
            if (o instanceof ItemStack || o instanceof String) continue;
            throw new IllegalArgumentException("illegal recipe input " + o);
        }
    }

    public AgglomerationRecipe(ImmutableList<Object> recipeInputs, ItemStack recipeOutput, int manaCost, int color1, int color2, IBlockState multiblockCenter, IBlockState multiblockEdge, IBlockState multiblockCorner, @Nullable IBlockState multiblockCenterReplace, @Nullable IBlockState multiblockEdgeReplace, @Nullable IBlockState multiblockCornerReplace) {
        this.verifyInputs(recipeInputs);
        ImmutableList.Builder stackInputBuilder = new ImmutableList.Builder();
        ImmutableList.Builder keyInputBuilder = new ImmutableList.Builder();
        for (Object o : recipeInputs) {
            if (o instanceof ItemStack) {
                stackInputBuilder.add((Object)((ItemStack)o));
                continue;
            }
            keyInputBuilder.add((Object)((String)o));
        }
        this.recipeStacks = stackInputBuilder.build();
        this.recipeOreKeys = keyInputBuilder.build();
        this.totalInputs = this.recipeStacks.size() + this.recipeOreKeys.size();
        this.recipeOutput = recipeOutput;
        this.manaCost = manaCost;
        this.color1 = color1;
        this.color2 = color2;
        this.multiblockCenter = multiblockCenter;
        this.multiblockEdge = multiblockEdge;
        this.multiblockCorner = multiblockCorner;
        this.multiblockCenterReplace = multiblockCenterReplace;
        this.multiblockEdgeReplace = multiblockEdgeReplace;
        this.multiblockCornerReplace = multiblockCornerReplace;
    }

    public boolean matches(World w, BlockPos platePos, List<ItemStack> inputs, IBlockState belowEarly, IBlockState edgeEarly, IBlockState cornerEarly) {
        return this.multiblockMatches(w, platePos, belowEarly, edgeEarly, cornerEarly) && this.itemsMatch(inputs);
    }

    public boolean itemsMatch(List<ItemStack> userInputs) {
        if (userInputs.size() == 0 || userInputs.size() != this.totalInputs) {
            return false;
        }
        int usedRecipeStackCount = 0;
        int usedOreKeyCount = 0;
        boolean[] usedUserInputs = new boolean[userInputs.size()];
        for (ItemStack recipeStack : this.recipeStacks) {
            for (int i = 0; i < userInputs.size(); ++i) {
                ItemStack userInputStack;
                if (usedUserInputs[i] || !AgglomerationRecipe.compareStacks(recipeStack, userInputStack = userInputs.get(i)) || recipeStack.func_190916_E() != userInputStack.func_190916_E()) continue;
                ++usedRecipeStackCount;
                usedUserInputs[i] = true;
            }
        }
        if (usedRecipeStackCount != this.recipeStacks.size()) {
            return false;
        }
        for (String key : this.recipeOreKeys) {
            NonNullList matchingOres = OreDictionary.getOres((String)key);
            for (ItemStack oreStack : matchingOres) {
                for (int i = 0; i < userInputs.size(); ++i) {
                    ItemStack userInputStack;
                    if (usedUserInputs[i] || !AgglomerationRecipe.compareStacks(oreStack, userInputStack = userInputs.get(i)) || userInputStack.func_190916_E() != 1) continue;
                    ++usedOreKeyCount;
                    usedUserInputs[i] = true;
                }
            }
        }
        return usedOreKeyCount == this.recipeOreKeys.size();
    }

    public boolean multiblockMatches(World w, BlockPos platePos, IBlockState belowEarly, IBlockState edgeEarly, IBlockState cornerEarly) {
        if (!this.areStatesSimilar(belowEarly, this.multiblockCenter)) {
            return false;
        }
        if (!this.areStatesSimilar(edgeEarly, this.multiblockEdge)) {
            return false;
        }
        if (!this.areStatesSimilar(cornerEarly, this.multiblockCorner)) {
            return false;
        }
        BlockPos multiblockPos = platePos.func_177977_b();
        for (EnumFacing esw : this.EAST_SOUTH_WEST) {
            BlockPos horizOffset = multiblockPos.func_177972_a(esw);
            if (!this.areStatesSimilar(w.func_180495_p(horizOffset), this.multiblockEdge)) {
                return false;
            }
            BlockPos cornerOffset = horizOffset.func_177972_a(esw.func_176746_e());
            if (this.areStatesSimilar(w.func_180495_p(cornerOffset), this.multiblockCorner)) continue;
            return false;
        }
        return true;
    }

    private boolean areStatesSimilar(IBlockState a, IBlockState b) {
        if (a.func_177230_c() != b.func_177230_c()) {
            return false;
        }
        return this.equalizeDirectionProperties(a).equals(this.equalizeDirectionProperties(b));
    }

    private IBlockState equalizeDirectionProperties(IBlockState state) {
        Collection props = state.func_177227_a();
        if (props.contains(BlockDirectional.field_176387_N)) {
            return state.func_177226_a((IProperty)BlockDirectional.field_176387_N, (Comparable)EnumFacing.NORTH);
        }
        if (props.contains(BotaniaStateProps.FACING)) {
            return state.func_177226_a((IProperty)BotaniaStateProps.FACING, (Comparable)EnumFacing.NORTH);
        }
        for (IProperty prop : props) {
            if (prop.func_177699_b() != EnumFacing.class || !prop.func_177700_c().contains(EnumFacing.NORTH)) continue;
            state = state.func_177226_a(prop, (Comparable)EnumFacing.NORTH);
        }
        return state;
    }

    public ImmutableList<ItemStack> getRecipeStacks() {
        return this.recipeStacks;
    }

    public ImmutableList<String> getRecipeOreKeys() {
        return this.recipeOreKeys;
    }

    public int getManaCost() {
        return this.manaCost;
    }

    public ItemStack getRecipeOutputCopy() {
        return this.recipeOutput.func_77946_l();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AgglomerationRecipe)) {
            return false;
        }
        AgglomerationRecipe other = (AgglomerationRecipe)obj;
        if (other.manaCost != this.manaCost) {
            return false;
        }
        if (other.multiblockCenter != this.multiblockCenter) {
            return false;
        }
        if (other.multiblockEdge != this.multiblockEdge) {
            return false;
        }
        if (other.multiblockCorner != this.multiblockCorner) {
            return false;
        }
        if (other.multiblockCenterReplace != this.multiblockCenterReplace) {
            return false;
        }
        if (other.multiblockEdgeReplace != this.multiblockEdgeReplace) {
            return false;
        }
        if (other.multiblockCornerReplace != this.multiblockCornerReplace) {
            return false;
        }
        if (!ItemStack.func_77989_b((ItemStack)other.recipeOutput, (ItemStack)this.recipeOutput)) {
            return false;
        }
        if (!new HashSet<String>((Collection<String>)other.recipeOreKeys).equals(new HashSet<String>((Collection<String>)this.recipeOreKeys))) {
            return false;
        }
        ArrayList<ItemStack> myStackCopy = new ArrayList<ItemStack>((Collection<ItemStack>)this.recipeStacks);
        for (ItemStack otherStack : other.recipeStacks) {
            myStackCopy.removeIf(stack -> ItemStack.func_77989_b((ItemStack)stack, (ItemStack)otherStack));
        }
        return myStackCopy.size() == 0;
    }

    public String toString() {
        return "AgglomerationRecipe{recipeStacks=" + this.recipeStacks + ", recipeOreKeys=" + this.recipeOreKeys + ", recipeOutput=" + this.recipeOutput + ", manaCost=" + this.manaCost + ", color1=" + this.color1 + ", color2=" + this.color2 + ", multiblockCenter=" + this.multiblockCenter + ", multiblockEdge=" + this.multiblockEdge + ", multiblockCorner=" + this.multiblockCorner + ", multiblockCenterReplace=" + this.multiblockCenterReplace + ", multiblockEdgeReplace=" + this.multiblockEdgeReplace + ", multiblockCornerReplace=" + this.multiblockCornerReplace + ", totalInputs=" + this.totalInputs + '}';
    }

    private static boolean compareStacks(ItemStack recipe, ItemStack supplied) {
        if (recipe.func_190926_b() || supplied.func_190926_b()) {
            return false;
        }
        if (recipe.func_77973_b() != supplied.func_77973_b()) {
            return false;
        }
        if (recipe.func_77952_i() != supplied.func_77952_i()) {
            return false;
        }
        return AgglomerationRecipe.isTagSubset(recipe.func_77978_p(), supplied.func_77978_p());
    }

    private static boolean isTagSubset(@Nullable NBTTagCompound recipeTag, @Nullable NBTTagCompound suppliedTag) {
        if (recipeTag == null || recipeTag.func_82582_d()) {
            return true;
        }
        if (suppliedTag == null || suppliedTag.func_82582_d()) {
            return false;
        }
        if (recipeTag.func_150296_c().size() > suppliedTag.func_150296_c().size()) {
            return false;
        }
        for (String key : suppliedTag.func_150296_c()) {
            if (!recipeTag.func_74764_b(key)) continue;
            NBTBase suppliedEntry = suppliedTag.func_74781_a(key);
            NBTBase recipeEntry = recipeTag.func_74781_a(key);
            if (!(suppliedEntry instanceof NBTTagCompound && recipeEntry instanceof NBTTagCompound ? !AgglomerationRecipe.isTagSubset((NBTTagCompound)recipeEntry, (NBTTagCompound)suppliedEntry) : !suppliedEntry.equals((Object)recipeEntry))) continue;
            return false;
        }
        return true;
    }
}

