/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.modules.botania.command;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;
import quaternary.botaniatweaks.modules.botania.wsd.ManaStatisticsWsd;
import quaternary.botaniatweaks.modules.shared.lib.GeneratingFlowers;

public class CommandDebugManaGenerationStats
extends CommandBase {
    public String func_71517_b() {
        return "botaniatweaks-debug-stats";
    }

    public String func_71518_a(ICommandSender sender) {
        return "botania_tweaks.commands.debug_stats.usage";
    }

    public int func_82362_a() {
        return 2;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        String flowerName;
        if (!BotaniaConfig.MANA_GENERATION_STATISTICS) {
            throw new CommandException("botania_tweaks.commands.shared.stats_disabled", new Object[0]);
        }
        if (args.length == 0) {
            flowerName = "all";
        } else if (args.length == 1) {
            flowerName = args[0].toLowerCase(Locale.ROOT);
        } else {
            throw new CommandException("botania_tweaks.commands.debug_stats.usage", new Object[0]);
        }
        ManaStatisticsWsd wsd = ManaStatisticsWsd.get(server.func_130014_f_());
        if (flowerName.equals("all")) {
            for (GeneratingFlowers.FlowerData data : GeneratingFlowers.getAllFlowerDatas()) {
                CommandDebugManaGenerationStats.sendPrefixed(sender, "flower", data.name, data.modId, wsd.getTotalFlowerMana(data.name));
                if (data.isPresent()) continue;
                CommandDebugManaGenerationStats.send(sender, TextFormatting.BLUE + "botania_tweaks.commands.shared.flower_not_present", data.name, data.modId);
            }
            CommandDebugManaGenerationStats.sendPrefixed(sender, "total", wsd.getTotalMana());
        } else if (flowerName.equals("total")) {
            CommandDebugManaGenerationStats.sendPrefixed(sender, "total", wsd.getTotalMana());
        } else if (GeneratingFlowers.hasFlowerNamed(flowerName)) {
            GeneratingFlowers.FlowerData data = GeneratingFlowers.flowerDataFromName(flowerName);
            CommandDebugManaGenerationStats.sendPrefixed(sender, "flower", data.name, data.modId, wsd.getTotalFlowerMana(data.name));
            if (!data.isPresent()) {
                throw new CommandException("botania_tweaks.commands.shared.disabled_flower", new Object[]{flowerName, data.modId});
            }
        } else {
            throw new CommandException("botania_tweaks.commands.shared.unknown_generating_flower", new Object[]{flowerName});
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            ArrayList<String> list = new ArrayList<String>(GeneratingFlowers.getAllFlowerNames());
            list.add("all");
            list.add("total");
            return CommandDebugManaGenerationStats.func_175762_a((String[])args, list);
        }
        return Collections.emptyList();
    }

    private static void send(ICommandSender sender, String component, Object ... args) {
        sender.func_145747_a((ITextComponent)new TextComponentTranslation(component, args));
    }

    private static void sendPrefixed(ICommandSender sender, String component, Object ... args) {
        CommandDebugManaGenerationStats.send(sender, "botania_tweaks.commands.debug_stats." + component, args);
    }
}

