/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class KeyDamageTweak
extends Tweak {
    @Override
    protected Collection<String> computeAffectedClasses() {
        return ImmutableList.of((Object)"vazkii.botania.common.entity.EntityBabylonWeapon");
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Patching Key of the King's Law damage output...";
    }

    @Override
    void doPatch(String transformedName, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("func_70071_h_") && !method.name.equals("onUpdate")) continue;
            InsnList insns = method.instructions;
            for (int i = 0; i < insns.size(); ++i) {
                AbstractInsnNode insn = insns.get(i);
                if (insn.getOpcode() != 18 || !((LdcInsnNode)insn).cst.equals(Float.valueOf(20.0f))) continue;
                insns.insertBefore(insn, (AbstractInsnNode)new MethodInsnNode(184, KeyDamageTweak.getHooksClass(), "getKeyDamage", "()F", false));
                insns.remove(insn);
            }
        }
    }
}

