/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class JeiPluginTweak
extends Tweak {
    @Override
    protected Collection<String> computeAffectedClasses() {
        return ImmutableList.of((Object)"vazkii.botania.client.integration.jei.JEIBotaniaPlugin");
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Patching Botania's corporea request keybind...";
    }

    @Override
    void doPatch(String transformedName, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("onRuntimeAvailable")) continue;
            AbstractInsnNode ret = method.instructions.getLast();
            while (ret.getOpcode() != 177) {
                ret = ret.getPrevious();
            }
            InsnList patch = new InsnList();
            patch.add((AbstractInsnNode)new VarInsnNode(25, 1));
            patch.add((AbstractInsnNode)new MethodInsnNode(184, JeiPluginTweak.getHooksClass("Jei"), "patchCorporeaKeybind", "(Lmezz/jei/api/IJeiRuntime;)V", false));
            method.instructions.insertBefore(ret, patch);
            return;
        }
    }
}

