/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LdcInsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class CreativeManaPoolSizeTweak
extends Tweak {
    @Override
    protected Collection<String> computeAffectedClasses() {
        return ImmutableList.of((Object)"vazkii.botania.common.block.tile.mana.TilePool");
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Bumping the size of the creative mana pool...";
    }

    @Override
    void doPatch(String transformedName, ClassNode node) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals("getCurrentMana")) continue;
            for (int insIndex = 0; insIndex < method.instructions.size(); ++insIndex) {
                AbstractInsnNode instruction = method.instructions.get(insIndex);
                if (!(instruction instanceof LdcInsnNode)) continue;
                LdcInsnNode ldc = (LdcInsnNode)instruction;
                if (!ldc.cst.equals(1000000)) continue;
                MethodInsnNode hook = new MethodInsnNode(184, CreativeManaPoolSizeTweak.getHooksClass(), "getCreativePoolSize", "()I", false);
                method.instructions.insert(instruction, (AbstractInsnNode)hook);
                method.instructions.remove(instruction);
                return;
            }
        }
    }
}

