/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm.tweaks;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Objects;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class AnnoyingSpectrolusTweak
extends Tweak {
    @Override
    protected Collection<String> computeAffectedClasses() {
        return ImmutableList.of((Object)"vazkii.botania.common.block.subtile.generating.SubTileSpectrolus");
    }

    @Override
    String getLogMessage(String transformedName) {
        return "Patching the Spectrolus to add advanced mode...";
    }

    @Override
    void doPatch(String transformedName, ClassNode node) {
        node.fields.add(new FieldNode(4097, "btweaks$wool_indices", "[I", null, null));
        InsnList insns = Objects.requireNonNull(AnnoyingSpectrolusTweak.getMethod((ClassNode)node, (String)"<init>")).instructions;
        AbstractInsnNode ret = insns.getLast();
        while (ret.getOpcode() != 177) {
            ret = ret.getPrevious();
        }
        InsnList hook = new InsnList();
        hook.add((AbstractInsnNode)new VarInsnNode(25, 0));
        hook.add((AbstractInsnNode)new MethodInsnNode(184, AnnoyingSpectrolusTweak.getHooksClass(), "hardSpectrolusInitialize", "(Lvazkii/botania/common/block/subtile/generating/SubTileSpectrolus;)V", false));
        insns.insertBefore(ret, hook);
        node.interfaces.add("quaternary/botaniatweaks/asm/monkeypatch/IHardSpectrolus");
        MethodNode getter = new MethodNode(327680, 4097, "btweaks$getWoolOrder", "()[I", null, null);
        getter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        getter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "vazkii/botania/common/block/subtile/generating/SubTileSpectrolus", "btweaks$wool_indices", "[I"));
        getter.instructions.add((AbstractInsnNode)new InsnNode(176));
        node.methods.add(getter);
        MethodNode setter = new MethodNode(327680, 4097, "btweaks$setWoolOrder", "([I)V", null, null);
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "vazkii/botania/common/block/subtile/generating/SubTileSpectrolus", "btweaks$wool_indices", "[I"));
        setter.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(setter);
        getter = new MethodNode(327680, 4097, "btweaks$getNextColor", "()I", null, null);
        getter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        getter.instructions.add((AbstractInsnNode)new FieldInsnNode(180, "vazkii/botania/common/block/subtile/generating/SubTileSpectrolus", "nextColor", "I"));
        getter.instructions.add((AbstractInsnNode)new InsnNode(172));
        node.methods.add(getter);
        setter = new MethodNode(327680, 4097, "btweaks$setNextColor", "(I)V", null, null);
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        setter.instructions.add((AbstractInsnNode)new VarInsnNode(21, 1));
        setter.instructions.add((AbstractInsnNode)new FieldInsnNode(181, "vazkii/botania/common/block/subtile/generating/SubTileSpectrolus", "nextColor", "I"));
        setter.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(setter);
        insns = Objects.requireNonNull(AnnoyingSpectrolusTweak.getMethod((ClassNode)node, (String)"writeToPacketNBT")).instructions;
        ret = insns.getLast();
        while (ret.getOpcode() != 177) {
            ret = ret.getPrevious();
        }
        hook = new InsnList();
        hook.add((AbstractInsnNode)new VarInsnNode(25, 0));
        hook.add((AbstractInsnNode)new VarInsnNode(25, 1));
        hook.add((AbstractInsnNode)new MethodInsnNode(184, AnnoyingSpectrolusTweak.getHooksClass(), "hardSpectrolusWriteToPacketNBT", "(Lvazkii/botania/common/block/subtile/generating/SubTileSpectrolus;Lnet/minecraft/nbt/NBTTagCompound;)V", false));
        insns.insertBefore(ret, hook);
        insns = Objects.requireNonNull(AnnoyingSpectrolusTweak.getMethod((ClassNode)node, (String)"readFromPacketNBT")).instructions;
        ret = insns.getLast();
        while (ret.getOpcode() != 177) {
            ret = ret.getPrevious();
        }
        hook = new InsnList();
        hook.add((AbstractInsnNode)new VarInsnNode(25, 0));
        hook.add((AbstractInsnNode)new VarInsnNode(25, 1));
        hook.add((AbstractInsnNode)new MethodInsnNode(184, AnnoyingSpectrolusTweak.getHooksClass(), "hardSpectrolusReadFromPacketNBT", "(Lvazkii/botania/common/block/subtile/generating/SubTileSpectrolus;Lnet/minecraft/nbt/NBTTagCompound;)V", false));
        insns.insertBefore(ret, hook);
        MethodNode placedBy = new MethodNode(327680, 4097, "populateDropStackNBTs", "(Ljava/util/List;)V", null, null);
        placedBy.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        placedBy.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        placedBy.instructions.add((AbstractInsnNode)new InsnNode(92));
        placedBy.instructions.add((AbstractInsnNode)new MethodInsnNode(183, "vazkii/botania/api/subtile/SubTileGenerating", "populateDropStackNBTs", "(Ljava/util/List;)V", false));
        placedBy.instructions.add((AbstractInsnNode)new MethodInsnNode(184, AnnoyingSpectrolusTweak.getHooksClass(), "hardSpectrolusPopulateDropStackNBTs", "(Lvazkii/botania/common/block/subtile/generating/SubTileSpectrolus;Ljava/util/List;)V", false));
        placedBy.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(placedBy);
        placedBy = new MethodNode(327680, 4097, "onBlockPlacedBy", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/entity/EntityLivingBase;Lnet/minecraft/item/ItemStack;)V", null, null);
        placedBy.instructions.add((AbstractInsnNode)new VarInsnNode(25, 0));
        placedBy.instructions.add((AbstractInsnNode)new VarInsnNode(25, 1));
        placedBy.instructions.add((AbstractInsnNode)new VarInsnNode(25, 5));
        placedBy.instructions.add((AbstractInsnNode)new MethodInsnNode(184, AnnoyingSpectrolusTweak.getHooksClass(), "hardSpectrolusOnBlockPlacedBy", "(Lvazkii/botania/common/block/subtile/generating/SubTileSpectrolus;Lnet/minecraft/world/World;Lnet/minecraft/item/ItemStack;)V", false));
        placedBy.instructions.add((AbstractInsnNode)new InsnNode(177));
        node.methods.add(placedBy);
        insns = Objects.requireNonNull(AnnoyingSpectrolusTweak.getMethod((ClassNode)node, (String)"onUpdate")).instructions;
        AbstractInsnNode point = insns.getFirst();
        while (point.getOpcode() != 160) {
            point = point.getNext();
        }
        hook = new InsnList();
        hook.add((AbstractInsnNode)new VarInsnNode(25, 0));
        hook.add((AbstractInsnNode)new FieldInsnNode(180, "vazkii/botania/common/block/subtile/generating/SubTileSpectrolus", "btweaks$wool_indices", "[I"));
        hook.add((AbstractInsnNode)new InsnNode(95));
        hook.add((AbstractInsnNode)new InsnNode(46));
        insns.insertBefore(point, hook);
        MethodNode renderHud = AnnoyingSpectrolusTweak.getMethod(node, "renderHUD");
        if (renderHud != null) {
            point = renderHud.instructions.getFirst();
            while (point.getOpcode() != 180) {
                point = point.getNext();
            }
            hook = new InsnList();
            hook.add((AbstractInsnNode)new VarInsnNode(25, 0));
            hook.add((AbstractInsnNode)new FieldInsnNode(180, "vazkii/botania/common/block/subtile/generating/SubTileSpectrolus", "btweaks$wool_indices", "[I"));
            hook.add((AbstractInsnNode)new InsnNode(95));
            hook.add((AbstractInsnNode)new InsnNode(46));
            renderHud.instructions.insert(point, hook);
        }
    }

    private static MethodNode getMethod(ClassNode node, String name) {
        for (MethodNode method : node.methods) {
            if (!method.name.equals(name)) continue;
            return method;
        }
        return null;
    }
}

