/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.launchwrapper.IClassTransformer;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.tree.ClassNode;
import quaternary.botaniatweaks.asm.WorkaroundClassWriter;
import quaternary.botaniatweaks.asm.tweaks.AaaaaaaaaaaaTweak;
import quaternary.botaniatweaks.asm.tweaks.AnnoyingSpectrolusTweak;
import quaternary.botaniatweaks.asm.tweaks.CreativeManaPoolSizeTweak;
import quaternary.botaniatweaks.asm.tweaks.EntropinnyumAntiTNTDuplicationTweak;
import quaternary.botaniatweaks.asm.tweaks.EntryExitPointsTweak;
import quaternary.botaniatweaks.asm.tweaks.EverythingCanDecayTweak;
import quaternary.botaniatweaks.asm.tweaks.FlowerDurabilityTweak;
import quaternary.botaniatweaks.asm.tweaks.JeiPluginTweak;
import quaternary.botaniatweaks.asm.tweaks.KeyDamageTweak;
import quaternary.botaniatweaks.asm.tweaks.ManastormChargeOutputTweak;
import quaternary.botaniatweaks.asm.tweaks.OrechidPriceTweak;
import quaternary.botaniatweaks.asm.tweaks.PassiveDecayTimeTweak;
import quaternary.botaniatweaks.asm.tweaks.RosaArcanaOutputTweak;
import quaternary.botaniatweaks.asm.tweaks.Tweak;

public class BotaniaTweakerTransformer
implements IClassTransformer,
Opcodes {
    public static final String HOOKS = "quaternary/botaniatweaks/asm/BotaniaTweakerHooks";
    static List<Tweak> tweaks = new ArrayList<Tweak>();
    static List<String> allPatchedClasses = new ArrayList<String>();

    public byte[] transform(String name, String transformedName, byte[] basicClass) {
        if (!allPatchedClasses.contains(transformedName)) {
            return basicClass;
        }
        ClassReader reader = new ClassReader(basicClass);
        ClassNode node = new ClassNode();
        reader.accept((ClassVisitor)node, 0);
        for (Tweak t : tweaks) {
            t.patch(transformedName, node);
        }
        WorkaroundClassWriter writer = new WorkaroundClassWriter(3);
        node.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    static {
        tweaks.add(new PassiveDecayTimeTweak());
        tweaks.add(new EverythingCanDecayTweak());
        tweaks.add(new ManastormChargeOutputTweak());
        tweaks.add(new EntropinnyumAntiTNTDuplicationTweak());
        tweaks.add(new OrechidPriceTweak());
        tweaks.add(new EntryExitPointsTweak());
        tweaks.add(new CreativeManaPoolSizeTweak());
        tweaks.add(new RosaArcanaOutputTweak());
        tweaks.add(new KeyDamageTweak());
        tweaks.add(new JeiPluginTweak());
        tweaks.add(new AnnoyingSpectrolusTweak());
        tweaks.add(new FlowerDurabilityTweak());
        if (Boolean.parseBoolean(System.getProperty("botaniatweaks.awful", "false"))) {
            tweaks.add(new AaaaaaaaaaaaTweak());
        }
        for (Tweak t : tweaks) {
            allPatchedClasses.addAll(t.getAffectedClasses());
        }
    }
}

