/*
 * Decompiled with CFR 0.152.
 */
package quaternary.botaniatweaks.asm;

import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import mezz.jei.api.IJeiRuntime;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityFireworkRocket;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import quaternary.botaniatweaks.asm.monkeypatch.IHardSpectrolus;
import quaternary.botaniatweaks.modules.botania.config.BotaniaConfig;
import quaternary.botaniatweaks.modules.botania.wsd.ManaStatisticsWsd;
import quaternary.botaniatweaks.modules.jei.BotaniaTweaksJeiPlugin;
import quaternary.botaniatweaks.modules.jei.ModuleJei;
import vazkii.botania.api.subtile.SubTileGenerating;
import vazkii.botania.client.core.handler.CorporeaInputHandler;
import vazkii.botania.common.Botania;
import vazkii.botania.common.block.subtile.generating.SubTileSpectrolus;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.block.ItemBlockSpecialFlower;

public class BotaniaTweakerHooks {
    public static String currentFlowerName;
    public static boolean orechidGog;
    private static int oldMana;

    public static void beforeFlowerSuper(String flowerName, SubTileGenerating tile, int mana) {
        currentFlowerName = flowerName;
    }

    public static int getPassiveDecayTime() {
        if (currentFlowerName == null) {
            return 72000;
        }
        return (Integer)BotaniaConfig.DECAY_TIMES.getOrDefault(currentFlowerName, 72000);
    }

    public static boolean shouldFlowerDecay(String name) {
        return (Integer)BotaniaConfig.DECAY_TIMES.getOrDefault(name, 0) != 0;
    }

    public static void hardSpectrolusInitialize(SubTileSpectrolus tile) {
        ((IHardSpectrolus)tile).btweaks$setWoolOrder(BotaniaTweakerHooks.generateDefaultHardSpectrolusArray());
    }

    public static void hardSpectrolusWriteToPacketNBT(SubTileSpectrolus tile, NBTTagCompound tag) {
        if (!BotaniaConfig.ADVANCED_SPECTROLUS) {
            return;
        }
        tag.func_74783_a("btweaks-woolorder", ((IHardSpectrolus)tile).btweaks$getWoolOrder());
    }

    public static void hardSpectrolusReadFromPacketNBT(SubTileSpectrolus tile, NBTTagCompound tag) {
        if (!BotaniaConfig.ADVANCED_SPECTROLUS) {
            return;
        }
        int[] order = tag.func_74759_k("btweaks-woolorder");
        if (order.length != 16) {
            order = BotaniaTweakerHooks.generateDefaultHardSpectrolusArray();
        }
        ((IHardSpectrolus)tile).btweaks$setWoolOrder(order);
    }

    public static void hardSpectrolusOnBlockPlacedBy(SubTileSpectrolus tile, World world, ItemStack stack) {
        if (!BotaniaConfig.ADVANCED_SPECTROLUS) {
            return;
        }
        ((IHardSpectrolus)tile).btweaks$setNextColor(ItemNBTHelper.getInt((ItemStack)stack, (String)"btweaks-nextcolor", (int)0));
        int[] order = ItemNBTHelper.getIntArray((ItemStack)stack, (String)"btweaks-woolorder");
        if (order.length != 16) {
            order = BotaniaTweakerHooks.shuffleArray(BotaniaTweakerHooks.generateDefaultHardSpectrolusArray(), world.field_73012_v);
        }
        ((IHardSpectrolus)tile).btweaks$setWoolOrder(order);
    }

    public static void hardSpectrolusPopulateDropStackNBTs(SubTileSpectrolus tile, List<ItemStack> drops) {
        if (!BotaniaConfig.ADVANCED_SPECTROLUS) {
            return;
        }
        ItemNBTHelper.setInt((ItemStack)drops.get(0), (String)"btweaks-nextcolor", (int)((IHardSpectrolus)tile).btweaks$getNextColor());
        ItemNBTHelper.setIntArray((ItemStack)drops.get(0), (String)"btweaks-woolorder", (int[])((IHardSpectrolus)tile).btweaks$getWoolOrder());
    }

    private static int[] generateDefaultHardSpectrolusArray() {
        int[] arr = new int[16];
        for (int i = 0; i < arr.length; ++i) {
            arr[i] = i;
        }
        return arr;
    }

    private static int[] shuffleArray(int[] arr, Random rand) {
        for (int i = arr.length - 1; i > 0; --i) {
            int index = rand.nextInt(i + 1);
            int tmp = arr[index];
            arr[index] = arr[i];
            arr[i] = tmp;
        }
        return arr;
    }

    public static int getManastormBurstMana() {
        return MathHelper.func_76141_d((float)(120.0f * BotaniaConfig.MANASTORM_SCALE_FACTOR));
    }

    public static int getManastormBurstStartingMana() {
        return MathHelper.func_76141_d((float)(340.0f * BotaniaConfig.MANASTORM_SCALE_FACTOR));
    }

    public static float getManastormBurstLossjpgPerTick() {
        return BotaniaConfig.MANASTORM_SCALE_FACTOR;
    }

    public static int getRosaArcanaXPOrbMana() {
        return (int)(35.0f * BotaniaConfig.ROSA_ARCANA_ORB_MULTIPLIER);
    }

    public static List<EntityTNTPrimed> processTNTList(List<EntityTNTPrimed> inList) {
        Iterator<EntityTNTPrimed> it = inList.iterator();
        while (it.hasNext()) {
            EntityTNTPrimed tnt = it.next();
            if (BotaniaConfig.DENY_DUPLICATED_TNT && tnt.func_184216_O().contains("CheatyDupe")) {
                if (tnt.func_184536_l() == 1) {
                    BotaniaTweakerHooks.doTNTSilliness(tnt);
                }
                it.remove();
                continue;
            }
            if (!BotaniaConfig.FORCE_VANILLA_TNT || tnt.getClass().equals(EntityTNTPrimed.class)) continue;
            it.remove();
        }
        return inList;
    }

    static void doTNTSilliness(EntityTNTPrimed tnt) {
        try {
            NBTTagCompound fireworkNBT = JsonToNBT.func_180713_a((String)"{Fireworks:{Flight:1b,Explosions:[{Type:2b,Trail:1b,Colors:[I;15790320]},{Type:1b,Colors:[I;11743532],Flicker:1b}]}}");
            ItemStack fireworkItem = new ItemStack(Items.field_151152_bP, 1, 0);
            fireworkItem.func_77982_d(fireworkNBT);
            EntityFireworkRocket firework = new EntityFireworkRocket(tnt.field_70170_p, tnt.field_70165_t, tnt.field_70163_u, tnt.field_70161_v, fireworkItem);
            firework.field_92055_b = 1;
            tnt.field_70170_p.func_72838_d((Entity)firework);
            List nearbyPlayers = tnt.field_70170_p.field_73010_i.stream().filter(player -> player.func_70068_e((Entity)tnt) < 625.0).collect(Collectors.toList());
            for (EntityPlayer p : nearbyPlayers) {
                TextComponentTranslation flowerName = new TextComponentTranslation("tile.botania:flower.entropinnyum.name", new Object[0]);
                TextComponentTranslation niceTry = new TextComponentTranslation("botania_tweaks.entrodupe.nicetry", new Object[0]);
                TextComponentTranslation chatString = new TextComponentTranslation("chat.type.text", new Object[]{flowerName, niceTry});
                p.func_145747_a((ITextComponent)chatString);
            }
            tnt.func_70106_y();
        }
        catch (NBTException nBTException) {
            // empty catch block
        }
    }

    public static void afterFlowerSuper(String flowerName, SubTileGenerating flower, int oldMana_) {
        if (!BotaniaConfig.MANA_GENERATION_STATISTICS || flower.getWorld().field_72995_K) {
            return;
        }
        oldMana = oldMana_;
    }

    public static void beforeFlowerReturn(String flowerName, SubTileGenerating flower, int newMana) {
        if (!BotaniaConfig.MANA_GENERATION_STATISTICS || flower.getWorld().field_72995_K) {
            return;
        }
        flowerName = BotaniaTweakerHooks.fixThermalilyFlowerName(flowerName, flower);
        int manaDifference = newMana - oldMana;
        if (flower.canGeneratePassively()) {
            manaDifference += flower.getWorld().func_82737_E() % (long)flower.getDelayBetweenPassiveGeneration() == 0L ? flower.getValueForPassiveGeneration() : 0;
        }
        if (manaDifference != 0) {
            ManaStatisticsWsd wsd = ManaStatisticsWsd.get(flower.getWorld());
            wsd.trackMana(flowerName, manaDifference);
        }
        oldMana = 0;
    }

    private static String fixThermalilyFlowerName(String flowerName, SubTileGenerating flower) {
        if (flowerName.equals("hydroangeas")) {
            String className = flower.getClass().getName();
            if (className.endsWith("Thermalily")) {
                return "thermalily";
            }
            return "hydroangeas";
        }
        return flowerName;
    }

    public static int getCreativePoolSize() {
        return BotaniaConfig.CREATIVE_POOL_SIZE;
    }

    public static float getKeyDamage() {
        return 20.0f * BotaniaConfig.KEY_DAMAGE_SCALE;
    }

    public static boolean durabilityShowDurabilityBar(ItemStack stack) {
        String type = ItemBlockSpecialFlower.getType((ItemStack)stack);
        if (BotaniaConfig.FLOWER_DURABILITY && BotaniaTweakerHooks.shouldFlowerDecay(type)) {
            return ItemNBTHelper.getInt((ItemStack)stack, (String)"passiveDecayTicks", (int)0) != 0;
        }
        return false;
    }

    public static double durabilityGetDurabilityForDisplay(ItemStack stack) {
        if (!BotaniaConfig.FLOWER_DURABILITY) {
            return 1.0;
        }
        String type = ItemBlockSpecialFlower.getType((ItemStack)stack);
        int max = (Integer)BotaniaConfig.DECAY_TIMES.get(type);
        if (max == 0) {
            return 1.0;
        }
        int progress = ItemNBTHelper.getInt((ItemStack)stack, (String)"passiveDecayTicks", (int)0);
        return (double)progress / (double)max;
    }

    static {
        orechidGog = Botania.gardenOfGlassLoaded;
        oldMana = 0;
    }

    public static class Jei {
        public static void patchCorporeaKeybind(IJeiRuntime runtime) {
            if (ModuleJei.FIX_CORPOREA_REQUEST_KEYBIND) {
                CorporeaInputHandler.jeiPanelSupplier = () -> {
                    IJeiRuntime jeiRuntime = BotaniaTweaksJeiPlugin.jeiRuntime;
                    Object thing = jeiRuntime.getIngredientListOverlay().getIngredientUnderMouse();
                    if (ModuleJei.FIX_CORPOREA_REQUEST_KEYBIND && thing == null) {
                        thing = jeiRuntime.getBookmarkOverlay().getIngredientUnderMouse();
                    }
                    if (thing == null && Minecraft.func_71410_x().field_71462_r == jeiRuntime.getRecipesGui()) {
                        thing = jeiRuntime.getRecipesGui().getIngredientUnderMouse();
                    }
                    if (thing instanceof ItemStack) {
                        return (ItemStack)thing;
                    }
                    return null;
                };
            }
        }
    }
}

