/*
 * Decompiled with CFR 0.152.
 */
package the_fireplace.mobrebirth;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.relauncher.FMLInjectionData;
import net.minecraftforge.fml.relauncher.Side;
import org.apache.logging.log4j.Level;
import the_fireplace.mobrebirth.client.gui.RebirthChanceSlider;
import the_fireplace.mobrebirth.common.CommonEvents;
import the_fireplace.mobrebirth.common.ConfigValues;

@Mod(modid="mobrebirth", name="Mob Rebirth", canBeDeactivated=true, guiFactory="the_fireplace.mobrebirth.client.gui.MobRebirthGuiFactory", updateJSON="https://bitbucket.org/The_Fireplace/minecraft-mod-updates/raw/master/mobrebirth.json", version="7.0.6", acceptedMinecraftVersions="[1.12.2]")
public class MobRebirth {
    public static final String MODID = "mobrebirth";
    public static final String MODNAME = "Mob Rebirth";
    private static final File configDir = new File((File)FMLInjectionData.data()[6], "config/MobRebirth/");
    private static final File customConfigDir = new File(configDir, "mobs");
    private boolean customProperties = false;
    public static Map<String, Configuration> mobConfigs = Maps.newHashMap();
    @Mod.Instance(value="mobrebirth")
    public static MobRebirth instance;
    public static Configuration mobcontrols;
    public static Configuration chancecontrols;
    public static Configuration behaviorcontrols;
    public static Configuration debugcontrols;
    public static Configuration general;
    public static Property ALLOWBOSSES_PROPERTY;
    public static Property ALLOWSLIMES_PROPERTY;
    public static Property ANIMALREBIRTH_PROPERTY;
    public static Property REBIRTHCHANCE_PROPERTY;
    public static Map<ResourceLocation, Property> REBIRTHCHANCEMAP;
    public static Property MULTIMOBCHANCE_PROPERTY;
    public static Map<ResourceLocation, Property> MULTIMOBCHANCEMAP;
    public static Property DAMAGEFROMSUNLIGHT_PROPERTY;
    public static Property DROPEGG_PROPERTY;
    public static Map<ResourceLocation, Property> DROPEGGMAP;
    public static Property EXTRAMOBCOUNT_PROPERTY;
    public static Map<ResourceLocation, Property> EXTRAMOBCOUNTMAP;
    public static Property MULTIMOBMODE_PROPERTY;
    public static Property REBIRTHFROMNONPLAYER_PROPERTY;
    public static Map<ResourceLocation, Property> PLAYERREBIRTHMAP;
    public static Property VANILLAONLY_PROPERTY;
    public static Property CUSTOMENTITIES_PROPERTY;

    public boolean getHasCustomMobSettings() {
        return this.customProperties;
    }

    public MobRebirth() {
        REBIRTHCHANCEMAP = Maps.newHashMap();
        MULTIMOBCHANCEMAP = Maps.newHashMap();
        DROPEGGMAP = Maps.newHashMap();
        EXTRAMOBCOUNTMAP = Maps.newHashMap();
        PLAYERREBIRTHMAP = Maps.newHashMap();
    }

    public static void syncConfig() {
        ConfigValues.ALLOWBOSSES = ALLOWBOSSES_PROPERTY.getBoolean();
        ConfigValues.ALLOWSLIMES = ALLOWSLIMES_PROPERTY.getBoolean();
        ConfigValues.ANIMALREBIRTH = ANIMALREBIRTH_PROPERTY.getBoolean();
        ConfigValues.REBIRTHCHANCE = REBIRTHCHANCE_PROPERTY.getDouble();
        ConfigValues.MULTIMOBCHANCE = MULTIMOBCHANCE_PROPERTY.getDouble();
        ConfigValues.DAMAGEFROMSUNLIGHT = DAMAGEFROMSUNLIGHT_PROPERTY.getBoolean();
        ConfigValues.DROPEGG = DROPEGG_PROPERTY.getBoolean();
        ConfigValues.EXTRAMOBCOUNT = EXTRAMOBCOUNT_PROPERTY.getInt();
        ConfigValues.MULTIMOBMODE = MULTIMOBMODE_PROPERTY.getString();
        ConfigValues.REBIRTHFROMNONPLAYER = REBIRTHFROMNONPLAYER_PROPERTY.getBoolean();
        ConfigValues.VANILLAONLY = VANILLAONLY_PROPERTY.getBoolean();
        ConfigValues.CUSTOMENTITIES = CUSTOMENTITIES_PROPERTY.getStringList();
        if (mobcontrols.hasChanged()) {
            mobcontrols.save();
        }
        if (chancecontrols.hasChanged()) {
            chancecontrols.save();
        }
        if (behaviorcontrols.hasChanged()) {
            behaviorcontrols.save();
        }
        if (debugcontrols.hasChanged()) {
            debugcontrols.save();
        }
        if (general.hasChanged()) {
            general.save();
        }
        MobRebirth.instance.customProperties = ConfigValues.CUSTOMENTITIES != null && ConfigValues.CUSTOMENTITIES.length > 0;
        for (int i = 0; i < ConfigValues.CUSTOMENTITIES.length; ++i) {
            ConfigValues.CUSTOMENTITIES[i] = new ResourceLocation(ConfigValues.CUSTOMENTITIES[i].toLowerCase()).func_110623_a();
        }
    }

    @Mod.EventHandler
    public void PreInit(FMLPreInitializationEvent event) {
        mobcontrols = new Configuration(new File(configDir, "mobcontrols.cfg"));
        chancecontrols = new Configuration(new File(configDir, "chancecontrols.cfg"));
        behaviorcontrols = new Configuration(new File(configDir, "behaviorcontrols.cfg"));
        debugcontrols = new Configuration(new File(configDir, "debugcontrols.cfg"));
        general = new Configuration(new File(configDir, "general.cfg"));
        mobcontrols.load();
        chancecontrols.load();
        behaviorcontrols.load();
        debugcontrols.load();
        general.load();
        ALLOWBOSSES_PROPERTY = mobcontrols.get("general", "allowbosses", false);
        ALLOWSLIMES_PROPERTY = mobcontrols.get("general", "allowslimes", true);
        ANIMALREBIRTH_PROPERTY = mobcontrols.get("general", "animalrebirth", false);
        REBIRTHCHANCE_PROPERTY = chancecontrols.get("general", "rebirthchance", 0.25);
        MULTIMOBCHANCE_PROPERTY = chancecontrols.get("general", "multimobchance", 0.05);
        DAMAGEFROMSUNLIGHT_PROPERTY = behaviorcontrols.get("general", "damagefromsunlight", true);
        DROPEGG_PROPERTY = behaviorcontrols.get("general", "dropegg", false);
        EXTRAMOBCOUNT_PROPERTY = behaviorcontrols.get("general", "extramobcount", 0);
        MULTIMOBMODE_PROPERTY = behaviorcontrols.get("general", "multimobmode", "continuous");
        REBIRTHFROMNONPLAYER_PROPERTY = behaviorcontrols.get("general", "rebirthfromnonplayer", false);
        VANILLAONLY_PROPERTY = debugcontrols.get("general", "vanillaonly", false);
        CUSTOMENTITIES_PROPERTY = general.get("general", "customentities", ConfigValues.CUSTOMENTITIES_DEFAULT);
        REBIRTHCHANCE_PROPERTY.setMaxValue(1.0);
        REBIRTHCHANCE_PROPERTY.setMinValue(0.0);
        MULTIMOBCHANCE_PROPERTY.setMaxValue(1.0);
        MULTIMOBCHANCE_PROPERTY.setMinValue(0.0);
        if (event.getSide().isClient()) {
            REBIRTHCHANCE_PROPERTY.setConfigEntryClass(RebirthChanceSlider.class);
            MULTIMOBCHANCE_PROPERTY.setConfigEntryClass(RebirthChanceSlider.class);
        }
        MULTIMOBMODE_PROPERTY.setValidValues(new String[]{"all", "continuous", "per-mob"});
        this.transferOldConfig(event.getSuggestedConfigurationFile());
        MobRebirth.syncConfig();
        MobRebirth.createMobConfigs();
        MobRebirth.syncMobConfigs();
    }

    @Mod.EventHandler
    public void Init(FMLInitializationEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)new CommonEvents());
    }

    private void transferOldConfig(File file) {
        if (file.exists()) {
            Configuration temp = new Configuration(file);
            ConfigCategory cat = temp.getCategory("general");
            if (cat.containsKey("mrb1")) {
                DROPEGG_PROPERTY.set(!cat.get("mrb1").getBoolean());
            }
            if (cat.containsKey("mrb2")) {
                REBIRTHCHANCE_PROPERTY.set(cat.get("mrb2").getDouble());
            }
            if (cat.containsKey("mrb3")) {
                ANIMALREBIRTH_PROPERTY.set(cat.get("mrb3").getBoolean());
            }
            if (cat.containsKey("mrb4")) {
                EXTRAMOBCOUNT_PROPERTY.set(cat.get("mrb4").getInt());
            }
            if (cat.containsKey("mrb5")) {
                REBIRTHFROMNONPLAYER_PROPERTY.set(cat.get("mrb5").getBoolean());
            }
            if (cat.containsKey("mrb6")) {
                MULTIMOBCHANCE_PROPERTY.set(cat.get("mrb6").getDouble());
            }
            if (cat.containsKey("mrb7")) {
                MULTIMOBMODE_PROPERTY.set(cat.get("mrb7").getString());
            }
            if (cat.containsKey("solar_apocalypse_fix")) {
                DAMAGEFROMSUNLIGHT_PROPERTY.set(!cat.get("solar_apocalypse_fix").getBoolean());
            }
            if (cat.containsKey("allowbosses")) {
                ALLOWBOSSES_PROPERTY.set(cat.get("allowbosses").getBoolean());
            }
            if (cat.containsKey("allowslimes")) {
                ALLOWSLIMES_PROPERTY.set(cat.get("allowslimes").getBoolean());
            }
            if (cat.containsKey("vanillaonly")) {
                VANILLAONLY_PROPERTY.set(cat.get("vanillaonly").getBoolean());
            }
            if (file.delete()) {
                MobRebirth.logInfo("Old Config transferred.", new Object[0]);
            }
        }
    }

    public static void createMobConfigs() {
        if (MobRebirth.instance.customProperties) {
            for (String mobidstring : ConfigValues.CUSTOMENTITIES) {
                ResourceLocation mobid = new ResourceLocation(mobidstring.toLowerCase());
                Configuration mobConfig = new Configuration(new File(customConfigDir, mobid.func_110623_a().toLowerCase() + ".cfg"));
                mobConfig.load();
                if (!REBIRTHCHANCEMAP.containsKey(mobid)) {
                    REBIRTHCHANCEMAP.put(mobid, mobConfig.get("general", "rebirthchance", ConfigValues.REBIRTHCHANCE));
                }
                if (!MULTIMOBCHANCEMAP.containsKey(mobid)) {
                    MULTIMOBCHANCEMAP.put(mobid, mobConfig.get("general", "multimobchance", ConfigValues.MULTIMOBCHANCE));
                }
                if (!DROPEGGMAP.containsKey(mobid)) {
                    DROPEGGMAP.put(mobid, mobConfig.get("general", "dropegg", ConfigValues.DROPEGG));
                }
                if (!EXTRAMOBCOUNTMAP.containsKey(mobid)) {
                    EXTRAMOBCOUNTMAP.put(mobid, mobConfig.get("general", "extramobcount", ConfigValues.EXTRAMOBCOUNT));
                }
                if (!PLAYERREBIRTHMAP.containsKey(mobid)) {
                    PLAYERREBIRTHMAP.put(mobid, mobConfig.get("general", "rebirthfromnonplayer", ConfigValues.REBIRTHFROMNONPLAYER));
                }
                if (FMLCommonHandler.instance().getEffectiveSide() == Side.CLIENT) {
                    REBIRTHCHANCEMAP.get(mobid).setConfigEntryClass(RebirthChanceSlider.class);
                    MULTIMOBCHANCEMAP.get(mobid).setConfigEntryClass(RebirthChanceSlider.class);
                }
                REBIRTHCHANCEMAP.get(mobid).setMaxValue(1.0);
                REBIRTHCHANCEMAP.get(mobid).setMinValue(0.0);
                MULTIMOBCHANCEMAP.get(mobid).setMaxValue(1.0);
                MULTIMOBCHANCEMAP.get(mobid).setMinValue(0.0);
                mobConfigs.put(mobidstring, mobConfig);
            }
        }
    }

    public static void syncMobConfigs() {
        if (MobRebirth.instance.customProperties) {
            ConfigValues.REBIRTHCHANCEMAP.clear();
            ConfigValues.MULTIMOBCHANCEMAP.clear();
            ConfigValues.DROPEGGMAP.clear();
            ConfigValues.EXTRAMOBCOUNTMAP.clear();
            ConfigValues.REBIRTHFROMNONPLAYERMAP.clear();
            for (String mobidstring : ConfigValues.CUSTOMENTITIES) {
                ResourceLocation mobid = new ResourceLocation(mobidstring.toLowerCase());
                if (REBIRTHCHANCEMAP.get(mobid) == null) continue;
                ConfigValues.REBIRTHCHANCEMAP.put(mobid, REBIRTHCHANCEMAP.get(mobid).getDouble());
                ConfigValues.MULTIMOBCHANCEMAP.put(mobid, MULTIMOBCHANCEMAP.get(mobid).getDouble());
                ConfigValues.DROPEGGMAP.put(mobid, DROPEGGMAP.get(mobid).getBoolean());
                ConfigValues.EXTRAMOBCOUNTMAP.put(mobid, EXTRAMOBCOUNTMAP.get(mobid).getInt());
                ConfigValues.REBIRTHFROMNONPLAYERMAP.put(mobid, PLAYERREBIRTHMAP.get(mobid).getBoolean());
                if (!mobConfigs.get(mobidstring).hasChanged()) continue;
                mobConfigs.get(mobidstring).save();
            }
        }
    }

    public static void logInfo(String log, Object ... params) {
        FMLLog.log((String)MODNAME, (Level)Level.INFO, (String)log, (Object[])params);
    }

    public static void logDebug(String log, Object ... params) {
        FMLLog.log((String)MODNAME, (Level)Level.DEBUG, (String)log, (Object[])params);
    }

    public static void logError(String log, Object ... params) {
        FMLLog.log((String)MODNAME, (Level)Level.ERROR, (String)log, (Object[])params);
    }

    public static void logTrace(String log, Object ... params) {
        FMLLog.log((String)MODNAME, (Level)Level.TRACE, (String)log, (Object[])params);
    }

    public static void logWarn(String log, Object ... params) {
        FMLLog.log((String)MODNAME, (Level)Level.WARN, (String)log, (Object[])params);
    }
}

