/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.persist.world;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.cyclopscore.persist.nbt.NBTPersist;
import org.cyclops.cyclopscore.persist.world.WorldStorage;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.core.network.packet.ActionLabelPacket;
import org.cyclops.integrateddynamics.core.network.packet.AllLabelsPacket;

public class LabelsWorldStorage
extends WorldStorage {
    private static LabelsWorldStorage INSTANCE = null;
    @NBTPersist
    private Map<Integer, String> labels = Maps.newHashMap();

    private LabelsWorldStorage(ModBase mod) {
        super(mod);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public static LabelsWorldStorage getInstance(ModBase mod) {
        if (INSTANCE == null) {
            INSTANCE = new LabelsWorldStorage(mod);
        }
        return INSTANCE;
    }

    public void reset() {
        this.labels.clear();
    }

    protected String getDataId() {
        return "Labels";
    }

    public synchronized void putUnsafe(int variableId, @Nonnull String label) {
        Objects.requireNonNull(label);
        this.labels.put(variableId, label);
    }

    public synchronized void removeUnsafe(int variableId) {
        this.labels.remove(variableId);
    }

    public void put(int variableId, @Nonnull String label) {
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new ActionLabelPacket(variableId, label));
        } else {
            this.putUnsafe(variableId, label);
            IntegratedDynamics._instance.getPacketHandler().sendToAll((PacketBase)new ActionLabelPacket(variableId, label));
        }
    }

    public void remove(int variableId) {
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new ActionLabelPacket(variableId, null));
        } else {
            this.removeUnsafe(variableId);
            IntegratedDynamics._instance.getPacketHandler().sendToAll((PacketBase)new ActionLabelPacket(variableId, null));
        }
    }

    public synchronized String getLabel(int variableId) {
        return this.labels.get(variableId);
    }

    @SubscribeEvent
    public void onPlayerLoggedIn(PlayerEvent.PlayerLoggedInEvent event) {
        if (!MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getPacketHandler().sendToPlayer((PacketBase)new AllLabelsPacket(this.labels), (EntityPlayerMP)event.player);
        }
    }

    public void afterLoad() {
        super.afterLoad();
        this.labels.entrySet().removeIf(integerStringEntry -> integerStringEntry.getValue() == null);
    }
}

