/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.part;

import java.beans.ConstructorProperties;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.cyclopscore.inventory.IGuiContainerProvider;
import org.cyclops.integrateddynamics.api.part.IPartState;
import org.cyclops.integrateddynamics.api.part.IPartType;
import org.cyclops.integrateddynamics.api.part.PartRenderPosition;
import org.cyclops.integrateddynamics.core.client.gui.ExtendedGuiHandler;
import org.cyclops.integrateddynamics.core.client.gui.container.GuiPartSettings;
import org.cyclops.integrateddynamics.core.inventory.container.ContainerPartSettings;
import org.cyclops.integrateddynamics.core.part.PartTypeBase;

public abstract class PartTypeConfigurable<P extends IPartType<P, S>, S extends IPartState<P>>
extends PartTypeBase<P, S> {
    private final IGuiContainerProvider settingsGuiProvider;

    public PartTypeConfigurable(String name, PartRenderPosition partRenderPosition) {
        super(name, partRenderPosition);
        if (this.hasSettings()) {
            int guiIDSettings = Helpers.getNewId((ModBase)this.getModGui(), (Helpers.IDType)Helpers.IDType.GUI);
            this.settingsGuiProvider = this.constructSettingsGuiProvider(guiIDSettings);
            this.getModGui().getGuiHandler().registerGUI(this.settingsGuiProvider, ExtendedGuiHandler.PART);
        } else {
            this.settingsGuiProvider = null;
        }
    }

    protected IGuiContainerProvider constructSettingsGuiProvider(int guiId) {
        return new GuiProviderSettings(guiId, this.getModGui());
    }

    public boolean hasSettings() {
        return true;
    }

    public IGuiContainerProvider getSettingsGuiProvider() {
        return this.settingsGuiProvider;
    }

    public static class GuiProviderSettings
    implements IGuiContainerProvider {
        private final int guiID;
        private final ModBase modGui;

        public Class<? extends Container> getContainer() {
            return ContainerPartSettings.class;
        }

        public Class<? extends GuiScreen> getGui() {
            return GuiPartSettings.class;
        }

        @ConstructorProperties(value={"guiID", "modGui"})
        public GuiProviderSettings(int guiID, ModBase modGui) {
            this.guiID = guiID;
            this.modGui = modGui;
        }

        public int getGuiID() {
            return this.guiID;
        }

        public ModBase getModGui() {
            return this.modGui;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof GuiProviderSettings)) {
                return false;
            }
            GuiProviderSettings other = (GuiProviderSettings)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getGuiID() != other.getGuiID()) {
                return false;
            }
            ModBase this$modGui = this.getModGui();
            ModBase other$modGui = other.getModGui();
            return !(this$modGui == null ? other$modGui != null : !this$modGui.equals(other$modGui));
        }

        protected boolean canEqual(Object other) {
            return other instanceof GuiProviderSettings;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getGuiID();
            ModBase $modGui = this.getModGui();
            result = result * 59 + ($modGui == null ? 43 : $modGui.hashCode());
            return result;
        }

        public String toString() {
            return "PartTypeConfigurable.GuiProviderSettings(guiID=" + this.getGuiID() + ", modGui=" + this.getModGui() + ")";
        }
    }
}

