/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.logicprogrammer;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonArrow;
import org.cyclops.cyclopscore.client.gui.component.button.GuiButtonText;
import org.cyclops.cyclopscore.client.gui.component.input.GuiArrowedListField;
import org.cyclops.cyclopscore.client.gui.component.input.IInputListener;
import org.cyclops.cyclopscore.helper.Helpers;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.helper.MinecraftHelpers;
import org.cyclops.cyclopscore.helper.RenderHelpers;
import org.cyclops.cyclopscore.network.PacketBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.client.gui.subgui.ISubGuiBox;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValue;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.api.logicprogrammer.ILogicProgrammerElementType;
import org.cyclops.integrateddynamics.api.logicprogrammer.IValueTypeLogicProgrammerElement;
import org.cyclops.integrateddynamics.client.gui.GuiLogicProgrammerBase;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypeList;
import org.cyclops.integrateddynamics.core.evaluate.variable.ValueTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.IRenderPatternValueTypeTooltip;
import org.cyclops.integrateddynamics.core.logicprogrammer.LogicProgrammerElementTypes;
import org.cyclops.integrateddynamics.core.logicprogrammer.RenderPattern;
import org.cyclops.integrateddynamics.core.logicprogrammer.ValueTypeLPElementBase;
import org.cyclops.integrateddynamics.inventory.container.ContainerLogicProgrammerBase;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerSetElementInventory;
import org.cyclops.integrateddynamics.network.packet.LogicProgrammerValueTypeListValueChangedPacket;

public class ValueTypeListLPElement
extends ValueTypeLPElementBase {
    private IValueType listValueType;
    private Map<Integer, IValueTypeLogicProgrammerElement> subElements;
    private Map<Integer, RenderPattern> subElementGuis;
    private int length = 0;
    private int activeElement = -1;
    @SideOnly(value=Side.CLIENT)
    private MasterSubGuiRenderPattern masterGui;
    private ValueTypeList.ValueList serverValue = null;

    public ValueTypeListLPElement() {
        super(ValueTypes.LIST);
    }

    public void setServerValue(ValueTypeList.ValueList serverValue) {
        this.serverValue = serverValue;
    }

    @Override
    public ILogicProgrammerElementType getType() {
        return LogicProgrammerElementTypes.VALUETYPE;
    }

    @Override
    public IConfigRenderPattern getRenderPattern() {
        return IConfigRenderPattern.NONE_CANVAS;
    }

    @Override
    public boolean canWriteElementPre() {
        return MinecraftHelpers.isClientSide() ? this.listValueType != null : this.serverValue != null;
    }

    protected List<IValue> constructValues() {
        ArrayList valueList = Lists.newArrayListWithExpectedSize((int)this.length);
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> value : this.subElements.entrySet()) {
            if (value.getValue().validate() == null) {
                valueList.add(value.getKey(), value.getValue().getValue());
                continue;
            }
            valueList.add(value.getKey(), this.listValueType.getDefault());
        }
        return valueList;
    }

    @Override
    public IValue getValue() {
        return MinecraftHelpers.isClientSide() ? ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues()) : this.serverValue;
    }

    public void setListValueType(IValueType listValueType) {
        this.listValueType = listValueType;
        this.subElements = Maps.newHashMap();
        this.subElementGuis = Maps.newHashMap();
        this.setLength(0);
    }

    public void setLength(int length) {
        this.length = length;
        this.setActiveElement(length - 1);
    }

    public void setActiveElement(int index) {
        this.activeElement = index;
        if (index >= 0 && !this.subElements.containsKey(index)) {
            IValueTypeLogicProgrammerElement subElement = this.listValueType.createLogicProgrammerElement();
            this.subElements.put(index, subElement);
            subElement.activate();
        }
        if (MinecraftHelpers.isClientSide()) {
            this.masterGui.setActiveElement(this.activeElement);
            this.masterGui.container.onDirty();
        }
    }

    public void removeElement(int index) {
        Map<Integer, IValueTypeLogicProgrammerElement> oldSubElements = this.subElements;
        Map<Integer, RenderPattern> oldSubElementGuis = this.subElementGuis;
        this.subElements = Maps.newHashMap();
        this.subElementGuis = Maps.newHashMap();
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : oldSubElements.entrySet()) {
            int i = entry.getKey();
            if (i < index) {
                this.subElements.put(i, entry.getValue());
                this.subElementGuis.put(i, oldSubElementGuis.get(i));
                continue;
            }
            if (i <= index) continue;
            this.subElements.put(i - 1, entry.getValue());
            this.subElementGuis.put(i - 1, oldSubElementGuis.get(i));
        }
        this.setLength(this.length - 1);
    }

    @Override
    public void activate() {
    }

    @Override
    public void deactivate() {
        this.activeElement = -1;
    }

    @Override
    public L10NHelpers.UnlocalizedString validate() {
        if (!MinecraftHelpers.isClientSide()) {
            return this.serverValue == null ? new L10NHelpers.UnlocalizedString() : null;
        }
        if (MinecraftHelpers.isClientSide()) {
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerValueTypeListValueChangedPacket(this.listValueType == null ? ValueTypes.LIST.getDefault() : ValueTypeList.ValueList.ofList(this.listValueType, this.constructValues())));
        }
        if (this.listValueType == null) {
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_input_item", new Object[0]);
        }
        for (Map.Entry<Integer, IValueTypeLogicProgrammerElement> entry : this.subElements.entrySet()) {
            L10NHelpers.UnlocalizedString error = entry.getValue().validate();
            if (error == null) continue;
            return new L10NHelpers.UnlocalizedString("valuetype.integrateddynamics.error.invalid_list_element", new Object[]{entry.getKey(), error});
        }
        return null;
    }

    @Override
    public boolean isItemValidForSlot(int slotId, ItemStack itemStack) {
        return slotId == 0 && super.isItemValidForSlot(slotId, itemStack) || this.activeElement >= 0 && this.subElements.containsKey(this.activeElement) && this.subElements.get(this.activeElement).isItemValidForSlot(slotId, itemStack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISubGuiBox createSubGui(int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
        this.masterGui = new MasterSubGuiRenderPattern(this, baseX, baseY, maxWidth, maxHeight, gui, container);
        return this.masterGui;
    }

    @SideOnly(value=Side.CLIENT)
    protected static class ListElementSubGui
    extends RenderPattern<ValueTypeListLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase> {
        private GuiButtonArrow arrowLeft;
        private GuiButtonArrow arrowRight;
        private GuiButton arrowRemove;

        public ListElementSubGui(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            RenderPattern subGui = (RenderPattern)element.subElementGuis.get(element.activeElement);
            IValueTypeLogicProgrammerElement subElement = (IValueTypeLogicProgrammerElement)element.subElements.get(element.activeElement);
            if (subGui == null) {
                subGui = (RenderPattern)subElement.createSubGui(baseX, baseY, maxWidth, maxHeight / 3 * 2, gui, container);
                element.subElementGuis.put(element.activeElement, subGui);
            }
            int x = this.getX() + baseX - 24;
            int y = this.getY() + baseY - 23;
            gui.getContainer().setElementInventory(subElement, x, y);
            subElement.setValueInGui(subGui);
            this.subGuiHolder.addSubGui(subGui);
            if (subGui instanceof IRenderPatternValueTypeTooltip) {
                ((IRenderPatternValueTypeTooltip)((Object)subGui)).setRenderTooltip(false);
            }
            IntegratedDynamics._instance.getPacketHandler().sendToServer((PacketBase)new LogicProgrammerSetElementInventory(element.listValueType, x, y));
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4 * 3;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowLeft = new GuiButtonArrow(1, x, y, GuiButtonArrow.Direction.WEST);
            this.buttonList.add(this.arrowLeft);
            this.arrowRight = new GuiButtonArrow(1, x + this.getWidth() - this.arrowLeft.field_146120_f - 1, y, GuiButtonArrow.Direction.EAST);
            this.buttonList.add(this.arrowRight);
            this.arrowRemove = new GuiButtonText(2, x + this.getWidth() / 2 - this.arrowLeft.field_146120_f / 2, y + this.getHeight() - 13, 12, 12, "-", true);
            this.buttonList.add(this.arrowRemove);
            this.arrowLeft.field_146124_l = ((ValueTypeListLPElement)this.element).activeElement > 0;
            this.arrowRight.field_146124_l = ((ValueTypeListLPElement)this.element).activeElement < ((ValueTypeListLPElement)this.element).length - 1;
            this.arrowRemove.field_146124_l = ((ValueTypeListLPElement)this.element).length > 0;
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowLeft) {
                ((ValueTypeListLPElement)this.element).setActiveElement(((ValueTypeListLPElement)this.element).activeElement - 1);
            } else if (guibutton == this.arrowRight) {
                ((ValueTypeListLPElement)this.element).setActiveElement(((ValueTypeListLPElement)this.element).activeElement + 1);
            } else if (guibutton == this.arrowRemove) {
                ((ValueTypeListLPElement)this.element).removeElement(((ValueTypeListLPElement)this.element).activeElement);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            int x = guiLeft + this.getX() + this.getWidth() / 2;
            int y = guiTop + this.getY() + 4;
            RenderHelpers.drawScaledCenteredString((FontRenderer)fontRenderer, (String)String.valueOf(((ValueTypeListLPElement)this.element).activeElement), (int)(x - 4), (int)(y + 2), (int)10, (int)Helpers.RGBToInt((int)20, (int)20, (int)20));
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class SelectionSubGui
    extends RenderPattern<ValueTypeListLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IInputListener {
        private GuiArrowedListField<IValueType> valueTypeSelector = null;
        private GuiButton arrowAdd;

        public SelectionSubGui(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
        }

        @Override
        public int getHeight() {
            return super.getHeight() / 4;
        }

        protected static List<IValueType> getValueTypes() {
            ArrayList valueTypes = Lists.newArrayList(LogicProgrammerElementTypes.VALUETYPE.getValueTypes());
            valueTypes.remove(ValueTypes.LIST);
            valueTypes.add(ValueTypes.CATEGORY_ANY);
            return valueTypes;
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.valueTypeSelector = new GuiArrowedListField(0, Minecraft.func_71410_x().field_71466_p, this.getX() + guiLeft + this.getWidth() / 2 - 50, this.getY() + guiTop + 2, 100, 15, true, true, SelectionSubGui.getValueTypes());
            this.valueTypeSelector.setListener((IInputListener)this);
            if (((ValueTypeListLPElement)this.element).activeElement == -1) {
                this.onChanged();
            }
            int x = guiLeft + this.getX();
            int y = guiTop + this.getY();
            this.arrowAdd = new GuiButtonText(1, x + this.getWidth() - 13, y + this.getHeight() - 13, 12, 12, "+", true);
            this.buttonList.add(this.arrowAdd);
        }

        @Override
        public void mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
            super.mouseClicked(mouseX, mouseY, mouseButton);
            this.valueTypeSelector.func_146192_a(mouseX, mouseY, mouseButton);
        }

        @Override
        protected void actionPerformed(GuiButton guibutton) {
            super.actionPerformed(guibutton);
            if (guibutton == this.arrowAdd) {
                ((ValueTypeListLPElement)this.element).setLength(((ValueTypeListLPElement)this.element).length + 1);
            }
        }

        @Override
        public void drawGuiContainerBackgroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, float partialTicks, int mouseX, int mouseY) {
            super.drawGuiContainerBackgroundLayer(guiLeft, guiTop, textureManager, fontRenderer, partialTicks, mouseX, mouseY);
            this.valueTypeSelector.drawTextBox(Minecraft.func_71410_x(), mouseX, mouseY);
        }

        public void onChanged() {
            IValueType newType = (IValueType)this.valueTypeSelector.getActiveElement();
            ((ValueTypeListLPElement)this.element).setListValueType(newType);
            if (this.arrowAdd != null) {
                this.arrowAdd.field_146124_l = newType != ValueTypes.CATEGORY_ANY;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    protected static class MasterSubGuiRenderPattern
    extends RenderPattern<ValueTypeListLPElement, GuiLogicProgrammerBase, ContainerLogicProgrammerBase>
    implements IRenderPatternValueTypeTooltip {
        private final int baseX;
        private final int baseY;
        private final int maxWidth;
        private final int maxHeight;
        private final GuiLogicProgrammerBase gui;
        private final ContainerLogicProgrammerBase container;
        protected ListElementSubGui elementSubGui = null;
        protected int lastGuiLeft;
        protected int lastGuiTop;
        private boolean renderTooltip = true;

        public MasterSubGuiRenderPattern(ValueTypeListLPElement element, int baseX, int baseY, int maxWidth, int maxHeight, GuiLogicProgrammerBase gui, ContainerLogicProgrammerBase container) {
            super(element, baseX, baseY, maxWidth, maxHeight, gui, container);
            this.subGuiHolder.addSubGui(new SelectionSubGui(element, baseX, baseY, maxWidth, maxHeight, gui, container));
            this.baseX = baseX;
            this.baseY = baseY;
            this.maxWidth = maxWidth;
            this.maxHeight = maxHeight;
            this.gui = gui;
            this.container = container;
        }

        public void setActiveElement(int index) {
            if (this.elementSubGui != null) {
                this.subGuiHolder.removeSubGui(this.elementSubGui);
            }
            if (index >= 0) {
                this.elementSubGui = new ListElementSubGui((ValueTypeListLPElement)this.element, this.baseX, this.baseY + this.getHeight() / 4, this.maxWidth, this.maxHeight, this.gui, this.container);
                this.subGuiHolder.addSubGui(this.elementSubGui);
                this.elementSubGui.initGui(this.lastGuiLeft, this.lastGuiTop);
            }
        }

        @Override
        public void initGui(int guiLeft, int guiTop) {
            super.initGui(guiLeft, guiTop);
            this.lastGuiLeft = guiLeft;
            this.lastGuiTop = guiTop;
        }

        @Override
        public void drawGuiContainerForegroundLayer(int guiLeft, int guiTop, TextureManager textureManager, FontRenderer fontRenderer, int mouseX, int mouseY) {
            super.drawGuiContainerForegroundLayer(guiLeft, guiTop, textureManager, fontRenderer, mouseX, mouseY);
            this.drawTooltipForeground(this.gui, this.container, guiLeft, guiTop, mouseX, mouseY, ((ValueTypeListLPElement)this.element).getValueType());
        }

        @Override
        public boolean isRenderTooltip() {
            return this.renderTooltip;
        }

        @Override
        public void setRenderTooltip(boolean renderTooltip) {
            this.renderTooltip = renderTooltip;
        }
    }
}

