/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.item;

import java.beans.ConstructorProperties;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.cyclopscore.init.ModBase;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.api.item.IVariableFacade;
import org.cyclops.integrateddynamics.core.persist.world.LabelsWorldStorage;

public abstract class VariableFacadeBase
implements IVariableFacade {
    private final int id;

    public VariableFacadeBase(boolean generateId) {
        this.id = generateId ? VariableFacadeBase.generateId() : -1;
    }

    public static int generateId() {
        return IntegratedDynamics.globalCounters.getNext("variable");
    }

    @Override
    public String getLabel() {
        return LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(this.getId());
    }

    protected String getReferenceDisplay(int variableId) {
        String label = LabelsWorldStorage.getInstance((ModBase)IntegratedDynamics._instance).getLabel(variableId);
        if (label == null) {
            return String.valueOf(variableId);
        }
        return String.format("%s:%s", label, variableId);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> list, World world) {
        list.add(L10NHelpers.localize((String)"item.items.integrateddynamics.variable.id", (Object[])new Object[]{this.getId() == -1 ? "..." : Integer.valueOf(this.getId())}));
    }

    @ConstructorProperties(value={"id"})
    public VariableFacadeBase(int id) {
        this.id = id;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VariableFacadeBase)) {
            return false;
        }
        VariableFacadeBase other = (VariableFacadeBase)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getId() == other.getId();
    }

    protected boolean canEqual(Object other) {
        return other instanceof VariableFacadeBase;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        return result;
    }

    public String toString() {
        return "VariableFacadeBase(id=" + this.getId() + ")";
    }
}

