/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.core.evaluate.build;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.cyclops.cyclopscore.helper.L10NHelpers;
import org.cyclops.integrateddynamics.api.evaluate.operator.IOperator;
import org.cyclops.integrateddynamics.api.evaluate.variable.IValueType;
import org.cyclops.integrateddynamics.api.evaluate.variable.IVariable;
import org.cyclops.integrateddynamics.api.logicprogrammer.IConfigRenderPattern;
import org.cyclops.integrateddynamics.core.evaluate.IOperatorValuePropagator;
import org.cyclops.integrateddynamics.core.evaluate.operator.IterativeFunction;
import org.cyclops.integrateddynamics.core.evaluate.operator.OperatorBase;
import org.cyclops.integrateddynamics.core.helper.Helpers;

public class OperatorBuilder<O> {
    private final IValueType outputType;
    private final String symbol;
    private final String operatorName;
    private final IValueType[] inputTypes;
    private final OperatorBase.IFunction function;
    private final IConfigRenderPattern renderPattern;
    private final String modId;
    private final List<String> kinds;
    private final IConditionalOutputTypeDeriver conditionalOutputTypeDeriver;
    private final ITypeValidator typeValidator;
    private final List<IOperatorValuePropagator> valuePropagators;

    protected OperatorBuilder(String symbol, String operatorName, IValueType[] inputTypes, IValueType outputType, OperatorBase.IFunction function, IConfigRenderPattern renderPattern, String modId, List<String> kinds, IConditionalOutputTypeDeriver conditionalOutputTypeDeriver, ITypeValidator typeValidator, List<IOperatorValuePropagator> valuePropagators) {
        this.symbol = symbol;
        this.operatorName = operatorName;
        this.inputTypes = inputTypes;
        this.outputType = outputType;
        this.function = function;
        this.renderPattern = renderPattern;
        this.modId = modId;
        this.kinds = kinds;
        this.conditionalOutputTypeDeriver = conditionalOutputTypeDeriver;
        this.typeValidator = typeValidator;
        this.valuePropagators = valuePropagators;
    }

    public OperatorBuilder<O> output(IValueType outputType) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> symbol(String symbol) {
        return new OperatorBuilder<O>(symbol, this.operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> operatorName(String operatorName) {
        return new OperatorBuilder<O>(this.symbol, operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> symbolOperator(String symbolOperator) {
        return new OperatorBuilder<O>(symbolOperator, symbolOperator, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> inputTypes(IValueType ... inputTypes) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> inputTypes(int length, IValueType defaultType) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, OperatorBase.constructInputVariables(length, defaultType), this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> inputType(IValueType inputType) {
        return this.inputTypes(1, inputType);
    }

    public OperatorBuilder<O> function(OperatorBase.IFunction function) {
        if (this.valuePropagators != null) {
            throw new IllegalStateException("Can not add a function when value propagators are present.");
        }
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> renderPattern(IConfigRenderPattern renderPattern) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, this.function, renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> modId(String modId) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> appendKind(String kind) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, Helpers.joinList(this.kinds, kind), this.conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> conditionalOutputTypeDeriver(IConditionalOutputTypeDeriver conditionalOutputTypeDeriver) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, conditionalOutputTypeDeriver, this.typeValidator, this.valuePropagators);
    }

    public OperatorBuilder<O> typeValidator(ITypeValidator typeValidator) {
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, typeValidator, this.valuePropagators);
    }

    public <O2> OperatorBuilder<O2> handle(IOperatorValuePropagator<O, O2> valuePropagator) {
        if (this.function != null) {
            throw new IllegalStateException("Can not add a function when value propagators are present.");
        }
        return new OperatorBuilder<O>(this.symbol, this.operatorName, this.inputTypes, this.outputType, this.function, this.renderPattern, this.modId, this.kinds, this.conditionalOutputTypeDeriver, this.typeValidator, Helpers.joinList(this.valuePropagators, valuePropagator));
    }

    public IOperator build() {
        return new Built(this);
    }

    public static OperatorBuilder<OperatorBase.SafeVariablesGetter> forType(IValueType<?> outputType) {
        return new OperatorBuilder<OperatorBase.SafeVariablesGetter>(null, null, null, outputType, null, null, "integrateddynamics", Collections.emptyList(), null, null, null);
    }

    public static interface ITypeValidator {
        public L10NHelpers.UnlocalizedString validateTypes(OperatorBase var1, IValueType[] var2);
    }

    public static interface IConditionalOutputTypeDeriver {
        public IValueType getConditionalOutputType(OperatorBase var1, IVariable[] var2);
    }

    private static class Built
    extends OperatorBase {
        private final String modId;
        private final String unlocalizedType;
        private final IConditionalOutputTypeDeriver conditionalOutputTypeDeriver;
        private final ITypeValidator typeValidator;

        protected Built(OperatorBuilder operatorBuilder) {
            super(Objects.requireNonNull(operatorBuilder.symbol), Objects.requireNonNull(operatorBuilder.operatorName), Objects.requireNonNull(operatorBuilder.inputTypes), Objects.requireNonNull(operatorBuilder.outputType), Objects.requireNonNull(Built.deriveFunction(operatorBuilder)), Objects.requireNonNull(operatorBuilder.renderPattern));
            this.modId = Objects.requireNonNull(operatorBuilder.modId);
            this.unlocalizedType = Built.deriveUnlocalizedType(operatorBuilder);
            this.conditionalOutputTypeDeriver = operatorBuilder.conditionalOutputTypeDeriver;
            this.typeValidator = operatorBuilder.typeValidator;
        }

        protected static OperatorBase.IFunction deriveFunction(OperatorBuilder operatorBuilder) {
            if (operatorBuilder.valuePropagators != null) {
                return new IterativeFunction(operatorBuilder.valuePropagators);
            }
            return Objects.requireNonNull(operatorBuilder.function);
        }

        protected static String deriveUnlocalizedType(OperatorBuilder<?> operatorBuilder) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            for (String kind : ((OperatorBuilder)operatorBuilder).kinds) {
                if (!first) {
                    sb.append(".");
                }
                first = false;
                sb.append(kind);
            }
            return sb.toString();
        }

        @Override
        protected String getModId() {
            return this.modId;
        }

        @Override
        protected String getUnlocalizedType() {
            return this.unlocalizedType;
        }

        @Override
        public IValueType getConditionalOutputType(IVariable[] input) {
            return this.conditionalOutputTypeDeriver != null ? this.conditionalOutputTypeDeriver.getConditionalOutputType(this, input) : super.getConditionalOutputType(input);
        }

        @Override
        public L10NHelpers.UnlocalizedString validateTypes(IValueType[] input) {
            return this.typeValidator != null ? this.typeValidator.validateTypes(this, input) : super.validateTypes(input);
        }
    }
}

