/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.capability.energystorage;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.cyclops.cyclopscore.helper.ItemStackHelpers;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryBase;
import org.cyclops.integrateddynamics.block.BlockEnergyBatteryConfig;
import org.cyclops.integrateddynamics.block.IEnergyContainerBlock;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageCapacity;
import org.cyclops.integrateddynamics.capability.energystorage.IEnergyStorageMutable;
import org.cyclops.integrateddynamics.core.item.ItemBlockEnergyContainer;

public class EnergyStorageItemBlockEnergyContainer
implements IEnergyStorageCapacity,
IEnergyStorageMutable {
    private final ItemBlockEnergyContainer itemBlockEnergyContainer;
    private final ItemStack itemStack;
    private final int rate;

    public EnergyStorageItemBlockEnergyContainer(ItemBlockEnergyContainer itemBlockEnergyContainer, ItemStack itemStack, int rate) {
        this.itemBlockEnergyContainer = itemBlockEnergyContainer;
        this.itemStack = itemStack;
        this.rate = rate;
        if (!this.itemStack.func_77942_o()) {
            this.setEnergy(itemStack, 0);
        }
    }

    public EnergyStorageItemBlockEnergyContainer(ItemBlockEnergyContainer itemBlockEnergyContainer, ItemStack itemStack) {
        this(itemBlockEnergyContainer, itemStack, Integer.MAX_VALUE);
    }

    public int getRate() {
        return this.rate;
    }

    public boolean isCreative() {
        IEnergyContainerBlock block = this.itemBlockEnergyContainer.get();
        return block instanceof BlockEnergyBatteryBase && ((BlockEnergyBatteryBase)block).isCreative();
    }

    public int getEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)this.itemStack);
        return tag.func_74762_e(this.itemBlockEnergyContainer.get().getEneryContainerNBTName());
    }

    public int getMaxEnergyStored() {
        if (this.isCreative()) {
            return Integer.MAX_VALUE;
        }
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)this.itemStack);
        if (!tag.func_74764_b(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName())) {
            return BlockEnergyBatteryConfig.capacity;
        }
        return tag.func_74762_e(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName());
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }

    public int receiveEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return 0;
        }
        energy = Math.min(energy, this.getRate());
        int stored = this.getEnergyStored();
        int energyReceived = Math.min(this.getMaxEnergyStored() - stored, energy);
        if (!simulate) {
            this.setEnergy(this.itemStack, stored + energyReceived);
        }
        return energyReceived;
    }

    public int extractEnergy(int energy, boolean simulate) {
        if (this.isCreative()) {
            return energy;
        }
        energy = Math.min(energy, this.getRate());
        int stored = this.getEnergyStored();
        int newEnergy = Math.max(stored - energy, 0);
        if (!simulate) {
            this.setEnergy(this.itemStack, newEnergy);
        }
        return stored - newEnergy;
    }

    public void setEnergy(ItemStack itemStack, int energy) {
        if (this.isCreative()) {
            return;
        }
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)itemStack);
        tag.func_74768_a(this.itemBlockEnergyContainer.get().getEneryContainerNBTName(), energy);
    }

    @Override
    public void setCapacity(int capacity) {
        NBTTagCompound tag = ItemStackHelpers.getSafeTagCompound((ItemStack)this.itemStack);
        if (capacity == BlockEnergyBatteryConfig.capacity) {
            tag.func_82580_o(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName());
        } else {
            tag.func_74768_a(this.itemBlockEnergyContainer.get().getEneryContainerCapacityNBTName(), capacity);
        }
    }

    @Override
    public void setEnergy(int energy) {
        this.setEnergy(this.itemStack, energy);
    }
}

