/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integrateddynamics.block;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.cyclops.cyclopscore.block.property.BlockProperty;
import org.cyclops.cyclopscore.config.configurable.ConfigurableBlockContainer;
import org.cyclops.cyclopscore.config.extendedconfig.BlockConfig;
import org.cyclops.cyclopscore.config.extendedconfig.ExtendedConfig;
import org.cyclops.cyclopscore.helper.BlockHelpers;
import org.cyclops.cyclopscore.helper.TileHelpers;
import org.cyclops.cyclopscore.recipe.custom.api.IMachine;
import org.cyclops.cyclopscore.recipe.custom.api.IRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.api.ISuperRecipeRegistry;
import org.cyclops.cyclopscore.recipe.custom.component.DummyPropertiesComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientRecipeComponent;
import org.cyclops.cyclopscore.recipe.custom.component.IngredientsAndFluidStackRecipeComponent;
import org.cyclops.integrateddynamics.IntegratedDynamics;
import org.cyclops.integrateddynamics.tileentity.TileSqueezer;

public class BlockSqueezer
extends ConfigurableBlockContainer
implements IMachine<BlockSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> {
    @BlockProperty
    public static final PropertyEnum<EnumAxis> AXIS = PropertyDirection.func_177709_a((String)"axis", EnumAxis.class);
    @BlockProperty
    public static final PropertyInteger HEIGHT = PropertyInteger.func_177719_a((String)"height", (int)1, (int)7);
    private static BlockSqueezer _instance = null;

    public static BlockSqueezer getInstance() {
        return _instance;
    }

    public BlockSqueezer(ExtendedConfig<BlockConfig> eConfig) {
        super(eConfig, Material.field_151573_f, TileSqueezer.class);
    }

    public boolean func_180639_a(World world, BlockPos blockPos, IBlockState blockState, EntityPlayer player, EnumHand hand, EnumFacing side, float motionX, float motionY, float motionZ) {
        TileSqueezer tile;
        if (world.field_72995_K) {
            return true;
        }
        if ((Integer)world.func_180495_p(blockPos).func_177229_b((IProperty)HEIGHT) == 1 && (tile = (TileSqueezer)((Object)TileHelpers.getSafeTile((IBlockAccess)world, (BlockPos)blockPos, TileSqueezer.class))) != null) {
            ItemStack itemStack = player.field_71071_by.func_70448_g();
            ItemStack tileStack = tile.func_70301_a(0);
            if (itemStack.func_190926_b() && !tileStack.func_190926_b()) {
                player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, tileStack);
                tile.func_70299_a(0, ItemStack.field_190927_a);
                tile.sendUpdate();
                return true;
            }
            if (player.field_71071_by.func_70441_a(tileStack)) {
                tile.func_70299_a(0, ItemStack.field_190927_a);
                tile.sendUpdate();
                return true;
            }
            if (!itemStack.func_190926_b() && tile.func_70301_a(0).func_190926_b()) {
                tile.func_70299_a(0, itemStack.func_77979_a(1));
                if (itemStack.func_190916_E() <= 0) {
                    player.field_71071_by.func_70299_a(player.field_71071_by.field_70461_c, ItemStack.field_190927_a);
                }
                tile.sendUpdate();
                return true;
            }
        }
        return false;
    }

    public void func_176216_a(World worldIn, Entity entityIn) {
        double motionY = entityIn.field_70181_x;
        super.func_176216_a(worldIn, entityIn);
        if (!worldIn.field_72995_K && motionY <= -0.37 && entityIn instanceof EntityLivingBase) {
            int i = MathHelper.func_76128_c((double)entityIn.field_70165_t);
            int j = MathHelper.func_76128_c((double)(entityIn.field_70163_u - 0.2));
            int k = MathHelper.func_76128_c((double)entityIn.field_70161_v);
            BlockPos blockPos = new BlockPos(i, j, k);
            IBlockState blockState = worldIn.func_180495_p(blockPos);
            int steps = 1 + MathHelper.func_76128_c((double)((-motionY - 0.37) * 5.0));
            if (entityIn.field_70163_u - (double)blockPos.func_177956_o() - (double)this.getRelativeTopPositionTop((IBlockAccess)worldIn, blockPos, blockState) <= (double)0.1f && blockState.func_177230_c() == this) {
                int newHeight = Math.min(7, (Integer)blockState.func_177229_b((IProperty)HEIGHT) + steps);
                worldIn.func_175656_a(blockPos, blockState.func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(newHeight)));
                TileSqueezer tile = (TileSqueezer)((Object)TileHelpers.getSafeTile((IBlockAccess)worldIn, (BlockPos)blockPos, TileSqueezer.class));
                tile.setItemHeight(Math.max(newHeight, tile.getItemHeight()));
            }
        }
    }

    public void func_189540_a(IBlockState state, World worldIn, BlockPos pos, Block neighborBlock, BlockPos fromPos) {
        super.func_189540_a(state, worldIn, pos, neighborBlock, fromPos);
        if (!worldIn.field_72995_K) {
            for (EnumFacing enumfacing : EnumFacing.values()) {
                if (!worldIn.func_175709_b(pos.func_177972_a(enumfacing), enumfacing)) continue;
                worldIn.func_175656_a(pos, state.func_177226_a((IProperty)HEIGHT, (Comparable)Integer.valueOf(1)));
                for (Entity entity : worldIn.func_72872_a(Entity.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)))) {
                    entity.field_70181_x += 0.25;
                    entity.field_70163_u += 0.5;
                }
                return;
            }
        }
    }

    public IBlockState getStateForPlacement(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing.Axis axis = placer.func_174811_aO().func_176740_k();
        return super.getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, meta, placer, hand).func_177226_a(AXIS, (Comparable)((Object)EnumAxis.fromFacingAxis(axis)));
    }

    public float getRelativeTopPositionTop(IBlockAccess world, BlockPos blockPos, IBlockState blockState) {
        return (float)(9 - (Integer)blockState.func_177229_b((IProperty)HEIGHT)) * 0.125f;
    }

    public void func_185477_a(IBlockState blockState, World world, BlockPos blockPos, AxisAlignedBB area, List<AxisAlignedBB> collisionBoxes, Entity entity, boolean useProvidedState) {
        if (!useProvidedState) {
            blockState = blockState.func_185899_b((IBlockAccess)world, blockPos);
        }
        BlockHelpers.addCollisionBoxToList((BlockPos)blockPos, (AxisAlignedBB)area, collisionBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0));
        float f = 0.125f;
        BlockHelpers.addCollisionBoxToList((BlockPos)blockPos, (AxisAlignedBB)area, collisionBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 0.0, (double)f, 1.0, (double)f));
        BlockHelpers.addCollisionBoxToList((BlockPos)blockPos, (AxisAlignedBB)area, collisionBoxes, (AxisAlignedBB)new AxisAlignedBB(1.0, 0.0, 0.0, (double)(1.0f - f), 1.0, (double)f));
        BlockHelpers.addCollisionBoxToList((BlockPos)blockPos, (AxisAlignedBB)area, collisionBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, 0.0, 1.0, (double)f, 1.0, (double)(1.0f - f)));
        BlockHelpers.addCollisionBoxToList((BlockPos)blockPos, (AxisAlignedBB)area, collisionBoxes, (AxisAlignedBB)new AxisAlignedBB(1.0, 0.0, 1.0, (double)(1.0f - f), 1.0, (double)(1.0f - f)));
        float offset = (float)(8 - (Integer)blockState.func_177229_b((IProperty)HEIGHT)) * 0.125f;
        BlockHelpers.addCollisionBoxToList((BlockPos)blockPos, (AxisAlignedBB)area, collisionBoxes, (AxisAlignedBB)new AxisAlignedBB(0.0, (double)(offset - 0.125f), 0.0, 1.0, (double)offset, 1.0));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, (double)this.getRelativeTopPositionTop(world, pos, state), 1.0);
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public boolean isNormalCube(IBlockState blockState, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean func_149686_d(IBlockState blockState) {
        return false;
    }

    public boolean func_149740_M(IBlockState blockState) {
        return true;
    }

    public int func_180641_l(IBlockState blockState, World world, BlockPos blockPos) {
        return (int)(((double)((Integer)blockState.func_177229_b((IProperty)HEIGHT)).intValue() - 1.0) / 6.0 * 15.0);
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public IRecipeRegistry<BlockSqueezer, IngredientRecipeComponent, IngredientsAndFluidStackRecipeComponent, DummyPropertiesComponent> getRecipeRegistry() {
        return ((ISuperRecipeRegistry)IntegratedDynamics._instance.getRegistryManager().getRegistry(ISuperRecipeRegistry.class)).getRecipeRegistry((IMachine)this);
    }

    public static enum EnumAxis implements IStringSerializable
    {
        X("x", new EnumFacing[]{EnumFacing.EAST, EnumFacing.WEST}),
        Z("z", new EnumFacing[]{EnumFacing.NORTH, EnumFacing.SOUTH});

        private final String name;
        private final EnumFacing[] sides;

        private EnumAxis(String name, EnumFacing[] sides) {
            this.name = name;
            this.sides = sides;
        }

        public String toString() {
            return this.name;
        }

        public static EnumAxis fromFacingAxis(EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    return Z;
                }
                case Z: {
                    return X;
                }
            }
            return X;
        }

        public String func_176610_l() {
            return this.name;
        }

        public EnumFacing[] getSides() {
            return this.sides;
        }
    }
}

