#loader contenttweaker
# Author: Atricos

import mods.contenttweaker.VanillaFactory;
import mods.contenttweaker.Item;
import mods.contenttweaker.IItemRightClick;
import mods.contenttweaker.Commands;
import mods.contenttweaker.ItemFood;
import mods.contenttweaker.IItemFoodEaten;
import mods.contenttweaker.MutableItemStack;
import mods.contenttweaker.Hand;
import mods.contenttweaker.World;
import mods.contenttweaker.IItemUpdate;
import mods.contenttweaker.Player;
import crafttweaker.player.IPlayer;
import crafttweaker.util.IRandom;

print("STARTING ContentTweakerItems.zs");

var wooden_pickaxe_head = VanillaFactory.createItem("wooden_pickaxe_head");
wooden_pickaxe_head.register();
var wooden_axe_head = VanillaFactory.createItem("wooden_axe_head");
wooden_axe_head.register();
var stone_pickaxe_head = VanillaFactory.createItem("stone_pickaxe_head");
stone_pickaxe_head.register();
var stone_axe_head = VanillaFactory.createItem("stone_axe_head");
stone_axe_head.register();
var tool_rod = VanillaFactory.createItem("tool_rod");
tool_rod.register();
var crafting_base = VanillaFactory.createItem("crafting_base");
crafting_base.register();
var burning_essence = VanillaFactory.createItem("burning_essence");
burning_essence.register();
var rough_hammer = VanillaFactory.createItem("rough_hammer");
rough_hammer.maxStackSize = 1;
rough_hammer.maxDamage = 3;
rough_hammer.register();
var rough_iron_mesh = VanillaFactory.createItem("rough_iron_mesh");
rough_iron_mesh.register();
var iron_hammer = VanillaFactory.createItem("iron_hammer");
iron_hammer.maxStackSize = 1;
iron_hammer.maxDamage = 63;
iron_hammer.register();
var bag_of_truth_locked = VanillaFactory.createItem("bag_of_truth_locked");
bag_of_truth_locked.maxStackSize = 1;
bag_of_truth_locked.rarity = "EPIC";
bag_of_truth_locked.register();
var key_to_infinity = VanillaFactory.createItem("key_to_infinity");
key_to_infinity.maxStackSize = 1;
key_to_infinity.rarity = "EPIC";
key_to_infinity.glowing = true;
key_to_infinity.register();
var arlemite_dust = VanillaFactory.createItem("arlemite_dust");
arlemite_dust.register();
var rupee_dust = VanillaFactory.createItem("rupee_dust");
rupee_dust.register();
var realmite_dust = VanillaFactory.createItem("realmite_dust");
realmite_dust.register();
var netherite_dust = VanillaFactory.createItem("netherite_dust");
netherite_dust.register();
var perfectium_essence = VanillaFactory.createItem("perfectium_essence");
perfectium_essence.register();
var perfectium_ball = VanillaFactory.createItem("perfectium_ball");
perfectium_ball.register();
var corrupted_draconium_ingot = VanillaFactory.createItem("corrupted_draconium_ingot");
corrupted_draconium_ingot.register();
var arkas_wittyness = VanillaFactory.createItem("arkas_wittyness");
arkas_wittyness.register();
var guudes_sanity = VanillaFactory.createItem("guudes_sanity");
guudes_sanity.register();
var nebris_justice = VanillaFactory.createItem("nebris_justice");
nebris_justice.register();
var pakratts_endurance = VanillaFactory.createItem("pakratts_endurance");
pakratts_endurance.register();
var the_perfect_squad = VanillaFactory.createItem("the_perfect_squad");
the_perfect_squad.register();
var vibrant_slate = VanillaFactory.createItem("vibrant_slate");
vibrant_slate.register();
var rainbow_slate = VanillaFactory.createItem("rainbow_slate");
rainbow_slate.register();
var perfect_slate = VanillaFactory.createItem("perfect_slate");
perfect_slate.register();
var twilight_key = VanillaFactory.createItem("twilight_key");
twilight_key.register();
var corrupted_core = VanillaFactory.createItem("corrupted_core");
corrupted_core.register();
var corrupted_dragon_token = VanillaFactory.createItem("corrupted_dragon_token");
corrupted_dragon_token.register();
var awakened_dragon_token = VanillaFactory.createItem("awakened_dragon_token");
awakened_dragon_token.register();
var dragon_token = VanillaFactory.createItem("dragon_token");
dragon_token.register();
var treated_leather = VanillaFactory.createItem("treated_leather");
treated_leather.register();
var industrial_leather = VanillaFactory.createItem("industrial_leather");
industrial_leather.register();
var blood_infused_leather = VanillaFactory.createItem("blood_infused_leather");
blood_infused_leather.register();
var magical_leather = VanillaFactory.createItem("magical_leather");
magical_leather.register();
var star_leather = VanillaFactory.createItem("star_leather");
star_leather.register();
var imp_leather_scrap = VanillaFactory.createItem("imp_leather_scrap");
imp_leather_scrap.register();
var buffao_hide_scrap = VanillaFactory.createItem("buffao_hide_scrap");
buffao_hide_scrap.register();
var root_of_the_fallen = VanillaFactory.createItem("root_of_the_fallen");
root_of_the_fallen.register();
var artificial_scarab_wings = VanillaFactory.createItem("artificial_scarab_wings");
artificial_scarab_wings.register();
var flawless_scarab_wings = VanillaFactory.createItem("flawless_scarab_wings");
flawless_scarab_wings.register();
var artificial_scarab_body = VanillaFactory.createItem("artificial_scarab_body");
artificial_scarab_body.register();
var flawless_scarab_body = VanillaFactory.createItem("flawless_scarab_body");
flawless_scarab_body.register();
var twilight_rock = VanillaFactory.createItem("twilight_rock");
twilight_rock.register();
var industrial_slime_ball = VanillaFactory.createItem("industrial_slime_ball");
industrial_slime_ball.register();
var energized_osmium_ingot = VanillaFactory.createItem("energized_osmium_ingot");
energized_osmium_ingot.register();
var energized_certus_quartz_crystal = VanillaFactory.createItem("energized_certus_quartz_crystal");
energized_certus_quartz_crystal.register();
var icon_improved_blast_furnace = VanillaFactory.createItem("icon_improved_blast_furnace");
icon_improved_blast_furnace.register();
var printed_operation_circuit = VanillaFactory.createItem("printed_operation_circuit");
printed_operation_circuit.register();
var operation_processor = VanillaFactory.createItem("operation_processor");
operation_processor.register();
var printed_estimation_circuit = VanillaFactory.createItem("printed_estimation_circuit");
printed_estimation_circuit.register();
var estimation_processor = VanillaFactory.createItem("estimation_processor");
estimation_processor.register();
var printed_methodolgy_circuit = VanillaFactory.createItem("printed_methodolgy_circuit");
printed_methodolgy_circuit.register();
var methodology_processor = VanillaFactory.createItem("methodology_processor");
methodology_processor.register();
var printed_clearance_circuit = VanillaFactory.createItem("printed_clearance_circuit");
printed_clearance_circuit.register();
var clearance_processor = VanillaFactory.createItem("clearance_processor");
clearance_processor.register();
var printed_scheduling_circuit = VanillaFactory.createItem("printed_scheduling_circuit");
printed_scheduling_circuit.register();
var scheduling_processor = VanillaFactory.createItem("scheduling_processor");
scheduling_processor.register();
var inscriber_operation_press = VanillaFactory.createItem("inscriber_operation_press");
inscriber_operation_press.register();
var inscriber_estimation_press = VanillaFactory.createItem("inscriber_estimation_press");
inscriber_estimation_press.register();
var inscriber_methodology_press = VanillaFactory.createItem("inscriber_methodology_press");
inscriber_methodology_press.register();
var inscriber_clearance_press = VanillaFactory.createItem("inscriber_clearance_press");
inscriber_clearance_press.register();
var inscriber_scheduling_press = VanillaFactory.createItem("inscriber_scheduling_press");
inscriber_scheduling_press.register();
var enriched_gum = VanillaFactory.createItem("enriched_gum");
enriched_gum.register();
var eye_of_gaea = VanillaFactory.createItem("eye_of_gaea");
eye_of_gaea.maxStackSize = 1;
eye_of_gaea.rarity = "RARE";
eye_of_gaea.register();
var eye_of_gaea_awakened = VanillaFactory.createItem("eye_of_gaea_awakened");
eye_of_gaea_awakened.maxStackSize = 1;
eye_of_gaea_awakened.rarity = "RARE";
eye_of_gaea_awakened.glowing = true;
eye_of_gaea_awakened.register();
var relic_ingot = VanillaFactory.createItem("relic_ingot");
relic_ingot.register();
var relic_dust = VanillaFactory.createItem("relic_dust");
relic_dust.register();
var atum_poppet = VanillaFactory.createItem("atum_poppet");
atum_poppet.register();
var atum_equipment = VanillaFactory.createItem("atum_equipment");
atum_equipment.maxStackSize = 1;
atum_equipment.rarity = "RARE";
atum_equipment.glowing = true;
atum_equipment.register();
var atum_warrior = VanillaFactory.createItem("atum_warrior");
atum_warrior.maxStackSize = 1;
atum_warrior.rarity = "RARE";
atum_warrior.glowing = true;
atum_warrior.register();
var implanted_emerald = VanillaFactory.createItem("implanted_emerald");
implanted_emerald.register();
var mixed_erebusian_rocks = VanillaFactory.createItem("mixed_erebusian_rocks");
mixed_erebusian_rocks.register();
var power_egg = VanillaFactory.createItem("power_egg");
power_egg.register();
var crown_of_skies = VanillaFactory.createItem("crown_of_skies");
crown_of_skies.maxStackSize = 1;
crown_of_skies.rarity = "EPIC";
crown_of_skies.glowing = true;
crown_of_skies.register();
var bronze_aether_coin = VanillaFactory.createItem("bronze_aether_coin");
bronze_aether_coin.maxStackSize = 1;
bronze_aether_coin.rarity = "EPIC";
bronze_aether_coin.glowing = true;
bronze_aether_coin.register();
var silver_aether_coin = VanillaFactory.createItem("silver_aether_coin");
silver_aether_coin.maxStackSize = 1;
silver_aether_coin.rarity = "EPIC";
silver_aether_coin.glowing = true;
silver_aether_coin.register();
var golden_aether_coin = VanillaFactory.createItem("golden_aether_coin");
golden_aether_coin.maxStackSize = 1;
golden_aether_coin.rarity = "EPIC";
golden_aether_coin.glowing = true;
golden_aether_coin.register();
var aether_power_core = VanillaFactory.createItem("aether_power_core");
aether_power_core.maxStackSize = 1;
aether_power_core.maxDamage = 64;
aether_power_core.rarity = "EPIC";
aether_power_core.glowing = true;
aether_power_core.register();
var golder_molder_folder = VanillaFactory.createItem("golder_molder_folder");
golder_molder_folder.maxStackSize = 1;
golder_molder_folder.maxDamage = 16;
golder_molder_folder.register();
var enchanted_golden_berry = VanillaFactory.createItem("enchanted_golden_berry");
enchanted_golden_berry.rarity = "RARE";
enchanted_golden_berry.glowing = true;
enchanted_golden_berry.register();
var enchanted_golden_berry_stem = VanillaFactory.createItem("enchanted_golden_berry_stem");
enchanted_golden_berry_stem.rarity = "RARE";
enchanted_golden_berry_stem.glowing = true;
enchanted_golden_berry_stem.register();
var enchanted_golden_berry_necklace = VanillaFactory.createItem("enchanted_golden_berry_necklace");
enchanted_golden_berry_necklace.rarity = "RARE";
enchanted_golden_berry_necklace.glowing = true;
enchanted_golden_berry_necklace.register();
var aechomedirus = VanillaFactory.createItem("aechomedirus");
aechomedirus.register();
var resonating_orb = VanillaFactory.createItem("resonating_orb");
resonating_orb.maxStackSize = 1;
resonating_orb.maxDamage = 256;
resonating_orb.rarity = "EPIC";
resonating_orb.glowing = true;
resonating_orb.register();
var santa_armor_set = VanillaFactory.createItem("santa_armor_set");
santa_armor_set.register();
var festive_ball = VanillaFactory.createItem("festive_ball");
festive_ball.register();
var festive_powder = VanillaFactory.createItem("festive_powder");
festive_powder.register();
var gp_powder = VanillaFactory.createItem("gp_powder");
gp_powder.rarity = "RARE";
gp_powder.register();
var osglolapis = VanillaFactory.createItem("osglolapis");
osglolapis.register();
var demonlord_ingot = VanillaFactory.createItem("demonlord_ingot");
demonlord_ingot.register();
var bloodgem_dust = VanillaFactory.createItem("bloodgem_dust");
bloodgem_dust.register();
var mobgrindium_ingot = VanillaFactory.createItem("mobgrindium_ingot");
mobgrindium_ingot.register();
var open_ingot = VanillaFactory.createItem("open_ingot");
open_ingot.register();
var thermal_conductor_rod = VanillaFactory.createItem("thermal_conductor_rod");
thermal_conductor_rod.glowing = true;
thermal_conductor_rod.maxStackSize = 1;
thermal_conductor_rod.maxDamage = 800;
thermal_conductor_rod.register();
var rf_powder = VanillaFactory.createItem("rf_powder");
rf_powder.rarity = "RARE";
rf_powder.register();
var essence_of_infinity = VanillaFactory.createItem("essence_of_infinity");
essence_of_infinity.glowing = true;
essence_of_infinity.rarity = "EPIC";
essence_of_infinity.register();
var essence_of_matter = VanillaFactory.createItem("essence_of_matter");
essence_of_matter.glowing = true;
essence_of_matter.rarity = "EPIC";
essence_of_matter.register();
var essence_of_time = VanillaFactory.createItem("essence_of_time");
essence_of_time.glowing = true;
essence_of_time.rarity = "EPIC";
essence_of_time.register();
var essence_of_repetition = VanillaFactory.createItem("essence_of_repetition");
essence_of_repetition.glowing = true;
essence_of_repetition.rarity = "EPIC";
essence_of_repetition.register();
var essence_of_order = VanillaFactory.createItem("essence_of_order");
essence_of_order.glowing = true;
essence_of_order.rarity = "EPIC";
essence_of_order.register();
var essence_of_destruction = VanillaFactory.createItem("essence_of_destruction");
essence_of_destruction.glowing = true;
essence_of_destruction.rarity = "EPIC";
essence_of_destruction.register();
var coated_clathrate = VanillaFactory.createItem("coated_clathrate");
coated_clathrate.rarity = "RARE";
coated_clathrate.register();
var dark_ingot = VanillaFactory.createItem("dark_ingot");
dark_ingot.register();
var essence_of_continuity = VanillaFactory.createItem("essence_of_continuity");
essence_of_continuity.glowing = true;
essence_of_continuity.rarity = "EPIC";
essence_of_continuity.register();
var energized_dark_ingot = VanillaFactory.createItem("energized_dark_ingot");
energized_dark_ingot.register();
var essence_of_dimensionality = VanillaFactory.createItem("essence_of_dimensionality");
essence_of_dimensionality.glowing = true;
essence_of_dimensionality.rarity = "EPIC";
essence_of_dimensionality.register();
var essence_of_additivity = VanillaFactory.createItem("essence_of_additivity");
essence_of_additivity.glowing = true;
essence_of_additivity.rarity = "EPIC";
essence_of_additivity.register();
var titanium_gear = VanillaFactory.createItem("titanium_gear");
titanium_gear.register();
var titanium_plate = VanillaFactory.createItem("titanium_plate");
titanium_plate.register();
var titanium_nugget = VanillaFactory.createItem("titanium_nugget");
titanium_nugget.register();
var titanium_rod = VanillaFactory.createItem("titanium_rod");
titanium_rod.register();
var silicon_plate = VanillaFactory.createItem("silicon_plate");
silicon_plate.register();
var essence_of_logic = VanillaFactory.createItem("essence_of_logic");
essence_of_logic.glowing = true;
essence_of_logic.rarity = "EPIC";
essence_of_logic.register();
var essence_of_movement = VanillaFactory.createItem("essence_of_movement");
essence_of_movement.glowing = true;
essence_of_movement.rarity = "EPIC";
essence_of_movement.register();
var essence_of_peace = VanillaFactory.createItem("essence_of_peace");
essence_of_peace.glowing = true;
essence_of_peace.rarity = "EPIC";
essence_of_peace.register();
var essence_of_atomic_fusion = VanillaFactory.createItem("essence_of_atomic_fusion");
essence_of_atomic_fusion.glowing = true;
essence_of_atomic_fusion.rarity = "EPIC";
essence_of_atomic_fusion.register();
var essence_of_ways = VanillaFactory.createItem("essence_of_ways");
essence_of_ways.glowing = true;
essence_of_ways.rarity = "EPIC";
essence_of_ways.register();
var essence_of_the_unbroken = VanillaFactory.createItem("essence_of_the_unbroken");
essence_of_the_unbroken.glowing = true;
essence_of_the_unbroken.rarity = "EPIC";
essence_of_the_unbroken.register();
var essence_of_breaking = VanillaFactory.createItem("essence_of_breaking");
essence_of_breaking.glowing = true;
essence_of_breaking.rarity = "EPIC";
essence_of_breaking.register();
var silver_rod = VanillaFactory.createItem("silver_rod");
silver_rod.register();
var dark_dust = VanillaFactory.createItem("dark_dust");
dark_dust.register();
var energized_dark_dust = VanillaFactory.createItem("energized_dark_dust");
energized_dark_dust.register();
var essence_of_the_contrary = VanillaFactory.createItem("essence_of_the_contrary");
essence_of_the_contrary.glowing = true;
essence_of_the_contrary.rarity = "EPIC";
essence_of_the_contrary.register();
var essence_of_inversion = VanillaFactory.createItem("essence_of_inversion");
essence_of_inversion.glowing = true;
essence_of_inversion.rarity = "EPIC";
essence_of_inversion.register();
var essence_of_enlargement = VanillaFactory.createItem("essence_of_enlargement");
essence_of_enlargement.glowing = true;
essence_of_enlargement.rarity = "EPIC";
essence_of_enlargement.register();
var crystalline_brown_slime_ingot = VanillaFactory.createItem("crystalline_brown_slime_ingot");
crystalline_brown_slime_ingot.register();
var glod_crystal = VanillaFactory.createItem("glod_crystal");
glod_crystal.register();
var empowered_glod_crystal = VanillaFactory.createItem("empowered_glod_crystal");
empowered_glod_crystal.register();
var crystal_bundle = VanillaFactory.createItem("crystal_bundle");
crystal_bundle.register();
var empowered_crystal_bundle = VanillaFactory.createItem("empowered_crystal_bundle");
empowered_crystal_bundle.rarity = "RARE";
empowered_crystal_bundle.register();
var cosmic_alloy = VanillaFactory.createItem("cosmic_alloy");
cosmic_alloy.register();
var ingot_of_elevation = VanillaFactory.createItem("ingot_of_elevation");
ingot_of_elevation.onItemUpdate = function(itemStack, world, owner, slot, isSelected) {
    if(world.remote) {
        return;
    }
	if(owner instanceof IPlayer) {
		val player as IPlayer = owner;
		if(isSelected) {
			val randomInt = world.random.nextInt(240) as int;
			if(randomInt == 0) {
				Commands.call("effect @p minecraft:levitation 3 0 true", player, world, false, true);
			}
		}
	}
	return;
};
ingot_of_elevation.register();
var fluxed_electrum_ingot = VanillaFactory.createItem("fluxed_electrum_ingot");
fluxed_electrum_ingot.register();
var flux_crystal = VanillaFactory.createItem("flux_crystal");
flux_crystal.register();
var fluxed_electrum_plate = VanillaFactory.createItem("fluxed_electrum_plate");
fluxed_electrum_plate.register();
var steaming_restonia_crystal = VanillaFactory.createItem("steaming_restonia_crystal");
steaming_restonia_crystal.rarity = "EPIC";
steaming_restonia_crystal.register();
var redstone_star = VanillaFactory.createItem("redstone_star");
redstone_star.glowing = true;
redstone_star.register();
var ayeraco_wing = VanillaFactory.createItem("ayeraco_wing");
ayeraco_wing.register();
var eye_of_the_watcher = VanillaFactory.createItem("eye_of_the_watcher");
eye_of_the_watcher.register();
var ancient_leg = VanillaFactory.createItem("ancient_leg");
ancient_leg.register();
var unholy_token = VanillaFactory.createItem("unholy_token");
unholy_token.register();
var unholy_essence = VanillaFactory.createItem("unholy_essence");
unholy_essence.register();
var eden_door_key = VanillaFactory.createItem("eden_door_key");
eden_door_key.maxStackSize = 1;
eden_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:eden_door", player, world, false, true);
    return "Pass";
};
eden_door_key.register();
var wildwood_door_key = VanillaFactory.createItem("wildwood_door_key");
wildwood_door_key.maxStackSize = 1;
wildwood_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:wildwood_door", player, world, false, true);
    return "Pass";
};
wildwood_door_key.register();
var apalachia_door_key = VanillaFactory.createItem("apalachia_door_key");
apalachia_door_key.maxStackSize = 1;
apalachia_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:apalachia_door", player, world, false, true);
    return "Pass";
};
var apalachia_key_fragment = VanillaFactory.createItem("apalachia_key_fragment");
apalachia_key_fragment.register();
var apalachia_door_key2 = VanillaFactory.createItem("apalachia_door_key2");
apalachia_door_key2.maxStackSize = 1;
apalachia_door_key2.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:apalachia_door2", player, world, false, true);
    return "Pass";
};
apalachia_door_key2.register();
apalachia_door_key.register();
var skythern_door_key = VanillaFactory.createItem("skythern_door_key");
skythern_door_key.maxStackSize = 1;
skythern_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:skythern_door", player, world, false, true);
    return "Pass";
};
skythern_door_key.register();
var skythern_door_key2 = VanillaFactory.createItem("skythern_door_key2");
skythern_door_key2.maxStackSize = 1;
skythern_door_key2.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:skythern_door2", player, world, false, true);
    return "Pass";
};
skythern_door_key2.register();
var skythern_door_key_fragment = VanillaFactory.createItem("skythern_door_key_fragment");
skythern_door_key_fragment.register();
var mortum_door_key = VanillaFactory.createItem("mortum_door_key");
mortum_door_key.maxStackSize = 1;
mortum_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:mortum_door", player, world, false, true);
    return "Pass";
};
mortum_door_key.register();
var asteroids_door_key = VanillaFactory.createItem("asteroids_door_key");
asteroids_door_key.maxStackSize = 1;
asteroids_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:asteroids_door", player, world, false, true);
    return "Pass";
};
asteroids_door_key.register();
var asteroids_key_fragment = VanillaFactory.createItem("asteroids_key_fragment");
asteroids_key_fragment.register();
var venus_door_key = VanillaFactory.createItem("venus_door_key");
venus_door_key.maxStackSize = 1;
venus_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:venus_door", player, world, false, true);
    return "Pass";
};
venus_door_key.register();
var venus_door_key2 = VanillaFactory.createItem("venus_door_key2");
venus_door_key2.maxStackSize = 1;
venus_door_key2.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:venus_door2", player, world, false, true);
    return "Pass";
};
venus_door_key2.register();
var moon_door_key = VanillaFactory.createItem("moon_door_key");
moon_door_key.maxStackSize = 1;
moon_door_key.itemRightClick = function(stack, world, player, hand) {
    Commands.call("execute @p ~ ~ ~ /fill ~-5 ~-5 ~-5 ~5 ~5 ~5 minecraft:air 0 replace contenttweaker:moon_door", player, world, false, true);
    return "Pass";
};
moon_door_key.register();
var moon_key_fragment = VanillaFactory.createItem("moon_key_fragment");
moon_key_fragment.register();
var unwarpification_talisman = VanillaFactory.createItem("unwarpification_talisman");
unwarpification_talisman.maxStackSize = 1;
unwarpification_talisman.rarity = "EPIC";
unwarpification_talisman.itemRightClick = function(stack, world, player, hand) {
    Commands.call("tc warp @p set 0 PERM", player, world, false, true);
    Commands.call("tc warp @p set 0", player, world, false, true);
    Commands.call("tc warp @p set 0 TEMP", player, world, false, true);
    Commands.call('/tellraw @p {"text":"Your warp has been set to 0!","bold":true}', player, world, false, true);
    return "Pass";
};
var feather_of_the_wild_woods = VanillaFactory.createItem("feather_of_the_wild_woods");
feather_of_the_wild_woods.rarity = "RARE";
feather_of_the_wild_woods.register();
var dread_crystal = VanillaFactory.createItem("dread_crystal");
dread_crystal.rarity = "EPIC";
dread_crystal.glowing = true;
dread_crystal.register();
var hardened_blood_droplet = VanillaFactory.createItem("hardened_blood_droplet");
hardened_blood_droplet.register();
var omothol_soul = VanillaFactory.createItem("omothol_soul");
omothol_soul.register();
var simple_catalyst = VanillaFactory.createItem("simple_catalyst");
simple_catalyst.register();
var strengthened_catalyst = VanillaFactory.createItem("strengthened_catalyst");
strengthened_catalyst.register();
var concentrated_catalyst = VanillaFactory.createItem("concentrated_catalyst");
concentrated_catalyst.register();
var aether = VanillaFactory.createItem("aether");
aether.register();
var aquasalus = VanillaFactory.createItem("aquasalus");
aquasalus.register();
var crepitous = VanillaFactory.createItem("crepitous");
crepitous.register();
var crystallos = VanillaFactory.createItem("crystallos");
crystallos.register();
var incendium = VanillaFactory.createItem("incendium");
incendium.register();
var magicales = VanillaFactory.createItem("magicales");
magicales.register();
var offensa = VanillaFactory.createItem("offensa");
offensa.register();
var orbis_terrae = VanillaFactory.createItem("orbis_terrae");
orbis_terrae.register();
var praesidium = VanillaFactory.createItem("praesidium");
praesidium.register();
var potentia = VanillaFactory.createItem("potentia");
potentia.register();
var reductus = VanillaFactory.createItem("reductus");
reductus.register();
var sanctus = VanillaFactory.createItem("sanctus");
sanctus.register();
var tenebrae = VanillaFactory.createItem("tenebrae");
tenebrae.register();
var terrae = VanillaFactory.createItem("terrae");
terrae.register();
var virtus = VanillaFactory.createItem("virtus");
virtus.register();
var empty_core = VanillaFactory.createItem("empty_core");
empty_core.register();
var gusty_core = VanillaFactory.createItem("gusty_core");
gusty_core.register();
var aquatic_core = VanillaFactory.createItem("aquatic_core");
aquatic_core.register();
var defensive_core = VanillaFactory.createItem("defensive_core");
defensive_core.register();
var icy_core = VanillaFactory.createItem("icy_core");
icy_core.register();
var fire_core = VanillaFactory.createItem("fire_core");
fire_core.register();
var magical_core = VanillaFactory.createItem("magical_core");
magical_core.register();
var offensive_core = VanillaFactory.createItem("offensive_core");
offensive_core.register();
var environmental_core = VanillaFactory.createItem("environmental_core");
environmental_core.register();
var potency_core = VanillaFactory.createItem("potency_core");
potency_core.register();
var suppression_core = VanillaFactory.createItem("suppression_core");
suppression_core.register();
var reduction_core = VanillaFactory.createItem("reduction_core");
reduction_core.register();
var holy_core = VanillaFactory.createItem("holy_core");
holy_core.register();
var dark_core = VanillaFactory.createItem("dark_core");
dark_core.register();
var earthen_core = VanillaFactory.createItem("earthen_core");
earthen_core.register();
var power_core = VanillaFactory.createItem("power_core");
power_core.register();
var tempestas = VanillaFactory.createItem("tempestas");
tempestas.register();
var tempest_core = VanillaFactory.createItem("tempest_core");
tempest_core.register();
var coralium_decorated_blood_star = VanillaFactory.createItem("coralium_decorated_blood_star");
coralium_decorated_blood_star.register();
var intensive_catalyst = VanillaFactory.createItem("intensive_catalyst");
intensive_catalyst.register();
var raw_industrial_leather = VanillaFactory.createItem("raw_industrial_leather");
raw_industrial_leather.register();
var frozen_blood_core = VanillaFactory.createItem("frozen_blood_core");
frozen_blood_core.register();
var dirty_reagent = VanillaFactory.createItem("dirty_reagent");
dirty_reagent.register();
var wizards_reagent = VanillaFactory.createItem("wizards_reagent");
wizards_reagent.register();
var neutral_reagent = VanillaFactory.createItem("neutral_reagent");
neutral_reagent.register();
var tempest_reagent = VanillaFactory.createItem("tempest_reagent");
tempest_reagent.register();
var strength_reagent = VanillaFactory.createItem("strength_reagent");
strength_reagent.register();
var damage_reagent = VanillaFactory.createItem("damage_reagent");
damage_reagent.register();
var potent_reagent = VanillaFactory.createItem("potent_reagent");
potent_reagent.register();
var bloodied_dust = VanillaFactory.createItem("bloodied_dust");
bloodied_dust.register();
var cracked_runic_plate = VanillaFactory.createItem("cracked_runic_plate");
cracked_runic_plate.register();
var clean_runic_plate = VanillaFactory.createItem("clean_runic_plate");
clean_runic_plate.register();
var arboreal_essence = VanillaFactory.createItem("arboreal_essence");
arboreal_essence.register();
var petal_of_the_daisy = VanillaFactory.createItem("petal_of_the_daisy");
petal_of_the_daisy.register();
var hydrating_petal = VanillaFactory.createItem("hydrating_petal");
hydrating_petal.register();
var petal_of_the_inner_flame = VanillaFactory.createItem("petal_of_the_inner_flame");
petal_of_the_inner_flame.register();
var hybrid_abyssalium_ingot = VanillaFactory.createItem("hybrid_abyssalium_ingot");
hybrid_abyssalium_ingot.register();
var effulgent_spike_of_apalachia = VanillaFactory.createItem("effulgent_spike_of_apalachia");
effulgent_spike_of_apalachia.glowing = true;
effulgent_spike_of_apalachia.rarity = "EPIC";
effulgent_spike_of_apalachia.register();
var effulgent_apalachian_spike_crown = VanillaFactory.createItem("effulgent_apalachian_spike_crown");
effulgent_apalachian_spike_crown.glowing = true;
effulgent_apalachian_spike_crown.rarity = "EPIC";
effulgent_apalachian_spike_crown.register();
var binding_reagent = VanillaFactory.createItem("binding_reagent");
binding_reagent.register();
var angelic_silicon_crystal_mixture = VanillaFactory.createItem("angelic_silicon_crystal_mixture");
angelic_silicon_crystal_mixture.register();
var crystallized_mana_cluster = VanillaFactory.createItem("crystallized_mana_cluster");
crystallized_mana_cluster.register();
var crystallized_mana = VanillaFactory.createItem("crystallized_mana");
crystallized_mana.register();
var crystallized_mana_shard = VanillaFactory.createItem("crystallized_mana_shard");
crystallized_mana_shard.register();
var crystallized_mana_fragment = VanillaFactory.createItem("crystallized_mana_fragment");
crystallized_mana_fragment.register();
var crystallized_sodium_cluster = VanillaFactory.createItem("crystallized_sodium_cluster");
crystallized_sodium_cluster.register();
var crystallized_sodium = VanillaFactory.createItem("crystallized_sodium");
crystallized_sodium.register();
var crystallized_sodium_shard = VanillaFactory.createItem("crystallized_sodium_shard");
crystallized_sodium_shard.register();
var crystallized_sodium_fragment = VanillaFactory.createItem("crystallized_sodium_fragment");
crystallized_sodium_fragment.register();
var manastar_petal = VanillaFactory.createItem("manastar_petal");
manastar_petal.register();
var thermal_petal = VanillaFactory.createItem("thermal_petal");
thermal_petal.register();
var petal_of_the_arcane_rose = VanillaFactory.createItem("petal_of_the_arcane_rose");
petal_of_the_arcane_rose.register();
var petal_of_the_gourmaryllis = VanillaFactory.createItem("petal_of_the_gourmaryllis");
petal_of_the_gourmaryllis.register();
var petal_of_the_narslimmus = VanillaFactory.createItem("petal_of_the_narslimmus");
petal_of_the_narslimmus.register();
var jaded_petal = VanillaFactory.createItem("jaded_petal");
jaded_petal.register();
var thorny_belle_petal = VanillaFactory.createItem("thorny_belle_petal");
thorny_belle_petal.register();
var thorny_dread_petal = VanillaFactory.createItem("thorny_dread_petal");
thorny_dread_petal.register();
var tigerseye_petal = VanillaFactory.createItem("tigerseye_petal");
tigerseye_petal.register();
var petal_of_the_exoflame = VanillaFactory.createItem("petal_of_the_exoflame");
petal_of_the_exoflame.register();
var agricarnatic_petal = VanillaFactory.createItem("agricarnatic_petal");
agricarnatic_petal.register();
var hopping_petal = VanillaFactory.createItem("hopping_petal");
hopping_petal.register();
var petal_of_the_rannuncarpus = VanillaFactory.createItem("petal_of_the_rannuncarpus");
petal_of_the_rannuncarpus.register();
var tangled_petals = VanillaFactory.createItem("tangled_petals");
tangled_petals.register();
var petal_of_the_jiyuulia = VanillaFactory.createItem("petal_of_the_jiyuulia");
petal_of_the_jiyuulia.register();
var clay_cone_petal = VanillaFactory.createItem("clay_cone_petal");
clay_cone_petal.register();
var daffomill_petal = VanillaFactory.createItem("daffomill_petal");
daffomill_petal.register();
var petal_of_the_solegnolia = VanillaFactory.createItem("petal_of_the_solegnolia");
petal_of_the_solegnolia.register();
var petal_of_the_bergamute = VanillaFactory.createItem("petal_of_the_bergamute");
petal_of_the_bergamute.register();
var soul_extractor = VanillaFactory.createItem("soul_extractor");
soul_extractor.maxStackSize = 1;
soul_extractor.maxDamage = 1024;
soul_extractor.register();
var soul_of_the_dark_realm = VanillaFactory.createItem("soul_of_the_dark_realm");
soul_of_the_dark_realm.rarity = "EPIC";
soul_of_the_dark_realm.register();
var rune_of_deception = VanillaFactory.createItem("rune_of_deception");
rune_of_deception.register();
var purified_tablet = VanillaFactory.createItem("purified_tablet");
purified_tablet.register();
var magical_tablet = VanillaFactory.createItem("magical_tablet");
magical_tablet.register();
var munching_petal = VanillaFactory.createItem("munching_petal");
munching_petal.register();
var petal_of_the_entropinnyum = VanillaFactory.createItem("petal_of_the_entropinnyum");
petal_of_the_entropinnyum.register();
var spectacular_petal = VanillaFactory.createItem("spectacular_petal");
spectacular_petal.register();
var petal_of_the_rafflowsia = VanillaFactory.createItem("petal_of_the_rafflowsia");
petal_of_the_rafflowsia.register();
var petal_me_not = VanillaFactory.createItem("petal_me_not");
petal_me_not.register();
var petal_of_the_game_of_life = VanillaFactory.createItem("petal_of_the_game_of_life");
petal_of_the_game_of_life.register();
var morphing_petal = VanillaFactory.createItem("morphing_petal");
morphing_petal.register();
var orechid_petallius = VanillaFactory.createItem("orechid_petallius");
orechid_petallius.register();
var orechid_ignem_petallius = VanillaFactory.createItem("orechid_ignem_petallius");
orechid_ignem_petallius.register();
var petal_of_the_fallen_kanade = VanillaFactory.createItem("petal_of_the_fallen_kanade");
petal_of_the_fallen_kanade.register();
var petal_of_the_hyacidus = VanillaFactory.createItem("petal_of_the_hyacidus");
petal_of_the_hyacidus.register();
var medumone_petal = VanillaFactory.createItem("medumone_petal");
medumone_petal.register();
var pollinating_petal = VanillaFactory.createItem("pollinating_petal");
pollinating_petal.register();
var loonium_petal = VanillaFactory.createItem("loonium_petal");
loonium_petal.register();
var petal_of_the_vinculotus = VanillaFactory.createItem("petal_of_the_vinculotus");
petal_of_the_vinculotus.register();
var spectralight_petal = VanillaFactory.createItem("spectralight_petal");
spectralight_petal.register();
var blubbing_petal = VanillaFactory.createItem("blubbing_petal");
blubbing_petal.register();
var petal_of_a_slice_o_cake = VanillaFactory.createItem("petal_of_a_slice_o_cake");
petal_of_a_slice_o_cake.register();
var dreaming_petal = VanillaFactory.createItem("dreaming_petal");
dreaming_petal.register();
var mystical_tablet = VanillaFactory.createItem("mystical_tablet");
mystical_tablet.register();
var rainbow_tablet = VanillaFactory.createItem("rainbow_tablet");
rainbow_tablet.register();
var omothol_teleporter = VanillaFactory.createItem("omothol_teleporter");
omothol_teleporter.rarity = "RARE";
omothol_teleporter.maxStackSize = 1;
omothol_teleporter.maxDamage = 1;
omothol_teleporter.itemRightClick = function(stack, world, player, hand) {
    if(world.remote) {
        return "PASS";
    }
    stack.damage(2, player);
	Commands.call("tpx @p 0 80 0 52", player, world, false, true);
    return "SUCCESS";
};
omothol_teleporter.register();
var infused_magical_core = VanillaFactory.createItem("infused_magical_core");
infused_magical_core.rarity = "EPIC";
infused_magical_core.glowing = true;
infused_magical_core.register();
var base_focal_sphere = VanillaFactory.createItem("base_focal_sphere");
base_focal_sphere.register();
var knowledge_of_the_sky = VanillaFactory.createItem("knowledge_of_the_sky");
knowledge_of_the_sky.rarity = "EPIC";
knowledge_of_the_sky.glowing = true;
knowledge_of_the_sky.register();
var matrix_multiplication_unit = VanillaFactory.createItem("matrix_multiplication_unit");
matrix_multiplication_unit.rarity = "EPIC";
matrix_multiplication_unit.glowing = true;
matrix_multiplication_unit.register();
val allThaumcraftAspects_ = ["aer", "terra", "ignis", "aqua", "ordo", "perditio", "vacuos", "lux", "motus", "gelum", "vitreus", "metallum", "victus", "mortuus", "potentia", "permutatio", "praecantatio", "auram", "alkimia", "vitium", "tenebrae", "alienis", "volatus", "herba", "instrumentum", "fabrico", "machina", "vinculum", "spiritus", "cognitio", "sensus", "aversio", "praemunio", "desiderium", "exanimis", "bestia", "humanus", "sol", "luna", "stellae", "diabolus"] as string[];
for aspect in allThaumcraftAspects_ {
	var condensed_vis_crystal = VanillaFactory.createItem("condensed_vis_crystal_" + aspect);
	condensed_vis_crystal.register();
}
var woodland_mansion_locator_token = VanillaFactory.createItem("woodland_mansion_locator_token");
woodland_mansion_locator_token.maxStackSize = 1;
woodland_mansion_locator_token.maxDamage = 1;
woodland_mansion_locator_token.itemRightClick = function(stack, world, player, hand) {
    #if(world.remote) {
    #    return "PASS";
    #}
    stack.damage(2, player);
    player.executeCommand("locate Mansion");
	Commands.call("locate Mansion", player, world, false, true);
    return "SUCCESS";
};
woodland_mansion_locator_token.register();
var abyssal_wasteland_teleporter = VanillaFactory.createItem("abyssal_wasteland_teleporter");
abyssal_wasteland_teleporter.rarity = "RARE";
abyssal_wasteland_teleporter.maxStackSize = 1;
abyssal_wasteland_teleporter.maxDamage = 2;
abyssal_wasteland_teleporter.itemRightClick = function(stack, world, player, hand) {
    if(world.remote) {
        return "PASS";
    }
    stack.damage(1, player);
	Commands.call("tpx @p 0 80 0 50", player, world, false, true);
    return "SUCCESS";
};
abyssal_wasteland_teleporter.register();
var mysterious_leaking_soul = VanillaFactory.createItem("mysterious_leaking_soul");
mysterious_leaking_soul.rarity = "EPIC";
mysterious_leaking_soul.glowing = true;
mysterious_leaking_soul.register();
var brew_of_the_void = VanillaFactory.createItem("brew_of_the_void");
brew_of_the_void.register();
var dragon_resin = VanillaFactory.createItem("dragon_resin");
dragon_resin.register();
var gypsum = VanillaFactory.createItem("gypsum");
gypsum.register();
var travelers_tenacity = VanillaFactory.createItem("travelers_tenacity");
travelers_tenacity.register();
var lively_nature = VanillaFactory.createItem("lively_nature");
lively_nature.register();
var witches_delicacy = VanillaFactory.createItem("witches_delicacy");
witches_delicacy.register();
var dense_demonic_elixir = VanillaFactory.createItem("dense_demonic_elixir");
dense_demonic_elixir.register();
var stirring_strength = VanillaFactory.createItem("stirring_strength");
stirring_strength.register();
var witches_stonebrew = VanillaFactory.createItem("witches_stonebrew");
witches_stonebrew.register();
var ignition = VanillaFactory.createItem("ignition");
ignition.glowing = true;
ignition.register();
var flame_devourer_pendant = VanillaFactory.createItem("flame_devourer_pendant");
flame_devourer_pendant.rarity = "EPIC";
flame_devourer_pendant.maxStackSize = 1;
flame_devourer_pendant.maxDamage = 15;
flame_devourer_pendant.itemRightClick = function(stack, world, player, hand) {
    if(world.remote) {
        return "PASS";
    }
    var found = false as bool;
    for p in player.activePotionEffects {
		#Commands.call("say " + p.effectName, player, world);
    	if(p.effectName == "bewitchment.hellfire") {
    		found = true;
    	}
    }
    if(found) {
	    stack.damage(1, player);
		Commands.call("give @p contenttweaker:ignition 1 0", player, world, false, true);
    	return "SUCCESS";
    }
    return "FAIL";
};
flame_devourer_pendant.register();
var death_core = VanillaFactory.createItem("death_core");
death_core.rarity = "RARE";
death_core.register();
var shard_of_the_grotesque = VanillaFactory.createItem("shard_of_the_grotesque");
shard_of_the_grotesque.glowing = true;
shard_of_the_grotesque.register();
var cold_void_seed = VanillaFactory.createItem("cold_void_seed");
cold_void_seed.register();
var cold_void_metal_ingot = VanillaFactory.createItem("cold_void_metal_ingot");
cold_void_metal_ingot.register();
var impetus_crystal = VanillaFactory.createItem("impetus_crystal");
impetus_crystal.rarity = "EPIC";
impetus_crystal.glowing = true;
impetus_crystal.register();
var thaumium_processor = VanillaFactory.createItem("thaumium_processor");
thaumium_processor.register();
var printed_thaumium_circuit = VanillaFactory.createItem("printed_thaumium_circuit");
printed_thaumium_circuit.register();
var conducted_impetus = VanillaFactory.createItem("conducted_impetus");
conducted_impetus.rarity = "EPIC";
conducted_impetus.glowing = true;
conducted_impetus.register();
var arcanium_base = VanillaFactory.createItem("arcanium_base");
arcanium_base.rarity = "RARE";
arcanium_base.register();
var primordial_fragment = VanillaFactory.createItem("primordial_fragment");
primordial_fragment.rarity = "EPIC";
primordial_fragment.glowing = true;
primordial_fragment.register();

function checkBiomesAtPositions(biomeName as string, player_pos as crafttweaker.util.Position3f, biomeLocations as int[][], world as crafttweaker.world.IWorld) as int {
	var numOfMatches = 0 as int;
	var check_pos as crafttweaker.util.Position3f;
	var add_x = 0 as int;
	var add_z = 0 as int;
	for coord_pair in biomeLocations {
		add_x = coord_pair[0];
		add_z = coord_pair[1];
		check_pos = crafttweaker.util.Position3f.create(player_pos.x + add_x, player_pos.y, player_pos.z + add_z);
		if(world.getBiome(check_pos).name == biomeName) {
			numOfMatches += 1;
		}
	}
	return numOfMatches;
}

var ritualistic_biome_checker = VanillaFactory.createItem("ritualistic_biome_checker");
ritualistic_biome_checker.rarity = "RARE";
ritualistic_biome_checker.maxStackSize = 1;
ritualistic_biome_checker.itemRightClick = function(stack, world, player, hand) {
	if(world.remote) {
        return "PASS";
    }
    if(player.getDimension() != 0) {
        player.sendChat("You must be in the Overworld to perform this craft!");
        return "PASS";
    }
	val mortumBiomeLocations = [[3,3],[3,2],[3,1],[3,0],[3,-1],[3,-2],[3,-3],[2,3],[2,-3],[1,3],[1,-3],[0,3],[0,-3],[-1,3],[-1,-3],[-2,3],[-2,-3],[-3,3],[-3,2],[-3,1],[-3,0],[-3,-1],[-3,-2],[-3,-3]] as int[][];
	val hellBiomeLocations = [[2,2],[2,1],[2,0],[2,-1],[2,-2],[1,2],[1,-2],[0,2],[0,-2],[-1,2],[-1,-2],[-2,2],[-2,1],[-2,0],[-2,-1],[-2,-2]] as int[][];
	val magicalForestBiomeLocations = [[1,1],[1,0],[1,-1],[0,1],[0,-1],[-1,1],[-1,0],[-1,-1]] as int[][];
	val oceanBiomeLocations = [[0,0]] as int[][];
	var cur_pos = player.position as crafttweaker.util.Position3f;

	val mortumMatches = checkBiomesAtPositions("Mortum", cur_pos, mortumBiomeLocations, world) as int;
	val hellMatches = checkBiomesAtPositions("Hell", cur_pos, hellBiomeLocations, world) as int;
	val magicalForestMatches = checkBiomesAtPositions("Magical Forest", cur_pos, magicalForestBiomeLocations, world) as int;
	val oceanMatches = checkBiomesAtPositions("Ocean", cur_pos, oceanBiomeLocations, world) as int;

	player.sendChat("Mortum biome matches: " ~ mortumMatches ~ " / 24");
	player.sendChat("Hell biome matches: " ~ hellMatches ~ " / 16");
	player.sendChat("Magical Forest biome matches: " ~ magicalForestMatches ~ " / 8");
	player.sendChat("Ocean biome matches: " ~ oceanMatches ~ " / 1");

	return "SUCCESS";
};
ritualistic_biome_checker.register();
var essence_of_space = VanillaFactory.createItem("essence_of_space");
essence_of_space.rarity = "EPIC";
essence_of_space.register();
var perfect_vacuum = VanillaFactory.createItem("perfect_vacuum");
perfect_vacuum.register();
var dungeon_token = VanillaFactory.createItem("dungeon_token");
dungeon_token.register();
var lightning_charge = VanillaFactory.createItem("lightning_charge");
lightning_charge.glowing = true;
lightning_charge.register();
var antimatter_cluster = VanillaFactory.createItem("antimatter_cluster");
antimatter_cluster.glowing = true;
antimatter_cluster.register();
var mystical_iron_ingot = VanillaFactory.createItem("mystical_iron_ingot");
mystical_iron_ingot.glowing = true;
mystical_iron_ingot.register();
var eye_of_the_nightmare = VanillaFactory.createItem("eye_of_the_nightmare");
eye_of_the_nightmare.register();
var shattered_mystical_iron_crystal = VanillaFactory.createItem("shattered_mystical_iron_crystal");
shattered_mystical_iron_crystal.glowing = true;
shattered_mystical_iron_crystal.register();
var sparkling_aquamarine = VanillaFactory.createItem("sparkling_aquamarine");
sparkling_aquamarine.register();
var essence_of_enclosement = VanillaFactory.createItem("essence_of_enclosement");
essence_of_enclosement.rarity = "EPIC";
essence_of_enclosement.register();
var essence_of_length = VanillaFactory.createItem("essence_of_length");
essence_of_length.rarity = "EPIC";
essence_of_length.register();
var essence_of_extension = VanillaFactory.createItem("essence_of_extension");
essence_of_extension.rarity = "EPIC";
essence_of_extension.register();
var essence_of_foundation = VanillaFactory.createItem("essence_of_foundation");
essence_of_foundation.glowing = true;
essence_of_foundation.rarity = "EPIC";
essence_of_foundation.register();
var essence_of_thought = VanillaFactory.createItem("essence_of_thought");
essence_of_thought.glowing = true;
essence_of_thought.rarity = "EPIC";
essence_of_thought.register();
var essence_of_motion = VanillaFactory.createItem("essence_of_motion");
essence_of_motion.rarity = "EPIC";
essence_of_motion.register();
var essence_of_cycles = VanillaFactory.createItem("essence_of_cycles");
essence_of_cycles.rarity = "EPIC";
essence_of_cycles.register();
var essence_of_opening = VanillaFactory.createItem("essence_of_opening");
essence_of_opening.rarity = "EPIC";
essence_of_opening.register();
var enchanters_phd = VanillaFactory.createItem("enchanters_phd");
enchanters_phd.rarity = "EPIC";
enchanters_phd.maxStackSize = 1;
enchanters_phd.glowing = true;
enchanters_phd.register();
var astral_core = VanillaFactory.createItem("astral_core");
astral_core.rarity = "EPIC";
astral_core.maxStackSize = 16;
astral_core.glowing = true;
astral_core.register();
var star_of_revelation = VanillaFactory.createItem("star_of_revelation");
star_of_revelation.rarity = "EPIC";
star_of_revelation.maxStackSize = 1;
star_of_revelation.glowing = true;
star_of_revelation.register();
var galactic_ingot = VanillaFactory.createItem("galactic_ingot");
galactic_ingot.rarity = "RARE";
galactic_ingot.register();
var steve = VanillaFactory.createItem("steve");
steve.maxStackSize = 1;
steve.register();
var alex = VanillaFactory.createItem("alex");
alex.maxStackSize = 1;
alex.register();
var herobrine = VanillaFactory.createItem("herobrine");
herobrine.maxStackSize = 1;
herobrine.register();
var age_modifier = VanillaFactory.createItem("age_modifier");
age_modifier.register();
var height_modifier = VanillaFactory.createItem("height_modifier");
height_modifier.register();
var friends_modifier = VanillaFactory.createItem("friends_modifier");
friends_modifier.register();
var modifier_1 = VanillaFactory.createItem("modifier_1");
modifier_1.register();
var modifier_m1 = VanillaFactory.createItem("modifier_m1");
modifier_m1.register();
var modifier_10 = VanillaFactory.createItem("modifier_10");
modifier_10.register();
var modifier_m10 = VanillaFactory.createItem("modifier_m10");
modifier_m10.register();
var modifier_100 = VanillaFactory.createItem("modifier_100");
modifier_100.register();
var modifier_m100 = VanillaFactory.createItem("modifier_m100");
modifier_m100.register();
var modifier_1000 = VanillaFactory.createItem("modifier_1000");
modifier_1000.register();
var modifier_m1000 = VanillaFactory.createItem("modifier_m1000");
modifier_m1000.register();
var tough_galactic_plating = VanillaFactory.createItem("tough_galactic_plating");
tough_galactic_plating.register();
var galactic_machine_frame = VanillaFactory.createItem("galactic_machine_frame");
galactic_machine_frame.rarity = "RARE";
galactic_machine_frame.register();
var cheesy_silicon_compound = VanillaFactory.createItem("cheesy_silicon_compound");
cheesy_silicon_compound.register();
var cheesy_silicon = VanillaFactory.createItem("cheesy_silicon");
cheesy_silicon.register();
var cheesy_wafer = VanillaFactory.createItem("cheesy_wafer");
cheesy_wafer.rarity = "RARE";
cheesy_wafer.register();
var sapphire_accelerator = VanillaFactory.createItem("sapphire_accelerator");
sapphire_accelerator.register();
var spacerock = VanillaFactory.createItem("spacerock");
spacerock.rarity = "RARE";
spacerock.glowing = true;
spacerock.register();
var desh_dust = VanillaFactory.createItem("desh_dust");
desh_dust.register();
var secret_alien_technology = VanillaFactory.createItem("secret_alien_technology");
secret_alien_technology.rarity = "EPIC";
secret_alien_technology.glowing = true;
secret_alien_technology.maxStackSize = 16;
secret_alien_technology.register();
var empowered_thermal_controller = VanillaFactory.createItem("empowered_thermal_controller");
empowered_thermal_controller.rarity = "RARE";
empowered_thermal_controller.glowing = true;
empowered_thermal_controller.register();
var chunk_of_the_meteor_that_ended_the_era_of_dinosaurs = VanillaFactory.createItem("chunk_of_the_meteor_that_ended_the_era_of_dinosaurs");
chunk_of_the_meteor_that_ended_the_era_of_dinosaurs.rarity = "EPIC";
chunk_of_the_meteor_that_ended_the_era_of_dinosaurs.glowing = true;
chunk_of_the_meteor_that_ended_the_era_of_dinosaurs.maxStackSize = 16;
chunk_of_the_meteor_that_ended_the_era_of_dinosaurs.register();
var fragment_of_the_sun = VanillaFactory.createItem("fragment_of_the_sun");
fragment_of_the_sun.rarity = "EPIC";
fragment_of_the_sun.glowing = true;
fragment_of_the_sun.maxStackSize = 16;
fragment_of_the_sun.register();
var empowered_solar_dust = VanillaFactory.createItem("empowered_solar_dust");
empowered_solar_dust.rarity = "RARE";
empowered_solar_dust.register();
var solar_ingot = VanillaFactory.createItem("solar_ingot");
solar_ingot.rarity = "RARE";
solar_ingot.register();
var corrupted_light_ingot = VanillaFactory.createItem("corrupted_light_ingot");
corrupted_light_ingot.rarity = "RARE";
corrupted_light_ingot.register();
var plasma_core = VanillaFactory.createItem("plasma_core");
plasma_core.rarity = "EPIC";
plasma_core.register();
var photovoltaic_cell_vii = VanillaFactory.createItem("photovoltaic_cell_vii");
photovoltaic_cell_vii.register();
var photovoltaic_cell_viii = VanillaFactory.createItem("photovoltaic_cell_viii");
photovoltaic_cell_viii.register();
var cadmium_arsenic_compound = VanillaFactory.createItem("cadmium_arsenic_compound");
cadmium_arsenic_compound.register();
var chromium_barium_compound = VanillaFactory.createItem("chromium_barium_compound");
chromium_barium_compound.register();
var antimony_strontium_compound = VanillaFactory.createItem("antimony_strontium_compound");
antimony_strontium_compound.register();
var corrupted_key_to_infinity = VanillaFactory.createItem("corrupted_key_to_infinity");
corrupted_key_to_infinity.maxStackSize = 1;
corrupted_key_to_infinity.rarity = "EPIC";
corrupted_key_to_infinity.glowing = true;
corrupted_key_to_infinity.register();
var heavenly_key_to_infinity = VanillaFactory.createItem("heavenly_key_to_infinity");
heavenly_key_to_infinity.maxStackSize = 1;
heavenly_key_to_infinity.rarity = "EPIC";
heavenly_key_to_infinity.glowing = true;
heavenly_key_to_infinity.register();
var glyph_route = VanillaFactory.createItem("glyph_route");
glyph_route.register();
var glyph_bag = VanillaFactory.createItem("glyph_bag");
glyph_bag.register();
var glyph_tent = VanillaFactory.createItem("glyph_tent");
glyph_tent.register();
var glyph_waterfall = VanillaFactory.createItem("glyph_waterfall");
glyph_waterfall.register();
var glyph_tongue = VanillaFactory.createItem("glyph_tongue");
glyph_tongue.register();
var glyph_scythe = VanillaFactory.createItem("glyph_scythe");
glyph_scythe.register();
var glyph_blockade = VanillaFactory.createItem("glyph_blockade");
glyph_blockade.register();
var glyph_lash = VanillaFactory.createItem("glyph_lash");
glyph_lash.register();
var glyph_slash = VanillaFactory.createItem("glyph_slash");
glyph_slash.register();
var glyph_rod = VanillaFactory.createItem("glyph_rod");
glyph_rod.register();
var glyph_split = VanillaFactory.createItem("glyph_split");
glyph_split.register();
var glyph_shield = VanillaFactory.createItem("glyph_shield");
glyph_shield.register();
var glyph_war = VanillaFactory.createItem("glyph_war");
glyph_war.register();
var glyph_cross = VanillaFactory.createItem("glyph_cross");
glyph_cross.register();
var glyph_stamp = VanillaFactory.createItem("glyph_stamp");
glyph_stamp.register();
var glyph_connection = VanillaFactory.createItem("glyph_connection");
glyph_connection.register();
var glyph_fork = VanillaFactory.createItem("glyph_fork");
glyph_fork.register();
var glyph_wave = VanillaFactory.createItem("glyph_wave");
glyph_wave.register();
var glyph_lightning = VanillaFactory.createItem("glyph_lightning");
glyph_lightning.register();
var glyph_pair = VanillaFactory.createItem("glyph_pair");
glyph_pair.register();
var glyph_fish = VanillaFactory.createItem("glyph_fish");
glyph_fish.register();
var glyph_weaving = VanillaFactory.createItem("glyph_weaving");
glyph_weaving.register();
var glyph_stand = VanillaFactory.createItem("glyph_stand");
glyph_stand.register();
var glyph_lion = VanillaFactory.createItem("glyph_lion");
glyph_lion.register();
var glyph_mirror = VanillaFactory.createItem("glyph_mirror");
glyph_mirror.register();
var glyph_electricity = VanillaFactory.createItem("glyph_electricity");
glyph_electricity.register();
var oxygen_rich_barium_calcite_perpetuator = VanillaFactory.createItem("oxygen_rich_barium_calcite_perpetuator");
oxygen_rich_barium_calcite_perpetuator.rarity = "RARE";
oxygen_rich_barium_calcite_perpetuator.register();
var copper_bismid_carbonate_sheet = VanillaFactory.createItem("copper_bismid_carbonate_sheet");
copper_bismid_carbonate_sheet.register();
var ruby_rubidium = VanillaFactory.createItem("ruby_rubidium");
ruby_rubidium.register();
var vmb_compound = VanillaFactory.createItem("vmb_compound");
vmb_compound.register();
var zysc_baach_sheet = VanillaFactory.createItem("zysc_baach_sheet");
zysc_baach_sheet.register();
var fission_coolant = VanillaFactory.createItem("fission_coolant");
fission_coolant.register();
var highly_radioactive_dimension_splitting_compound = VanillaFactory.createItem("highly_radioactive_dimension_splitting_compound");
highly_radioactive_dimension_splitting_compound.rarity = "EPIC";
highly_radioactive_dimension_splitting_compound.onItemUpdate = function(itemStack, world, owner, slot, isSelected) {
	if (owner instanceof IPlayer) {
	    val player as IPlayer = owner;

	    Commands.call("effect @p minecraft:poison 5 3 true", player, world, false, true);
	    Commands.call("effect @p minecraft:wither 5 2 true", player, world, false, true);
		player.setFire(5);

		if(isSelected) {
	    	Commands.call("effect @p minecraft:blindness 5 1 true", player, world, false, true);
	    	Commands.call("effect @p minecraft:nausea 5 1 true", player, world, false, true);
		}
	}
	return;
};
highly_radioactive_dimension_splitting_compound.register();
var slice_of_dragon_egg = VanillaFactory.createItem("slice_of_dragon_egg");
slice_of_dragon_egg.register();
var rune_of_mana = VanillaFactory.createItem("rune_of_mana");
rune_of_mana.register();
var rune_of_lust = VanillaFactory.createItem("rune_of_lust");
rune_of_lust.register();
var rune_of_gluttony = VanillaFactory.createItem("rune_of_gluttony");
rune_of_gluttony.register();
var rune_of_greed = VanillaFactory.createItem("rune_of_greed");
rune_of_greed.register();
var rune_of_sloth = VanillaFactory.createItem("rune_of_sloth");
rune_of_sloth.register();
var rune_of_wrath = VanillaFactory.createItem("rune_of_wrath");
rune_of_wrath.register();
var rune_of_envy = VanillaFactory.createItem("rune_of_envy");
rune_of_envy.register();
var rune_of_pride = VanillaFactory.createItem("rune_of_pride");
rune_of_pride.register();
var rune_of_water = VanillaFactory.createItem("rune_of_water");
rune_of_water.register();
var rune_of_fire = VanillaFactory.createItem("rune_of_fire");
rune_of_fire.register();
var rune_of_earth = VanillaFactory.createItem("rune_of_earth");
rune_of_earth.register();
var rune_of_air = VanillaFactory.createItem("rune_of_air");
rune_of_air.register();
var rune_of_spring = VanillaFactory.createItem("rune_of_spring");
rune_of_spring.register();
var rune_of_summer = VanillaFactory.createItem("rune_of_summer");
rune_of_summer.register();
var rune_of_autumn = VanillaFactory.createItem("rune_of_autumn");
rune_of_autumn.register();
var rune_of_winter = VanillaFactory.createItem("rune_of_winter");
rune_of_winter.register();
var solar_seeds = VanillaFactory.createItem("solar_seeds");
solar_seeds.register();
var solar_essence = VanillaFactory.createItem("solar_essence");
solar_essence.register();
var minecraft_singularity = VanillaFactory.createItem("minecraft_singularity");
minecraft_singularity.register();
var thermal_singularity = VanillaFactory.createItem("thermal_singularity");
thermal_singularity.register();
var mixed_thermal_singularity = VanillaFactory.createItem("mixed_thermal_singularity");
mixed_thermal_singularity.register();
var tinkers_singularity = VanillaFactory.createItem("tinkers_singularity");
tinkers_singularity.register();
var enderio_singularity = VanillaFactory.createItem("enderio_singularity");
enderio_singularity.register();
var endergy_singularity = VanillaFactory.createItem("endergy_singularity");
endergy_singularity.register();
var projectred_singularity = VanillaFactory.createItem("projectred_singularity");
projectred_singularity.register();
var mekanism_singularity = VanillaFactory.createItem("mekanism_singularity");
mekanism_singularity.register();
var abyssal_singularity = VanillaFactory.createItem("abyssal_singularity");
abyssal_singularity.register();
var divine_singularity = VanillaFactory.createItem("divine_singularity");
divine_singularity.register();
var dusty_thermal_singularity = VanillaFactory.createItem("dusty_thermal_singularity");
dusty_thermal_singularity.register();
var botanic_singularity = VanillaFactory.createItem("botanic_singularity");
botanic_singularity.register();
var thaumic_singularity = VanillaFactory.createItem("thaumic_singularity");
thaumic_singularity.register();
var alchemic_singularity = VanillaFactory.createItem("alchemic_singularity");
alchemic_singularity.register();
var draglactic_singularity = VanillaFactory.createItem("draglactic_singularity");
draglactic_singularity.register();
var extra_tech_singularity = VanillaFactory.createItem("extra_tech_singularity");
extra_tech_singularity.register();
var extra_magic_singularity = VanillaFactory.createItem("extra_magic_singularity");
extra_magic_singularity.register();
var magical_singularity = VanillaFactory.createItem("magical_singularity");
magical_singularity.register();
var techy_singularity = VanillaFactory.createItem("techy_singularity");
techy_singularity.register();
var powerful_singularity = VanillaFactory.createItem("powerful_singularity");
powerful_singularity.register();
var beginners_singularity = VanillaFactory.createItem("beginners_singularity");
beginners_singularity.register();
var corrupted_draconium_dust = VanillaFactory.createItem("corrupted_draconium_dust");
corrupted_draconium_dust.register();
var proton = VanillaFactory.createItem("proton");
proton.register();
var electron = VanillaFactory.createItem("electron");
electron.register();
var anti_proton = VanillaFactory.createItem("anti_proton");
anti_proton.register();
var anti_electron = VanillaFactory.createItem("anti_electron");
anti_electron.register();
var fission_catalyst = VanillaFactory.createItem("fission_catalyst");
fission_catalyst.register();
var anti_hydrogen = VanillaFactory.createItem("anti_hydrogen");
anti_hydrogen.register();
var singularification_catalyst = VanillaFactory.createItem("singularification_catalyst");
singularification_catalyst.register();
var tnt_singularity = VanillaFactory.createItem("tnt_singularity");
tnt_singularity.register();
var white_matter = VanillaFactory.createItem("white_matter");
white_matter.register();
var anti_air = VanillaFactory.createItem("anti_air");
anti_air.register();
var taste_the_rainbow = VanillaFactory.createItem("taste_the_rainbow");
taste_the_rainbow.rarity = "EPIC";
taste_the_rainbow.register();
var corruption_core = VanillaFactory.createItem("corruption_core");
corruption_core.register();
var clay = VanillaFactory.createItem("clay");
clay.rarity = "RARE";
clay.register();
var essence_of_life = VanillaFactory.createItem("essence_of_life");
essence_of_life.rarity = "EPIC";
essence_of_life.register();
var essence_of_death = VanillaFactory.createItem("essence_of_death");
essence_of_death.rarity = "EPIC";
essence_of_death.register();
var photovoltaic_cell_ix = VanillaFactory.createItem("photovoltaic_cell_ix");
photovoltaic_cell_ix.register();
var photovoltaic_cell_x = VanillaFactory.createItem("photovoltaic_cell_x");
photovoltaic_cell_x.register();
var photovoltaic_cell_xi = VanillaFactory.createItem("photovoltaic_cell_xi");
photovoltaic_cell_xi.register();
var burger = VanillaFactory.createItemFood("burger", 14);
burger.saturation = 1.0;
burger.register();
var taco = VanillaFactory.createItemFood("taco", 20);
taco.saturation = 1.0;
taco.register();
var chicken_nugget = VanillaFactory.createItemFood("chicken_nugget", 8);
chicken_nugget.saturation = 0.4;
chicken_nugget.register();
var cosmic_neutronium_burger = VanillaFactory.createItemFood("cosmic_neutronium_burger", 90);
cosmic_neutronium_burger.saturation = 1.0;
cosmic_neutronium_burger.rarity = "EPIC";
cosmic_neutronium_burger.register();
var cosmic_neutronium_taco = VanillaFactory.createItemFood("cosmic_neutronium_taco", 120);
cosmic_neutronium_taco.saturation = 1.0;
cosmic_neutronium_taco.rarity = "EPIC";
cosmic_neutronium_taco.register();
var cosmic_neutronium_nugget = VanillaFactory.createItemFood("cosmic_neutronium_nugget", 60);
cosmic_neutronium_nugget.saturation = 1.0;
cosmic_neutronium_nugget.rarity = "EPIC";
cosmic_neutronium_nugget.register();
var natures_blessing = VanillaFactory.createItem("natures_blessing");
natures_blessing.rarity = "RARE";
natures_blessing.register();
var neutronium_singularity = VanillaFactory.createItem("neutronium_singularity");
neutronium_singularity.glowing = true;
neutronium_singularity.register();
var infinite_singularity = VanillaFactory.createItem("infinite_singularity");
infinite_singularity.rarity = "EPIC";
infinite_singularity.glowing = true;
infinite_singularity.register();
var singularity_singularity = VanillaFactory.createItem("singularity_singularity");
singularity_singularity.rarity = "EPIC";
singularity_singularity.glowing = true;
singularity_singularity.register();
var puzzle_tile_rgrgg = VanillaFactory.createItem("puzzle_tile_rgrgg");
puzzle_tile_rgrgg.register();
var puzzle_tile_ooror = VanillaFactory.createItem("puzzle_tile_ooror");
puzzle_tile_ooror.register();
var puzzle_tile_rookr = VanillaFactory.createItem("puzzle_tile_rookr");
puzzle_tile_rookr.register();
var puzzle_tile_krrrk = VanillaFactory.createItem("puzzle_tile_krrrk");
puzzle_tile_krrrk.register();
var puzzle_tile_rrbrg = VanillaFactory.createItem("puzzle_tile_rrbrg");
puzzle_tile_rrbrg.register();
var puzzle_tile_rkkkk = VanillaFactory.createItem("puzzle_tile_rkkkk");
puzzle_tile_rkkkk.register();
var puzzle_tile_rggor = VanillaFactory.createItem("puzzle_tile_rggor");
puzzle_tile_rggor.register();
var puzzle_tile_rkrrk = VanillaFactory.createItem("puzzle_tile_rkrrk");
puzzle_tile_rkrrk.register();
var puzzle_tile_gggob = VanillaFactory.createItem("puzzle_tile_gggob");
puzzle_tile_gggob.register();
var puzzle_tile_oookb = VanillaFactory.createItem("puzzle_tile_oookb");
puzzle_tile_oookb.register();
var puzzle_tile_rkrkk = VanillaFactory.createItem("puzzle_tile_rkrkk");
puzzle_tile_rkrkk.register();
var puzzle_tile_rrrkr = VanillaFactory.createItem("puzzle_tile_rrrkr");
puzzle_tile_rrrkr.register();
var puzzle_tile_kkrkr = VanillaFactory.createItem("puzzle_tile_kkrkr");
puzzle_tile_kkrkr.register();
var puzzle_tile_grrrg = VanillaFactory.createItem("puzzle_tile_grrrg");
puzzle_tile_grrrg.register();
var puzzle_tile_oogoo = VanillaFactory.createItem("puzzle_tile_oogoo");
puzzle_tile_oogoo.register();
var puzzle_tile_rogro = VanillaFactory.createItem("puzzle_tile_rogro");
puzzle_tile_rogro.register();
var puzzle_tile_obgoo = VanillaFactory.createItem("puzzle_tile_obgoo");
puzzle_tile_obgoo.register();
var puzzle_tile_orgob = VanillaFactory.createItem("puzzle_tile_orgob");
puzzle_tile_orgob.register();
var puzzle_tile_krrkk = VanillaFactory.createItem("puzzle_tile_krrkk");
puzzle_tile_krrkk.register();
var puzzle_tile_ooroo = VanillaFactory.createItem("puzzle_tile_ooroo");
puzzle_tile_ooroo.register();
var puzzle_tile_obokr = VanillaFactory.createItem("puzzle_tile_obokr");
puzzle_tile_obokr.register();
var puzzle_tile_rkkbr = VanillaFactory.createItem("puzzle_tile_rkkbr");
puzzle_tile_rkkbr.register();
var puzzle_tile_roroo = VanillaFactory.createItem("puzzle_tile_roroo");
puzzle_tile_roroo.register();
var puzzle_tile_rrkbk = VanillaFactory.createItem("puzzle_tile_rrkbk");
puzzle_tile_rrkbk.register();
var puzzle_tile_ggrrr = VanillaFactory.createItem("puzzle_tile_ggrrr");
puzzle_tile_ggrrr.register();
var puzzle_tile_oooro = VanillaFactory.createItem("puzzle_tile_oooro");
puzzle_tile_oooro.register();
var puzzle_tile_ggror = VanillaFactory.createItem("puzzle_tile_ggror");
puzzle_tile_ggror.register();
var puzzle_tile_grggb = VanillaFactory.createItem("puzzle_tile_grggb");
puzzle_tile_grggb.register();
var puzzle_tile_ggrrg = VanillaFactory.createItem("puzzle_tile_ggrrg");
puzzle_tile_ggrrg.register();
var puzzle_tile_kkkbr = VanillaFactory.createItem("puzzle_tile_kkkbr");
puzzle_tile_kkkbr.register();
var puzzle_tile_krkkb = VanillaFactory.createItem("puzzle_tile_krkkb");
puzzle_tile_krkkb.register();
var puzzle_tile_rgbrr = VanillaFactory.createItem("puzzle_tile_rgbrr");
puzzle_tile_rgbrr.register();
var puzzle_tile_rrork = VanillaFactory.createItem("puzzle_tile_rrork");
puzzle_tile_rrork.register();
var puzzle_tile_rrbgr = VanillaFactory.createItem("puzzle_tile_rrbgr");
puzzle_tile_rrbgr.register();
var puzzle_tile_kbokk = VanillaFactory.createItem("puzzle_tile_kbokk");
puzzle_tile_kbokk.register();
var puzzle_tile_rrorr = VanillaFactory.createItem("puzzle_tile_rrorr");
puzzle_tile_rrorr.register();
var puzzle_tile_kbkkr = VanillaFactory.createItem("puzzle_tile_kbkkr");
puzzle_tile_kbkkr.register();
var puzzle_tile_orrro = VanillaFactory.createItem("puzzle_tile_orrro");
puzzle_tile_orrro.register();
var puzzle_tile_rrokr = VanillaFactory.createItem("puzzle_tile_rrokr");
puzzle_tile_rrokr.register();
var puzzle_tile_kkrrr = VanillaFactory.createItem("puzzle_tile_kkrrr");
puzzle_tile_kkrrr.register();
var puzzle_tile_kbkbk = VanillaFactory.createItem("puzzle_tile_kbkbk");
puzzle_tile_kbkbk.register();
var puzzle_tile_rkrbk = VanillaFactory.createItem("puzzle_tile_rkrbk");
puzzle_tile_rkrbk.register();
var puzzle_tile_krkbb = VanillaFactory.createItem("puzzle_tile_krkbb");
puzzle_tile_krkbb.register();
var puzzle_tile_oroob = VanillaFactory.createItem("puzzle_tile_oroob");
puzzle_tile_oroob.register();
var puzzle_tile_kkrbr = VanillaFactory.createItem("puzzle_tile_kkrbr");
puzzle_tile_kkrbr.register();
var puzzle_tile_krrbk = VanillaFactory.createItem("puzzle_tile_krrbk");
puzzle_tile_krrbk.register();
var puzzle_tile_rrgor = VanillaFactory.createItem("puzzle_tile_rrgor");
puzzle_tile_rrgor.register();
var puzzle_tile_gbggr = VanillaFactory.createItem("puzzle_tile_gbggr");
puzzle_tile_gbggr.register();
var puzzle_tile_ooorr = VanillaFactory.createItem("puzzle_tile_ooorr");
puzzle_tile_ooorr.register();
var puzzle_tile_gbbgr = VanillaFactory.createItem("puzzle_tile_gbbgr");
puzzle_tile_gbbgr.register();
var puzzle_tile_gbgog = VanillaFactory.createItem("puzzle_tile_gbgog");
puzzle_tile_gbgog.register();
var puzzle_tile_rroro = VanillaFactory.createItem("puzzle_tile_rroro");
puzzle_tile_rroro.register();
var puzzle_tile_obooo = VanillaFactory.createItem("puzzle_tile_obooo");
puzzle_tile_obooo.register();
var puzzle_tile_kkkrr = VanillaFactory.createItem("puzzle_tile_kkkrr");
puzzle_tile_kkkrr.register();
var puzzle_tile_rrgog = VanillaFactory.createItem("puzzle_tile_rrgog");
puzzle_tile_rrgog.register();
var puzzle_tile_grbgb = VanillaFactory.createItem("puzzle_tile_grbgb");
puzzle_tile_grbgb.register();
var puzzle_tile_rkrkr = VanillaFactory.createItem("puzzle_tile_rkrkr");
puzzle_tile_rkrkr.register();
var puzzle_tile_krokb = VanillaFactory.createItem("puzzle_tile_krokb");
puzzle_tile_krokb.register();
var puzzle_tile_kkkbk = VanillaFactory.createItem("puzzle_tile_kkkbk");
puzzle_tile_kkkbk.register();
var it1 = VanillaFactory.createItem("it1");
it1.rarity = "EPIC";
it1.maxStackSize = 1;
it1.register();
var it2 = VanillaFactory.createItem("it2");
it2.rarity = "EPIC";
it2.maxStackSize = 1;
it2.register();
var it3 = VanillaFactory.createItem("it3");
it3.rarity = "EPIC";
it3.maxStackSize = 1;
it3.register();
var it4 = VanillaFactory.createItem("it4");
it4.rarity = "EPIC";
it4.maxStackSize = 1;
it4.register();
var it5 = VanillaFactory.createItem("it5");
it5.rarity = "EPIC";
it5.maxStackSize = 1;
it5.register();
var creative_mesh = VanillaFactory.createItem("creative_mesh");
creative_mesh.rarity = "EPIC";
creative_mesh.register();
var creative_singularity = VanillaFactory.createItem("creative_singularity");
creative_singularity.rarity = "EPIC";
creative_singularity.glowing = true;
creative_singularity.register();
var call_of_the_underworld = VanillaFactory.createItem("call_of_the_underworld");
call_of_the_underworld.rarity = "EPIC";
call_of_the_underworld.register();
var heavens_cleansing = VanillaFactory.createItem("heavens_cleansing");
heavens_cleansing.rarity = "EPIC";
heavens_cleansing.register();
var si = VanillaFactory.createItem("si");
si.itemRightClick = function(stack, world, player, hand) {
	stack.shrink(1);
    Commands.call('summon bewitchment:demon ~ ~ ~ {CustomName:"Immortus",CustomNameVisible:1b,Health:100000,HandItems:[{id:"contenttweaker:call_of_the_underworld",Count:3}],HandDropChances:[1.00f],Attributes:[{Name:"generic.maxHealth",Base:100000F}]}', player, world, false, true);
    return "Pass";
};
si.rarity = "EPIC";
si.register();
unwarpification_talisman.register();
var goddess_pearl = VanillaFactory.createItem("goddess_pearl");
goddess_pearl.rarity = "EPIC";
goddess_pearl.glowing = true;
goddess_pearl.maxStackSize = 1;
goddess_pearl.register();
var industrial_grade_graphite_dust = VanillaFactory.createItem("industrial_grade_graphite_dust");
industrial_grade_graphite_dust.register();
var redstone_inlay_package = VanillaFactory.createItem("redstone_inlay_package");
redstone_inlay_package.register();

print("ENDING ContentTweakerItems.zs");
