/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.thaumcraft;

import appeng.api.AEApi;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.registries.IForgeRegistryEntry;
import thaumcraft.api.ThaumcraftApi;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.blocks.BlocksTC;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.crafting.InfusionRecipe;
import thaumcraft.api.crafting.ShapedArcaneRecipe;
import thaumcraft.api.crafting.ShapelessArcaneRecipe;
import thaumcraft.api.items.ItemsTC;
import thaumcraft.api.research.IScanThing;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ScanningManager;
import thaumcraft.api.research.theorycraft.ITheorycraftAid;
import thaumcraft.api.research.theorycraft.TheorycraftManager;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.init.ModGlobals;
import thaumicenergistics.integration.IThEIntegration;
import thaumicenergistics.integration.thaumcraft.research.AidMEController;
import thaumicenergistics.integration.thaumcraft.research.AidMEDrive;
import thaumicenergistics.integration.thaumcraft.research.CardTinkerAE;
import thaumicenergistics.integration.thaumcraft.research.ScanMod;
import thaumicenergistics.util.ForgeUtil;
import thaumicenergistics.util.TCUtil;
import thaumicenergistics.util.ThELog;

public class ThEThaumcraft
implements IThEIntegration {
    @Override
    public void init() {
        ThELog.info("Registering Research Category", new Object[0]);
        ResearchCategories.registerCategory((String)ModGlobals.RESEARCH_CATEGORY, (String)"f_AECORE", (AspectList)new AspectList().add(Aspect.MECHANISM, 15).add(Aspect.CRAFT, 15).add(Aspect.ENERGY, 20).add(Aspect.EXCHANGE, 20).add(Aspect.MAGIC, 15).add(Aspect.METAL, 5), (ResourceLocation)new ResourceLocation("thaumicenergistics", "textures/research/tab_icon.png"), (ResourceLocation)ResearchCategories.getResearchCategory((String)"BASICS").background, (ResourceLocation)ResearchCategories.getResearchCategory((String)"BASICS").background2);
        ThELog.info("Registering Research", new Object[0]);
        ThaumcraftApi.registerResearchLocation((ResourceLocation)new ResourceLocation("thaumicenergistics", "research/" + ModGlobals.RESEARCH_CATEGORY));
        ScanningManager.addScannableThing((IScanThing)new ScanMod("f_AECORE", "appliedenergistics2"));
        TheorycraftManager.registerCard(CardTinkerAE.class);
        if (AEApi.instance().definitions().blocks().controller().maybeBlock().isPresent()) {
            TheorycraftManager.registerAid((ITheorycraftAid)new AidMEController());
        } else if (AEApi.instance().definitions().blocks().drive().maybeBlock().isPresent()) {
            TheorycraftManager.registerAid((ITheorycraftAid)new AidMEDrive());
        }
        this.registerArcaneRecipes();
        this.registerInfusionRecipes();
    }

    private void registerArcaneRecipes() {
        ResourceLocation recipeGroup = new ResourceLocation("");
        ArrayList<ItemStack> certusQuartz = new ArrayList<ItemStack>(Arrays.asList(CraftingHelper.getIngredient((Object)"crystalCertusQuartz").func_193365_a()));
        certusQuartz.add(AEApi.instance().definitions().materials().certusQuartzCrystalCharged().maybeStack(1).orElse(ItemStack.field_190927_a));
        certusQuartz.add(AEApi.instance().definitions().materials().purifiedCertusQuartzCrystal().maybeStack(1).orElse(ItemStack.field_190927_a));
        ArrayList<ItemStack> netherQuartz = new ArrayList<ItemStack>(Arrays.asList(CraftingHelper.getIngredient((Object)"gemQuartz").func_193365_a()));
        netherQuartz.add(AEApi.instance().definitions().materials().purifiedNetherQuartzCrystal().maybeStack(1).orElse(ItemStack.field_190927_a));
        ThEApi.instance().items().coalescenceCore().maybeStack(2).ifPresent(stack -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "coalescence_core"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "DIGISENTIA@2", 10, new AspectList(), stack, new Object[]{"SSS", "QFL", "SSS", Character.valueOf('S'), new ItemStack(ItemsTC.nuggets, 1, 5), Character.valueOf('Q'), Ingredient.func_193369_a((ItemStack[])certusQuartz.toArray(new ItemStack[0])), Character.valueOf('F'), AEApi.instance().definitions().materials().fluixDust().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('L'), AEApi.instance().definitions().materials().logicProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)})));
        ThEApi.instance().items().diffusionCore().maybeStack(2).ifPresent(stack -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "diffusion_core"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "DIGISENTIA@2", 10, new AspectList(), stack, new Object[]{"SSS", "QFL", "SSS", Character.valueOf('S'), new ItemStack(ItemsTC.nuggets, 1, 5), Character.valueOf('Q'), Ingredient.func_193369_a((ItemStack[])netherQuartz.toArray(new ItemStack[0])), Character.valueOf('F'), AEApi.instance().definitions().materials().fluixDust().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('L'), AEApi.instance().definitions().materials().logicProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)})));
        ThEApi.instance().items().essentiaComponent1k().maybeStack(1).ifPresent(stack -> {
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_component_1k"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "ESSENTIASTORAGE1k@2", 10, new AspectList(), stack, new Object[]{"SQS", "QPQ", "SQS", Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('Q'), Ingredient.func_193369_a((ItemStack[])certusQuartz.toArray(new ItemStack[0])), Character.valueOf('P'), AEApi.instance().definitions().materials().logicProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)}));
            this.addFakeCrafting(new ResourceLocation("thaumicenergistics", "cells/essentia_cell_1k"));
        });
        ThEApi.instance().items().essentiaComponent4k().maybeStack(1).ifPresent(stack -> {
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_component_4k"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "ESSENTIASTORAGE4k@2", 10, new AspectList(), stack, new Object[]{"SPS", "CGC", "SCS", Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('C'), ThEApi.instance().items().essentiaComponent1k().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('P'), AEApi.instance().definitions().materials().calcProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('G'), AEApi.instance().definitions().blocks().quartzGlass().maybeBlock().orElse(Blocks.field_150359_w)}));
            this.addFakeCrafting(new ResourceLocation("thaumicenergistics", "cells/essentia_cell_4k"));
        });
        ThEApi.instance().items().essentiaComponent16k().maybeStack(1).ifPresent(stack -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_component_16k"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "ESSENTIASTORAGE16k@2", 10, new AspectList(), stack, new Object[]{"SPS", "CGC", "SCS", Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('C'), ThEApi.instance().items().essentiaComponent4k().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('P'), AEApi.instance().definitions().materials().engProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('G'), AEApi.instance().definitions().blocks().quartzGlass().maybeBlock().orElse(Blocks.field_150359_w)})));
        ThEApi.instance().items().essentiaComponent64k().maybeStack(1).ifPresent(stack -> {
            ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_component_64k"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "ESSENTIASTORAGE64k@2", 10, new AspectList(), stack, new Object[]{"SPS", "CGC", "SCS", Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('C'), ThEApi.instance().items().essentiaComponent16k().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('P'), AEApi.instance().definitions().materials().engProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('G'), AEApi.instance().definitions().blocks().quartzGlass().maybeBlock().orElse(Blocks.field_150359_w)}));
            this.addFakeCrafting(new ResourceLocation("thaumicenergistics", "cells/essentia_cell_64k"));
        });
        ThEApi.instance().items().essentiaExportBus().maybeStack(1).ifPresent(stack -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_export_bus"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "ESSENTIABUSES@2", 20, new AspectList(), stack, new Object[]{"ICI", "STS", Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('C'), ThEApi.instance().items().coalescenceCore().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('I'), "ingotIron", Character.valueOf('T'), BlocksTC.tube})));
        ThEApi.instance().items().essentiaImportBus().maybeStack(1).ifPresent(stack -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_import_bus"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "ESSENTIABUSES@2", 20, new AspectList(), stack, new Object[]{"SCS", "ITI", Character.valueOf('S'), ItemsTC.salisMundus, Character.valueOf('C'), ThEApi.instance().items().diffusionCore().maybeStack(1).orElse(ItemStack.field_190927_a), Character.valueOf('I'), "ingotIron", Character.valueOf('T'), BlocksTC.tube})));
        ThEApi.instance().items().essentiaStorageBus().maybeItem().ifPresent(item -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_storage_bus"), (IArcaneRecipe)new ShapelessArcaneRecipe(recipeGroup, "ESSENTIABUSES@2", 20, new AspectList(), item, new Object[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{AEApi.instance().definitions().blocks().iface().maybeStack(1).orElse(ItemStack.field_190927_a), AEApi.instance().definitions().parts().iface().maybeStack(1).orElse(ItemStack.field_190927_a)}), Blocks.field_150331_J, Blocks.field_150320_F, ItemsTC.salisMundus})));
        ThEApi.instance().items().essentiaTerminal().maybeItem().ifPresent(essentia -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "essentia_terminal"), (IArcaneRecipe)new ShapelessArcaneRecipe(recipeGroup, "ESSENTIATERMINAL@2", 25, new AspectList(), essentia, new Object[]{ItemsTC.salisMundus, ThEApi.instance().items().diffusionCore().maybeStack(1).orElse(ItemStack.field_190927_a), ThEApi.instance().items().coalescenceCore().maybeStack(1).orElse(ItemStack.field_190927_a), AEApi.instance().definitions().materials().logicProcessor().maybeStack(1).orElse(ItemStack.field_190927_a), "itemIlluminatedPanel"})));
        ThEApi.instance().items().arcaneTerminal().maybeItem().ifPresent(arcane -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "arcane_terminal"), (IArcaneRecipe)new ShapelessArcaneRecipe(recipeGroup, "ARCANETERMINAL@2", 50, new AspectList(), arcane, new Object[]{AEApi.instance().definitions().parts().terminal().maybeStack(1).orElse(ItemStack.field_190927_a), BlocksTC.arcaneWorkbench, AEApi.instance().definitions().materials().calcProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)})));
        ThEApi.instance().items().arcaneInscriber().maybeItem().ifPresent(inscriber -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "arcane_inscriber"), (IArcaneRecipe)new ShapelessArcaneRecipe(recipeGroup, "ARCANEINSCRIBER@2", 50, new AspectList().add(Aspect.AIR, 1).add(Aspect.EARTH, 1).add(Aspect.FIRE, 1).add(Aspect.WATER, 1).add(Aspect.ORDER, 1).add(Aspect.ENTROPY, 1), inscriber, new Object[]{AEApi.instance().definitions().parts().patternTerminal().maybeStack(1).orElse(ItemStack.field_190927_a), BlocksTC.arcaneWorkbench, AEApi.instance().definitions().materials().engProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)})));
        ThEApi.instance().items().upgradeArcane().maybeItem().ifPresent(upgrade -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "upgrade_arcane"), (IArcaneRecipe)new ShapelessArcaneRecipe(recipeGroup, "ARCANETERMINAL@2&&WORKBENCHCHARGER", 25, new AspectList(), upgrade, new Object[]{AEApi.instance().definitions().materials().advCard().maybeStack(1).orElse(ItemStack.field_190927_a), BlocksTC.arcaneWorkbenchCharger})));
        ThEApi.instance().items().blankKnowledgeCore().maybeItem().ifPresent(core -> ThaumcraftApi.addArcaneCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "knowledge_core"), (IArcaneRecipe)new ShapedArcaneRecipe(recipeGroup, "KNOWLEDGECORE@2", 100, new AspectList().add(Aspect.EARTH, 1).add(Aspect.ORDER, 1).add(Aspect.WATER, 1), core, new Object[]{"GLG", "LBL", "GPG", Character.valueOf('G'), AEApi.instance().definitions().blocks().quartzVibrantGlass().maybeBlock().orElse(Blocks.field_150359_w), Character.valueOf('L'), "dyeBlue", Character.valueOf('B'), ItemsTC.brain, Character.valueOf('P'), AEApi.instance().definitions().materials().calcProcessor().maybeStack(1).orElse(ItemStack.field_190927_a)})));
    }

    private void registerInfusionRecipes() {
        ThEApi.instance().blocks().infusionProvider().maybeStack(1).ifPresent(stack -> ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "infusion_provider"), (InfusionRecipe)new InfusionRecipe("INFUSIONPROVIDER@2", stack, 2, new AspectList().add(Aspect.MECHANISM, 25).add(Aspect.MAGIC, 25).add(Aspect.EXCHANGE, 20), AEApi.instance().definitions().blocks().iface().maybeBlock().orElseThrow(() -> new NullPointerException("Missing interface block for recipe")), new Object[]{ThEApi.instance().items().coalescenceCore().maybeStack(1).orElse(ItemStack.field_190927_a), ItemsTC.salisMundus, ThEApi.instance().items().coalescenceCore().maybeStack(1).orElse(ItemStack.field_190927_a), ItemsTC.salisMundus})));
        ThEApi.instance().blocks().arcaneAssembler().maybeStack(1).ifPresent(stack -> ThaumcraftApi.addInfusionCraftingRecipe((ResourceLocation)new ResourceLocation("thaumicenergistics", "arcane_assembler"), (InfusionRecipe)new InfusionRecipe("ARCANEASSEMBLER@2", stack, 6, new AspectList().add(Aspect.CRAFT, 64).add(Aspect.EXCHANGE, 32).add(Aspect.AURA, 16).add(Aspect.MAGIC, 16).add(Aspect.METAL, 8).add(Aspect.CRYSTAL, 8), AEApi.instance().definitions().blocks().molecularAssembler().maybeBlock().orElseThrow(() -> new NullPointerException("Missing molecular assembler block for recipe")), new Object[]{ThEApi.instance().items().coalescenceCore().maybeStack(1).orElse(ItemStack.field_190927_a), TCUtil.getCrystalWithAspect(Aspect.AIR), TCUtil.getCrystalWithAspect(Aspect.WATER), ItemsTC.salisMundus, TCUtil.getCrystalWithAspect(Aspect.ENTROPY), ThEApi.instance().items().diffusionCore().maybeStack(1).orElse(ItemStack.field_190927_a), TCUtil.getCrystalWithAspect(Aspect.EARTH), TCUtil.getCrystalWithAspect(Aspect.FIRE), ItemsTC.salisMundus, TCUtil.getCrystalWithAspect(Aspect.ORDER)})));
    }

    private void addFakeCrafting(ResourceLocation resourceLocation) {
        IForgeRegistryEntry entry = ForgeUtil.getRegistryEntry(IRecipe.class, resourceLocation);
        Preconditions.checkNotNull((Object)entry);
        ThaumcraftApi.addFakeCraftingRecipe((ResourceLocation)entry.getRegistryName(), (Object)entry);
    }
}

