/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.jei;

import java.awt.Rectangle;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.inventory.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.ItemTCEssentiaContainer;
import thaumicenergistics.client.gui.part.GuiSharedEssentiaBus;
import thaumicenergistics.container.slot.SlotGhost;
import thaumicenergistics.container.slot.SlotGhostEssentia;
import thaumicenergistics.network.PacketHandler;
import thaumicenergistics.network.packets.PacketGhostEssentia;
import thaumicenergistics.util.ThELog;

public class GhostEssentiaHandler
implements IGhostIngredientHandler<GuiSharedEssentiaBus> {
    @Nonnull
    public <I> List<IGhostIngredientHandler.Target<I>> getTargets(@Nonnull GuiSharedEssentiaBus gui, @Nonnull I ingredient, boolean doStart) {
        Stream<IGhostIngredientHandler.Target<I>> essentiaContainers = this.getForEssentiaContainers(gui, ingredient);
        Stream<IGhostIngredientHandler.Target<I>> aspectList = this.getForAspectList(gui, ingredient);
        return Stream.concat(aspectList, essentiaContainers).collect(Collectors.toList());
    }

    private <I> Stream<IGhostIngredientHandler.Target<I>> getForEssentiaContainers(final GuiSharedEssentiaBus gui, I ingredient) {
        ItemStack itemStack;
        Item item;
        if (ingredient instanceof ItemStack && (item = (itemStack = (ItemStack)ingredient).func_77973_b()) instanceof ItemTCEssentiaContainer) {
            return gui.field_147002_h.field_75151_b.stream().filter(it -> it instanceof SlotGhostEssentia).filter(Slot::func_111238_b).filter(it -> {
                ItemTCEssentiaContainer essentiaContainer = (ItemTCEssentiaContainer)item;
                AspectList aspectList = essentiaContainer.getAspects(itemStack);
                return aspectList != null;
            }).map(it -> (SlotGhost)it).map(slot -> new IGhostIngredientHandler.Target<I>((SlotGhost)slot){
                final /* synthetic */ SlotGhost val$slot;
                {
                    this.val$slot = slotGhost;
                }

                @Nonnull
                public Rectangle getArea() {
                    return new Rectangle(gui.getGuiLeft() + this.val$slot.field_75223_e, gui.getGuiTop() + this.val$slot.field_75221_f, 17, 17);
                }

                public void accept(@Nonnull I ingredient) {
                    ItemStack itemStack = (ItemStack)ingredient;
                    Item item = itemStack.func_77973_b();
                    ItemTCEssentiaContainer essentiaContainer = (ItemTCEssentiaContainer)item;
                    AspectList aspectList = essentiaContainer.getAspects(itemStack);
                    if (aspectList != null) {
                        Aspect[] aspects = aspectList.getAspects();
                        Aspect aspect = aspects[0];
                        ThELog.debug("TC Essentia container: {}", aspect);
                        PacketHandler.sendToServer(new PacketGhostEssentia(aspect, this.val$slot.field_75222_d));
                    }
                }
            });
        }
        return Stream.empty();
    }

    private <I> Stream<IGhostIngredientHandler.Target<I>> getForAspectList(final GuiSharedEssentiaBus gui, I ingredient) {
        if (ingredient instanceof AspectList) {
            return gui.field_147002_h.field_75151_b.stream().filter(it -> it instanceof SlotGhostEssentia).filter(Slot::func_111238_b).map(it -> (SlotGhost)it).map(it -> new IGhostIngredientHandler.Target<I>((SlotGhost)it){
                final /* synthetic */ SlotGhost val$it;
                {
                    this.val$it = slotGhost;
                }

                @Nonnull
                public Rectangle getArea() {
                    return new Rectangle(gui.getGuiLeft() + this.val$it.field_75223_e, gui.getGuiTop() + this.val$it.field_75221_f, 17, 17);
                }

                public void accept(@Nonnull I ingredient) {
                    AspectList aspectList = (AspectList)ingredient;
                    Aspect aspect = aspectList.getAspects()[0];
                    PacketHandler.sendToServer(new PacketGhostEssentia(aspect, this.val$it.field_75222_d));
                }
            });
        }
        return Stream.empty();
    }

    public void onComplete() {
    }
}

