/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.tile;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import micdoodle8.mods.galacticraft.api.recipe.CompressorRecipes;
import micdoodle8.mods.galacticraft.api.recipe.ShapedRecipesGC;
import micdoodle8.mods.galacticraft.api.recipe.ShapelessOreRecipeGC;
import micdoodle8.mods.galacticraft.core.inventory.IInventoryDefaults;
import micdoodle8.mods.galacticraft.core.inventory.PersistantInventoryCrafting;
import micdoodle8.mods.galacticraft.core.tile.TileEntityAdvanced;
import micdoodle8.mods.galacticraft.core.util.ConfigManagerCore;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.miccore.Annotations;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.OreDictionary;

public class TileEntityIngotCompressor
extends TileEntityAdvanced
implements IInventoryDefaults,
ISidedInventory {
    public static final int PROCESS_TIME_REQUIRED = 200;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int processTicks = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int furnaceBurnTime = 0;
    @Annotations.NetworkedField(targetSide=Side.CLIENT)
    public int currentItemBurnTime = 0;
    private long ticks;
    private ItemStack producingStack = ItemStack.field_190927_a;
    public PersistantInventoryCrafting compressingCraftMatrix = new PersistantInventoryCrafting();
    public final Set<EntityPlayer> playersUsing = new HashSet<EntityPlayer>();
    private static Random random = new Random();

    public TileEntityIngotCompressor() {
        super("tile.machine.3.name");
        this.inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (!this.field_145850_b.field_72995_K) {
            boolean flag;
            boolean updateInv = false;
            boolean bl = flag = this.furnaceBurnTime > 0;
            if (this.furnaceBurnTime > 0) {
                --this.furnaceBurnTime;
            }
            if (this.furnaceBurnTime == 0 && this.canSmelt()) {
                ItemStack fuel = (ItemStack)this.getInventory().get(0);
                this.currentItemBurnTime = this.furnaceBurnTime = TileEntityFurnace.func_145952_a((ItemStack)fuel);
                if (this.furnaceBurnTime > 0) {
                    updateInv = true;
                    if (!fuel.func_190926_b()) {
                        fuel.func_190918_g(1);
                        if (fuel.func_190916_E() == 0) {
                            this.getInventory().set(0, (Object)fuel.func_77973_b().getContainerItem(fuel));
                        }
                    }
                }
            }
            if (this.furnaceBurnTime > 0 && this.canSmelt()) {
                ++this.processTicks;
                if (this.processTicks % 40 == 0 && this.processTicks > 100) {
                    this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187689_f, SoundCategory.BLOCKS, 0.3f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
                }
                if (this.processTicks == 200) {
                    this.processTicks = 0;
                    this.smeltItem();
                    updateInv = true;
                }
            } else {
                this.processTicks = 0;
            }
            if (flag != this.furnaceBurnTime > 0) {
                updateInv = true;
            }
            if (updateInv) {
                this.func_70296_d();
            }
        }
        ++this.ticks;
    }

    public void updateInput() {
        this.producingStack = CompressorRecipes.findMatchingRecipe(this.compressingCraftMatrix, this.field_145850_b);
    }

    private boolean canSmelt() {
        ItemStack itemstack = this.producingStack;
        if (itemstack.func_190926_b()) {
            return false;
        }
        if (((ItemStack)this.getInventory().get(1)).func_190926_b()) {
            return true;
        }
        if (!((ItemStack)this.getInventory().get(1)).func_77969_a(itemstack)) {
            return false;
        }
        int result = ((ItemStack)this.getInventory().get(1)).func_190916_E() + itemstack.func_190916_E();
        return result <= this.func_70297_j_() && result <= itemstack.func_77976_d();
    }

    public static boolean isItemCompressorInput(ItemStack stack) {
        for (IRecipe recipe : CompressorRecipes.getRecipeList()) {
            if (recipe instanceof ShapedRecipesGC) {
                for (ItemStack itemstack1 : ((ShapedRecipesGC)recipe).recipeItems) {
                    if (stack.func_77973_b() != itemstack1.func_77973_b() || itemstack1.func_77952_i() != Short.MAX_VALUE && stack.func_77952_i() != itemstack1.func_77952_i()) continue;
                    return true;
                }
                continue;
            }
            if (!(recipe instanceof ShapelessOreRecipeGC)) continue;
            ArrayList<Object> required = new ArrayList<Object>(((ShapelessOreRecipeGC)recipe).getInput());
            Iterator<Object> req = required.iterator();
            int match = 0;
            block2: while (req.hasNext()) {
                Object next = req.next();
                if (next instanceof ItemStack) {
                    if (!OreDictionary.itemMatches((ItemStack)((ItemStack)next), (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue;
                }
                if (!(next instanceof List)) continue;
                for (ItemStack itemStack : (List)next) {
                    if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)stack, (boolean)false)) continue;
                    ++match;
                    continue block2;
                }
            }
            if (match == 0) continue;
            if (match == 1) {
                return true;
            }
            return random.nextInt(match) == 0;
        }
        return false;
    }

    private void smeltItem() {
        if (this.canSmelt()) {
            ItemStack resultItemStack = this.producingStack;
            if (ConfigManagerCore.quickMode && resultItemStack.func_77973_b().func_77667_c(resultItemStack).contains("compressed")) {
                resultItemStack.func_190917_f(resultItemStack.func_190916_E());
            }
            if (((ItemStack)this.getInventory().get(1)).func_190926_b()) {
                this.getInventory().set(1, (Object)resultItemStack.func_77946_l());
            } else if (((ItemStack)this.getInventory().get(1)).func_77969_a(resultItemStack)) {
                if (((ItemStack)this.getInventory().get(1)).func_190916_E() + resultItemStack.func_190916_E() > 64) {
                    resultItemStack.func_190917_f(((ItemStack)this.getInventory().get(1)).func_190916_E() - 64);
                    GCCoreUtil.spawnItem(this.field_145850_b, this.func_174877_v(), resultItemStack);
                    ((ItemStack)this.getInventory().get(1)).func_190920_e(64);
                } else {
                    ((ItemStack)this.getInventory().get(1)).func_190917_f(resultItemStack.func_190916_E());
                }
            }
            for (int i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
                if (!this.compressingCraftMatrix.func_70301_a(i).func_190926_b() && this.compressingCraftMatrix.func_70301_a(i).func_77973_b() == Items.field_151131_as) {
                    this.compressingCraftMatrix.setInventorySlotContentsNoUpdate(i, new ItemStack(Items.field_151133_ar));
                    continue;
                }
                this.compressingCraftMatrix.func_70298_a(i, 1);
            }
            this.updateInput();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.processTicks = nbt.func_74762_e("smeltingTicks");
        NBTTagList var2 = nbt.func_150295_c("Items", 10);
        this.inventory = NonNullList.func_191197_a((int)(this.func_70302_i_() - this.compressingCraftMatrix.func_70302_i_()), (Object)ItemStack.field_190927_a);
        NBTTagList nbttaglist = nbt.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j >= 0 && j < this.getInventory().size()) {
                this.getInventory().set(j, (Object)new ItemStack(nbttagcompound));
                continue;
            }
            if (j >= this.getInventory().size() + this.compressingCraftMatrix.func_70302_i_()) continue;
            this.compressingCraftMatrix.func_70299_a(j - this.getInventory().size(), new ItemStack(nbttagcompound));
        }
        this.updateInput();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        NBTTagCompound tagCompound;
        int i;
        super.func_189515_b(nbt);
        nbt.func_74768_a("smeltingTicks", this.processTicks);
        NBTTagList var2 = new NBTTagList();
        for (i = 0; i < this.getInventory().size(); ++i) {
            if (((ItemStack)this.getInventory().get(i)).func_190926_b()) continue;
            tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)i);
            ((ItemStack)this.getInventory().get(i)).func_77955_b(tagCompound);
            var2.func_74742_a((NBTBase)tagCompound);
        }
        for (i = 0; i < this.compressingCraftMatrix.func_70302_i_(); ++i) {
            if (this.compressingCraftMatrix.func_70301_a(i).func_190926_b()) continue;
            tagCompound = new NBTTagCompound();
            tagCompound.func_74774_a("Slot", (byte)(i + this.getInventory().size()));
            this.compressingCraftMatrix.func_70301_a(i).func_77955_b(tagCompound);
            var2.func_74742_a((NBTBase)tagCompound);
        }
        nbt.func_74782_a("Items", (NBTBase)var2);
        return nbt;
    }

    @Override
    protected boolean handleInventory() {
        return false;
    }

    @Override
    public int func_70302_i_() {
        return super.func_70302_i_() + this.compressingCraftMatrix.func_70302_i_();
    }

    @Override
    public ItemStack func_70301_a(int par1) {
        if (par1 >= this.getInventory().size()) {
            return this.compressingCraftMatrix.func_70301_a(par1 - this.getInventory().size());
        }
        return (ItemStack)this.getInventory().get(par1);
    }

    @Override
    public ItemStack func_70298_a(int par1, int par2) {
        if (par1 >= this.getInventory().size()) {
            ItemStack result = this.compressingCraftMatrix.func_70298_a(par1 - this.getInventory().size(), par2);
            if (!result.func_190926_b()) {
                this.updateInput();
            }
            this.func_70296_d();
            return result;
        }
        if (!((ItemStack)this.getInventory().get(par1)).func_190926_b()) {
            if (((ItemStack)this.getInventory().get(par1)).func_190916_E() <= par2) {
                ItemStack var3 = (ItemStack)this.getInventory().get(par1);
                this.getInventory().set(par1, (Object)ItemStack.field_190927_a);
                this.func_70296_d();
                return var3;
            }
            ItemStack var3 = ((ItemStack)this.getInventory().get(par1)).func_77979_a(par2);
            if (((ItemStack)this.getInventory().get(par1)).func_190926_b()) {
                this.getInventory().set(par1, (Object)ItemStack.field_190927_a);
            }
            this.func_70296_d();
            return var3;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack func_70304_b(int par1) {
        if (par1 >= this.getInventory().size()) {
            this.func_70296_d();
            return this.compressingCraftMatrix.func_70304_b(par1 - this.getInventory().size());
        }
        if (!((ItemStack)this.getInventory().get(par1)).func_190926_b()) {
            ItemStack var2 = (ItemStack)this.getInventory().get(par1);
            this.getInventory().set(par1, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            return var2;
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void func_70299_a(int par1, ItemStack stack) {
        if (par1 >= this.getInventory().size()) {
            this.compressingCraftMatrix.func_70299_a(par1 - this.getInventory().size(), stack);
            this.updateInput();
        } else {
            this.getInventory().set(par1, (Object)stack);
            if (!stack.func_190926_b() && stack.func_190916_E() > this.func_70297_j_()) {
                stack.func_190920_e(this.func_70297_j_());
            }
        }
        this.func_70296_d();
    }

    @Override
    public boolean func_191420_l() {
        for (ItemStack itemstack : this.getInventory()) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_175625_s(this.func_174877_v()) == this && par1EntityPlayer.func_70092_e((double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 0.5, (double)this.func_174877_v().func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public boolean func_94041_b(int slotID, ItemStack itemStack) {
        if (slotID == 0) {
            return TileEntityFurnace.func_145952_a((ItemStack)itemStack) > 0;
        }
        if (slotID >= 2) {
            if (!this.producingStack.func_190926_b()) {
                ItemStack stackInSlot = this.func_70301_a(slotID);
                return !stackInSlot.func_190926_b() && stackInSlot.func_77969_a(itemStack);
            }
            return TileEntityIngotCompressor.isItemCompressorInput(itemStack);
        }
        return false;
    }

    public int[] func_180463_a(EnumFacing side) {
        if (side == EnumFacing.DOWN) {
            return new int[]{1};
        }
        int[] slots = new int[]{0, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        ArrayList<Integer> removeSlots = new ArrayList<Integer>();
        block0: for (int i = 2; i < 11; ++i) {
            ItemStack stack1;
            if (removeSlots.contains(i) || (stack1 = this.func_70301_a(i)).func_190926_b()) continue;
            for (int j = i + 1; j < 11; ++j) {
                ItemStack stack2;
                if (removeSlots.contains(j) || (stack2 = this.func_70301_a(j)).func_190926_b() || !stack1.func_77969_a(stack2)) continue;
                if (stack2.func_190916_E() >= stack1.func_190916_E()) {
                    removeSlots.add(j);
                    continue block0;
                }
                removeSlots.add(i);
                continue block0;
            }
        }
        if (removeSlots.size() > 0) {
            int[] returnSlots = new int[slots.length - removeSlots.size()];
            int j = 0;
            for (int i = 0; i < slots.length; ++i) {
                if (i > 0 && removeSlots.contains(slots[i])) continue;
                returnSlots[j] = slots[i];
                ++j;
            }
            return returnSlots;
        }
        return slots;
    }

    @Override
    public boolean func_180462_a(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return this.func_94041_b(slotID, par2ItemStack);
    }

    @Override
    public boolean func_180461_b(int slotID, ItemStack par2ItemStack, EnumFacing par3) {
        return slotID == 1;
    }

    @Override
    public double getPacketRange() {
        return 12.0;
    }

    @Override
    public int getPacketCooldown() {
        return 3;
    }

    @Override
    public boolean isNetworkedTile() {
        return true;
    }
}

