/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.mars;

import micdoodle8.mods.galacticraft.api.event.wgen.GCCoreEventPopulate;
import micdoodle8.mods.galacticraft.api.tile.IFuelDock;
import micdoodle8.mods.galacticraft.api.tile.ILandingPadAttachable;
import micdoodle8.mods.galacticraft.core.GCBlocks;
import micdoodle8.mods.galacticraft.core.blocks.BlockMulti;
import micdoodle8.mods.galacticraft.core.client.render.entities.RenderPlayerGC;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.event.EventHandlerGC;
import micdoodle8.mods.galacticraft.core.event.EventLandingPadRemoval;
import micdoodle8.mods.galacticraft.core.event.EventWakePlayer;
import micdoodle8.mods.galacticraft.core.tile.TileEntityMulti;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.mars.blocks.BlockMachineMars;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import micdoodle8.mods.galacticraft.planets.mars.dimension.WorldProviderMars;
import micdoodle8.mods.galacticraft.planets.mars.entities.EntitySlimeling;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityCryogenicChamber;
import micdoodle8.mods.galacticraft.planets.mars.tile.TileEntityLaunchController;
import micdoodle8.mods.galacticraft.planets.mars.world.gen.WorldGenEggs;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import net.minecraft.world.gen.feature.WorldGenerator;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

public class EventHandlerMars {
    private WorldGenerator eggGenerator;

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        EntityDamageSource source;
        if (event.getSource().field_76373_n.equals("slimeling") && event.getSource() instanceof EntityDamageSource && (source = (EntityDamageSource)event.getSource()).func_76346_g() instanceof EntitySlimeling && !source.func_76346_g().field_70170_p.field_72995_K) {
            ++((EntitySlimeling)source.func_76346_g()).kills;
        }
    }

    @SubscribeEvent
    public void onLivingAttacked(LivingAttackEvent event) {
        EntitySlimeling entitywolf;
        Entity entity;
        if (event.getEntity().func_180431_b(event.getSource()) || event.getEntity().field_70170_p.field_72995_K || !(event.getEntityLiving().func_110143_aJ() <= 0.0f) || event.getSource().func_76347_k() && event.getEntityLiving().func_70644_a(MobEffects.field_76426_n) || !((entity = event.getSource().func_76346_g()) instanceof EntitySlimeling) || (entitywolf = (EntitySlimeling)entity).func_70909_n()) {
            // empty if block
        }
    }

    @SubscribeEvent
    public void onPlayerWakeUp(EventWakePlayer event) {
        EntityPlayer player = event.getEntityPlayer();
        BlockPos c = player.field_71081_bT;
        IBlockState state = player.func_130014_f_().func_180495_p(c);
        Block blockID = state.func_177230_c();
        if (blockID == MarsBlocks.machine && state.func_177229_b(BlockMachineMars.TYPE) == BlockMachineMars.EnumMachineType.CRYOGENIC_CHAMBER) {
            if (!event.immediately && event.updateWorld && event.setSpawn) {
                event.result = EntityPlayer.SleepResult.NOT_POSSIBLE_HERE;
            } else if (!event.immediately && !event.updateWorld && event.setSpawn && !player.field_70170_p.field_72995_K) {
                player.func_70691_i(5.0f);
                GCPlayerStats.get((Entity)player).setCryogenicChamberCooldown(6000);
                WorldServer ws = (WorldServer)player.field_70170_p;
                ws.func_72854_c();
                if (ws.func_73056_e() && ws.func_82736_K().func_82766_b("doDaylightCycle")) {
                    WorldUtil.setNextMorning((WorldServer)ws);
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onPlayerRotate(RenderPlayerGC.RotatePlayerEvent event) {
        BlockPos blockPos = event.getEntityPlayer().field_71081_bT;
        if (blockPos != null) {
            TileEntity tile;
            IBlockState state = event.getEntityPlayer().field_70170_p.func_180495_p(blockPos);
            if (state.func_177230_c() == GCBlocks.fakeBlock && state.func_177229_b((IProperty)BlockMulti.MULTI_TYPE) == BlockMulti.EnumBlockMultiType.CRYO_CHAMBER && (tile = event.getEntityPlayer().field_70170_p.func_175625_s(blockPos)) instanceof TileEntityMulti) {
                state = event.getEntityPlayer().field_70170_p.func_180495_p(((TileEntityMulti)tile).mainBlockPosition);
            }
            if (state.func_177230_c() == MarsBlocks.machine && state.func_177229_b(BlockMachineMars.TYPE) == BlockMachineMars.EnumMachineType.CRYOGENIC_CHAMBER) {
                event.shouldRotate = true;
                event.vanillaOverride = true;
            }
        }
    }

    @SubscribeEvent
    public void onPlanetDecorated(GCCoreEventPopulate.Post event) {
        if (this.eggGenerator == null) {
            this.eggGenerator = new WorldGenEggs(MarsBlocks.rock);
        }
        if (event.world.field_73011_w instanceof WorldProviderMars) {
            int eggsPerChunk = 2;
            for (int eggCount = 0; eggCount < eggsPerChunk; ++eggCount) {
                BlockPos blockpos = event.pos.func_177982_a(event.rand.nextInt(16) + 8, event.rand.nextInt(104) + 24, event.rand.nextInt(16) + 8);
                this.eggGenerator.func_180709_b(event.world, event.rand, blockpos);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void orientCamera(EventHandlerGC.OrientCameraEvent event) {
        EntityPlayerSP entity = Minecraft.func_71410_x().field_71439_g;
        if (entity != null) {
            int z;
            int y;
            int x = MathHelper.func_76128_c((double)entity.field_70165_t);
            TileEntity tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(new BlockPos(x, (y = MathHelper.func_76128_c((double)entity.field_70163_u)) - 1, z = MathHelper.func_76128_c((double)entity.field_70161_v)));
            if (tile instanceof TileEntityMulti) {
                tile = ((TileEntityMulti)tile).getMainBlockTile();
            }
            if (tile instanceof TileEntityCryogenicChamber) {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                switch (tile.func_145832_p() & 3) {
                    case 0: {
                        GL11.glTranslatef((float)-0.4f, (float)-0.5f, (float)4.1f);
                        break;
                    }
                    case 1: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)4.1f);
                        break;
                    }
                    case 2: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)4.1f);
                        break;
                    }
                    case 3: {
                        GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)4.1f);
                    }
                }
                GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glRotatef((float)(FMLClientHandler.instance().getClientPlayerEntity().field_71076_b - 50), (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glTranslatef((float)0.0f, (float)0.3f, (float)0.0f);
            }
        }
    }

    @SubscribeEvent
    public void onLandingPadRemoved(EventLandingPadRemoval event) {
        TileEntity tile = event.world.func_175625_s(event.pos);
        if (tile instanceof IFuelDock) {
            IFuelDock dock = (IFuelDock)tile;
            for (ILandingPadAttachable connectedTile : dock.getConnectedTiles()) {
                if (!(connectedTile instanceof TileEntityLaunchController)) continue;
                TileEntityLaunchController launchController = (TileEntityLaunchController)connectedTile;
                if (!(launchController.getEnergyStoredGC() > 0.0f) || !launchController.launchPadRemovalDisabled || launchController.getDisabled(0)) break;
                event.allow = false;
                return;
            }
        }
    }
}

