/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.planets.asteroids.tick;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import micdoodle8.mods.galacticraft.api.vector.BlockVec3;
import micdoodle8.mods.galacticraft.core.entities.player.GCPlayerStats;
import micdoodle8.mods.galacticraft.core.util.CompatibilityManager;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import micdoodle8.mods.galacticraft.core.util.GCLog;
import micdoodle8.mods.galacticraft.core.util.WorldUtil;
import micdoodle8.mods.galacticraft.planets.asteroids.dimension.ShortRangeTelepadHandler;
import micdoodle8.mods.galacticraft.planets.asteroids.entities.EntityAstroMiner;
import micdoodle8.mods.galacticraft.planets.asteroids.tile.TileEntityMinerBase;
import net.minecraft.entity.Entity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class AsteroidsTickHandlerServer {
    public static ShortRangeTelepadHandler spaceRaceData = null;
    public static List<EntityAstroMiner> activeMiners = new ArrayList<EntityAstroMiner>();
    public static AtomicBoolean loadingSavedChunks = new AtomicBoolean();
    private static Field droppedChunks = null;

    public static void restart() {
        spaceRaceData = null;
        activeMiners.clear();
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server = FMLCommonHandler.instance().getMinecraftServerInstance();
        if (server == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.START) {
            WorldServer world;
            TileEntityMinerBase.checkNewMinerBases();
            if (spaceRaceData == null && (spaceRaceData = (ShortRangeTelepadHandler)(world = server.func_71218_a(0)).func_175693_T().func_75742_a(ShortRangeTelepadHandler.class, "ShortRangeTelepads")) == null) {
                spaceRaceData = new ShortRangeTelepadHandler("ShortRangeTelepads");
                world.func_175693_T().func_75745_a("ShortRangeTelepads", (WorldSavedData)spaceRaceData);
            }
            int index = -1;
            for (EntityAstroMiner miner : activeMiners) {
                BlockVec3 data;
                GCPlayerStats stats;
                ++index;
                if (miner.field_70128_L || miner.playerMP == null || (stats = GCPlayerStats.get((Entity)miner.playerMP)) == null) continue;
                List list = stats.getActiveAstroMinerChunks();
                boolean inListAlready = false;
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    data = (BlockVec3)it.next();
                    if (data.sideDoneBits != index) continue;
                    if (miner.field_70128_L) {
                        it.remove();
                    } else {
                        data.x = miner.field_70176_ah;
                        data.z = miner.field_70164_aj;
                    }
                    inListAlready = true;
                    break;
                }
                if (inListAlready) continue;
                data = new BlockVec3(miner.field_70176_ah, miner.field_71093_bK, miner.field_70164_aj);
                data.sideDoneBits = index;
                list.add(data);
            }
        }
    }

    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent event) {
        block7: {
            block6: {
                if (event.phase != TickEvent.Phase.START) break block6;
                for (EntityAstroMiner miner : activeMiners) {
                    if (miner.playerMP == null || miner.field_70170_p != event.world || miner.field_70128_L) continue;
                    miner.serverTick = true;
                    miner.serverTickSave = miner.field_70173_aa;
                }
                break block7;
            }
            if (event.phase != TickEvent.Phase.END) break block7;
            for (EntityAstroMiner miner : activeMiners) {
                if (miner.field_70128_L || miner.playerMP == null || miner.field_70170_p != event.world) continue;
                if (miner.serverTick) {
                    miner.field_70173_aa = miner.serverTickSave + 1;
                    miner.func_70071_h_();
                }
                try {
                    if (droppedChunks == null) {
                        Class<?> clazz = ((WorldServer)miner.field_70170_p).func_72863_F().getClass();
                        droppedChunks = clazz.getDeclaredField(GCCoreUtil.isDeobfuscated() ? "droppedChunksSet" : "field_73248_b");
                        droppedChunks.setAccessible(true);
                    }
                    Set undrop = (Set)droppedChunks.get(((WorldServer)miner.field_70170_p).func_72863_F());
                    undrop.remove(ChunkPos.func_77272_a((int)miner.field_70176_ah, (int)miner.field_70164_aj));
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void removeChunkData(GCPlayerStats stats, EntityAstroMiner entityToRemove) {
        int index = 0;
        for (EntityAstroMiner miner : activeMiners) {
            if (miner == entityToRemove) {
                List list = stats.getActiveAstroMinerChunks();
                Iterator it = list.iterator();
                while (it.hasNext()) {
                    BlockVec3 data = (BlockVec3)it.next();
                    if (data.sideDoneBits != index) continue;
                    it.remove();
                    return;
                }
                return;
            }
            ++index;
        }
    }

    public static void loadAstroChunkList(List<BlockVec3> activeChunks) {
        LinkedList<BlockVec3> copyList = new LinkedList<BlockVec3>(activeChunks);
        activeChunks.clear();
        if (!loadingSavedChunks.getAndSet(true)) {
            for (BlockVec3 data : copyList) {
                WorldProvider p = WorldUtil.getProviderForDimensionServer((int)data.y);
                if (p == null || p.field_76579_a == null) continue;
                GCLog.debug((String)("Loading chunk " + data.y + ": " + data.x + "," + data.z + " - should contain a miner!"));
                WorldServer w = (WorldServer)p.field_76579_a;
                boolean previous = CompatibilityManager.forceLoadChunks((WorldServer)w);
                w.func_72863_F().func_186028_c(data.x, data.z);
                CompatibilityManager.forceLoadChunksEnd((WorldServer)w, (boolean)previous);
            }
            loadingSavedChunks.set(false);
        }
    }

    public static int monitorMiner(EntityAstroMiner entityAstroMiner) {
        int result = activeMiners.size();
        activeMiners.add(entityAstroMiner);
        GCLog.debug((String)("Monitoring miner " + result));
        return result;
    }
}

