#version 330 compatibility
#extension GL_ARB_gpu_shader5 : enable

/*
 _______ _________ _______  _______  _
(  ____ \\__   __/(  ___  )(  ____ )( )
| (    \/   ) (   | (   ) || (    )|| |
| (_____    | |   | |   | || (____)|| |
(_____  )   | |   | |   | ||  _____)| |
      ) |   | |   | |   | || (      (_)
/\____) |   | |   | (___) || )       _
\_______)   )_(   (_______)|/       (_)

Do not modify this code until you have read the LICENSE.txt contained in the root directory of this shaderpack!

*/


#include "lib/Uniforms.inc"
#include "lib/Common.inc"



/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////CONFIGURABLE VARIABLES////////////////////////////////////////////////////////////////////////////////////////////////////////////////////



/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////END OF CONFIGURABLE VARIABLES/////////////////////////////////////////////////////////////////////////////////////////////////////////////



in vec4 texcoord;
in vec3 lightVector;


in float timeSunriseSunset;
in float timeNoon;
in float timeMidnight;

in vec3 colorSunlight;
in vec3 colorSkylight;

in float avgSkyBrightness;

#define COLOR_TEX colortex1

const float overlap = 1.9;

const float rgOverlap = 0.1 * overlap;
const float rbOverlap = 0.03 * overlap;
const float gbOverlap = 0.04 * overlap;

const mat3 coneOverlap = mat3(1.0, 			rgOverlap, 	rbOverlap,
							  rgOverlap, 	1.0, 		gbOverlap,
							  rbOverlap, 	rgOverlap, 	1.0);

const mat3 coneOverlapInverse = mat3(	1.0 + (rgOverlap + rbOverlap), 			-rgOverlap, 	-rbOverlap,
									  	-rgOverlap, 		1.0 + (rgOverlap + gbOverlap), 		-gbOverlap,
									  	-rbOverlap, 		-rgOverlap, 	1.0 + (rbOverlap + rgOverlap));

// ACES
const mat3 ACESInputMat = mat3(
    0.59719, 0.35458, 0.04823,
    0.07600, 0.90834, 0.01566,
    0.02840, 0.13383, 0.83777
);

const mat3 ACESOutputMat = mat3(
     1.60475, -0.53108, -0.07367,
    -0.10208,  1.10813, -0.00605,
    -0.00327, -0.07276,  1.07602
);

vec3 Uncharted2Tonemap(vec3 x)
{
	x *= 3.0;

	// float A = 0.15;
	// float B = 0.50;
	// float C = 0.10;
	// float D = 0.20;
	// float E = 0.02;
	// float F = 0.30;

	float A = 0.9;
	float B = 0.8;
	float C = 0.1;
	float D = 1.0;
	float E = 0.02;
	float F = 0.30;

	// x = x * coneOverlap;

	x = ((x*(A*x+C*B)+D*E)/(x*(A*x+B)+D*F))-E/F;

	// x = x * coneOverlapInverse;

    return x;
}

float almostIdentity( float x, float m, float n )
{
    if( x>m ) return x;

    float a = 2.0*n - m;
    float b = 2.0*m - 3.0*n;
    float t = x/m;

    return (a*t + b)*t*t + n;
}

vec3 almostIdentity(vec3 x, vec3 m, vec3 n)
{
	return vec3(
		almostIdentity(x.x, m.x, n.x),
		almostIdentity(x.y, m.y, n.y),
		almostIdentity(x.z, m.z, n.z)
		);
}

vec3 BlackDepth(vec3 color, vec3 blackDepth)
{
	vec3 m = blackDepth;
	vec3 n = blackDepth * 0.5;
	return (almostIdentity(color, m, n) - n);// * (vec3(1.0) - n);
}

vec3 BurgessTonemap(vec3 col)
{
	col *= 0.9;
	// col = col * coneOverlap;

	vec3 maxCol = col;


    const float p = 1.0;
    maxCol = pow(maxCol, vec3(p));

    vec3 retCol = (maxCol * (6.2 * maxCol + 0.05)) / (maxCol * (6.2 * maxCol + 2.3) + 0.06);
	retCol = pow(retCol, vec3(1.0 / p));

	// retCol = retCol * coneOverlapInverse;

    return retCol;
}

vec3 SEUSTonemap(vec3 color)
{
	color *= 1.1;

	const float p = TONEMAP_CURVE;

	// color = color * coneOverlap;

	color = pow(color, vec3(p));
	color = color / (1.0 + color);
	// color = 1.0 - exp(-color);
	color = pow(color, vec3((1.0 / GAMMA) / p));


	// color = color * coneOverlapInverse;

		
	// color = 1.0 - pow(1.0 - pow(color, vec3(1.0)), vec3(3.5));
	// color = pow(color, vec3(1.1));

	{
		// color = color * color * (3.0 - 2.0 * color);
		// color = pow(color, vec3(0.7));
		const float a = 0.3;
		float l = a * a * (3.0 - 2.0 * a);

		vec3 c = color * (1.0 - a) + a;
		
		color = c * c * (3.0 - 2.0 * c);
		color -= l;
		color /= 1.0 - l;
		color = max(vec3(0.0), color);
		color = pow(color, vec3(1.0));
	}




	{
		vec3 c = color;
		color = mix(color, c * c * (3.0 - 2.0 * c), vec3(0.2));
		// color = pow(color, vec3(0.95));
	}


	return color;
}

vec3 ReinhardJodie(vec3 v)
{
	v = pow(v, vec3(TONEMAP_CURVE));
    float l = Luminance(v);
    vec3 tv = v / (1.0f + v);

    vec3 tonemapped = mix(v / (1.0f + l), tv, tv);
	tonemapped = pow(tonemapped, vec3(1.0 / TONEMAP_CURVE));

	return tonemapped;
}



/////////////////////////////////////////////////////////////////////////////////
//	ACES Fitting by Stephen Hill
vec3 RRTAndODTFit(vec3 v)
{
    vec3 a = v * (v + 0.0245786f) - 0.000090537f;
    vec3 b = v * (1.0f * v + 0.4329510f) + 0.238081f;
    return a / b;
}

vec3 ACESTonemap2(vec3 color)
{
	color *= 1.5;
	color = color * ACESInputMat;

    // Apply RRT and ODT
    color = RRTAndODTFit(color);


    // Clamp to [0, 1]
	color = color * ACESOutputMat;
    color = saturate(color);

    return color;
}
/////////////////////////////////////////////////////////////////////////////////





vec3 ACESTonemap(vec3 color)
{
	color *= 0.4;

		// color = color * coneOverlap;



		vec3 crosstalk = vec3(0.05, 0.2, 0.05) * 2.9;

		// float avgColor = (color.r + color.g + color.b) * 0.33333;
		float avgColor = Luminance(color.rgb);

		// color = mix(color, vec3(avgColor), crosstalk);


	const float p = 1.0;
	color = pow(color, vec3(p));
	color = (color * (2.51 * color + 0.03)) / (color * (2.43 * color + 0.59) + 0.14);
	// color = (color * (2.51 * color + 0.03)) / (color * (2.43 * color + 0.59) + 0.1);
	color = pow(color, vec3(1.0 / p));

		// color = color * coneOverlapInverse;


		// float avgColorTonemapped = (color.r + color.g + color.b) * 0.33333;
		float avgColorTonemapped = Luminance(color.rgb);

		// color = mix(color, vec3(avgColorTonemapped), -crosstalk * 1.0);


	color = saturate(color);

	color = pow(color, vec3(0.85));

	// color = mix(color, vec3(avgColorTonemapped), vec3(-saturate(avgColor * 0.25 + 0.0)));


	return color;
}

vec3 RGBToCIE(vec3 color)
{
	// return mat3(
	// 	0.4124564, 0.3575761, 0.1804375,
	// 	0.2126729, 0.7151522, 0.0721750,
	// 	0.0193339, 0.1191920, 0.9503041
	// ) * color;
	return vec3(
		dot(color, vec3(0.4124564, 0.3575761, 0.1804375)),
		dot(color, vec3(0.2126729, 0.7151522, 0.0721750)),
		dot(color, vec3(0.0193339, 0.1191920, 0.9503041))
	);
}

vec3 CIEToRGB(vec3 color)
{
	// return mat3(
	// 	3.2404542, -1.5371385, -0.4985314  ,
	// 	-0.9692660, 1.8760108, 0.0415560  ,
	// 	0.0556434, -0.2040259, 1.0572252
	// ) * color;
	return vec3(
		dot(color, vec3(3.2404542, -1.5371385, -0.4985314)),
		dot(color, vec3(-0.9692660, 1.8760108, 0.0415560 )),
		dot(color, vec3(0.0556434, -0.2040259, 1.0572252))
	);
}

float LogBase(float x, float base)
{
	return log(x) / log(base);
}

vec3 LogBase(vec3 x, float base)
{
	return log(x) / log(base);
}

vec3 LogarithmicTonemap(vec3 color)
{

	
	color *= 1.0;
	vec3 x = color;






	const vec3 t = vec3(1.5);
	const vec3 p = vec3(0.9);
	const vec3 b = vec3(1.1);

	x *= sqrt(b);
	color = p * (log(pow(x, t) + 1) / (log(pow(x, p) + b))) / t;
	
	return color;
	
	
	
	



















































}





void CalculateExposureEyeBrightness(inout vec3 color) 
{
	float exposureMax = 1.55f;
		  //exposureMax *= mix(1.0f, 0.25f, timeSunriseSunset);
		  //exposureMax *= mix(1.0f, 0.0f, timeMidnight);
		  //exposureMax *= mix(1.0f, 0.25f, rainStrength);
		  exposureMax *= avgSkyBrightness * 2.0;
	float exposureMin = 0.07f;
	float exposure = pow(eyeBrightnessSmooth.y / 240.0f, 6.0f) * exposureMax + exposureMin;

	//exposure = 1.0f;

	color.rgb /= vec3(exposure);
	color.rgb *= 350.0;
}



void 	Vignette(inout vec3 color) {
	float dist = distance(texcoord.st, vec2(0.5f)) * 2.0f;
		  dist /= 1.5142f;

		  //dist = pow(dist, 1.1f);

	color.rgb *= 1.0f - dist * 0.5;

}


void Overlay(inout vec3 color, vec3 overlayColor)
{
	vec3 overlay = vec3(0.0);

	for (int i = 0; i < 3; i++)
	{
		if (color[i] > 0.5)
		{
			float valueUnit = (1.0 - color[i]) / 0.5;
			float minValue = color[i] - (1.0 - color[i]);
			overlay[i] = (overlayColor[i] * valueUnit) + minValue;
		}
		else
		{
			float valueUnit = color[i] / 0.5;
			overlay[i] = overlayColor[i] * valueUnit;
		}
	}

	color = overlay;
}



vec3 ExponentialTonemap(vec3 c)
{
	// c = 1.0 - exp2(-c*1.3);
	
	const vec3 t = vec3(2.0);
	const vec3 p = vec3(10.5);
	
	c = 1.0 - pow((t*c + 1.0) * p, -c);

	return c;
}


vec3 Tonemap(vec3 color)
{

	
	// if (TOGGLER > 0.5)
	// {
	color *= coneOverlap;
		color = TONEMAP_OPERATOR(color);
	// // 	// color = (mix(color, vec3(Luminance(color)), vec3(-0.1)));
	// // 	// color = normalize(pow(color, vec3(1.3)) + 0.0000001) * length(color);
	color *= coneOverlapInverse;
	
		color = TransformOutputColor(color);
		return color;
	// }
	
	
	
	
	vec3 colorN = normalize(color + 0.000001);
	float colorSaturationIn = abs(colorN.r - colorN.g) + abs(colorN.r - colorN.b) + abs(colorN.g - colorN.b);
	colorSaturationIn += max(0.0, (colorN.g - colorN.r) - colorN.b) * 5.0; // Boost detection of greens (vs oranges)
	float brightColorFactorIn = colorSaturationIn * colorSaturationIn * dot(color, vec3(0.33333));
	float lumIn = Luminance(color);
	

	float tonemapMixRGBvsLum = exp(-brightColorFactorIn * 0.15);
	tonemapMixRGBvsLum *= saturate(lumIn);
	
	float crosstalk = 1.5;
	
	// if (texcoord.y < 0.3)
	// {
	// 	return color;
	// }
	
	// if (texcoord.x < 0.3)
	// {
	// 	tonemapMixRGBvsLum = 0.0;
	// 	crosstalk = 0.0;
	// }
	
	// if (texcoord.y < 0.2)
	// {
	// 	crosstalk = 0.0;
	// }
	
	// if (texcoord.x > 0.7)
	// {
	// 	crosstalk = 0.0;
	// 	tonemapMixRGBvsLum = 1.0;
	// }
	
	float greenInRed = 0.00;
	float blueInRed = 0.0005;
	
	float redInGreen = 0.02;
	float blueInGreen = 0.05;
	
	float redInBlue = 0.001;
	float greenInBlue = 0.00;
	

	// color *= coneOverlap;
	
	
	
	// crosstalk *= distance(color, vec3(Luminance(color))) * 0.3;
	// crosstalk *= distance(color, vec3(Luminance(color))) * 0.3;
	// crosstalk *= sqrt(distance(color, vec3(Luminance(color)))) * 0.3;
	
	crosstalk *= saturate(brightColorFactorIn * 0.1);
		
	color.r = color.r * (1.0			)  + color.g * (greenInRed * crosstalk) 						+ color.b * (blueInRed * crosstalk);
	color.g = color.r * (redInGreen * crosstalk) 									+ color.g * (1.0) 	+ color.b * (blueInGreen * crosstalk);
	color.b = color.r * (redInBlue * crosstalk) 								+ color.g * (greenInBlue * crosstalk) 						+ color.b * (1.0);
	
	vec3 lum = max(vec3(0.000001), mix(color, vec3(lumIn), vec3(saturate(tonemapMixRGBvsLum))));
	
	color /= lum;
	lum = TONEMAP_OPERATOR(lum);
	color *= lum;
	
	
	// if (texcoord.x < 0.3)
	// {
	// 	if (TOGGLER > 0.5)
	// 	{
	// 		// color = (mix(color, vec3(Luminance(color)), vec3(-0.4)));
	// 	}
	// }
	
	
	// if (texcoord.x > 0.9)
	// {
	// 	color *= 1.1;
	// }
	// color *= coneOverlapInverse;
	
	// crosstalk *= -1.0;
	
	// color.r = color.r * (1.0 - (greenInRed + blueInRed) * crosstalk			)  + color.g * (greenInRed * crosstalk) 						+ color.b * (blueInRed * crosstalk);
	// color.g = color.r * (redInGreen * crosstalk) 									+ color.g * (1.0 - (redInGreen + blueInGreen) * crosstalk) 	+ color.b * (blueInGreen * crosstalk);
	// color.b = color.r * (redInBlue * crosstalk) 								+ color.g * (greenInBlue * crosstalk) 						+ color.b * (1.0 - (redInBlue + greenInBlue) * crosstalk);
	
	color = TransformOutputColor(color);
	
	return color;






}

#include "lib/Bloom.inc"

#include "lib/FXAA.inc"

/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
void main() {


	vec3 color = 	(texture2D(COLOR_TEX, texcoord.st).rgb);



	
	color = GammaToLinear(color);
	vec3 bloom = texture2DLod(colortex7, texcoord.xy * 0.5, 0).rgb * 0.01;

	#ifndef SKIP_AA
	#if PIXEL_LOOK == 1
	{
		// const float s = 0.43;
		// vec3 mb = GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(s, s)).rgb)
		// 		  + GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(s, -s)).rgb)
		// 		  + GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(-s, s)).rgb)
		// 		  + GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(-s, -s)).rgb);

		// color = mix(color, mb * 0.25, vec3(0.999));

		float weightSum = 0.0;
		vec3 col = vec3(0.0);

		col += GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(0.0, 0.0)).rgb) * 1.0;
		col += GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(0.0, 1.0)).rgb);
		col += GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(1.0, 0.0)).rgb);
		col += GammaToLinear(texture2D(COLOR_TEX, texcoord.st + ScreenTexel * vec2(1.0, 1.0)).rgb);
		col /= 4.0;

		color = col;
	}
	#endif
	#endif

	float avgLum = GetAvgLum();
	// color = mix(color, bloom, vec3(0.06 * BLOOM_AMOUNT / (sqrt(sqrt(avgLum)) * 2.0 + 0.1) + saturate(isEyeInWater) * 0.8));
	// color = mix(color, bloom, vec3(0.06 * BLOOM_AMOUNT / (sqrt(avgLum) * 5.0 + 0.2) + saturate(isEyeInWater) * 0.8));
	float bloomAmount = 0.06 * BLOOM_AMOUNT;
	bloomAmount /= sqrt(avgLum) * 4.0 + 0.5;
	bloomAmount = mix(bloomAmount, 0.9, saturate(isEyeInWater));
	color = mix(color, bloom, vec3(bloomAmount));


	Vignette(color);

	color = BlackDepth(color, vec3(0.000015 * BLACK_DEPTH * BLACK_DEPTH));

	// if (TOGGLER > 0.5)
	// if (texcoord.x < 0.5)
	{
		color *= 2.0;

		vec3 oc = color;
		float PP = 3.0;
		color = pow(color, vec3(1.0 / PP));
		color = saturate(color - 0.001);
		color = pow(color, vec3(PP));

		float rL = 0.00000008;
		float rodExcitement = dot(oc, vec3(0.001, 0.3, 0.8));
		rodExcitement = rodExcitement*rL / (rL + rodExcitement);
		color += rodExcitement * vec3(0.2, 0.3, 0.4) * 5.0;

		color /= 2.0;
	}

	color = ApplyAutoExposure(color, avgLum);



 
	color *= pow(vec3(1.0, 1.07, 1.25), vec3(1.1));




	color *= EXPOSURE; 
	// color *= exp((sin(FRAME_TIME) * 0.5 + 0.5) * 4.0);

	float lumIn = Luminance(color);
	color = saturate(Tonemap(color) * (1.0 + WHITE_CLIP));



	color = pow(color, vec3(1.0 / 2.2 + (1.0 - GAMMA)));



	{

		color = (mix(color, vec3(Luminance(color)), vec3(1.0 - SATURATION)));
		
		// float satFactor = -(exp2(-lumIn * 2.0) - 1.0);
		// // if (TOGGLER > 0.5) {
		// 	satFactor = 0.1;
		// // }
		// color = normalize(pow(saturate(color), vec3(1.0 + satFactor)) + 0.000001) * length(color);










	}

	// color = (mix(color, vec3(Luminance(color)), vec3(
	// 	(-Luminance(color) * 0.4) + 0.1
	// 	)));

	// color = (mix(color, vec3(Luminance(color)), vec3(
	// 	(-Luminance(color) * 0.2) + 0.0
	// )));




	color += (BlueNoiseTemporal(texcoord.st) - 0.95) * (3.0 / 255.0);

	// color = mix(color, SampleeAMCZAKEcI(texcoord.xy).vyHfppOAPK * 3.0, vec3(0.9));

	// color = vec3(texture2DLod(colortex7, texcoord.st, 0).a);

	// color = texture2D(colortex6, texcoord.st).rgb * 12.0;
	// color = texture2D(colortex2, texcoord.st).rgb * 1.0;

	// color = vec3(texture2D(colortex2, texcoord.st).rgb) * 1.0;
	// color = vec3(texture2D(colortex4, texcoord.st).rgb) * 12.0;

	// color = vec3(texture2D(colortex1, texcoord.st).rgb) * 10.0;


	// if (TOGGLER > 0.5 && texcoord.x < 0.05)
	// {
	// 	color.r = 0.5;
	// }

	gl_FragData[0] = vec4(color.rgb, Luminance(color.rgb));
}


/* DRAWBUFFERS:0 */
