const int gaussian_kernel_size = 63;
const float gaussian_kernel[63] = float[](
   2.168404344971009e-19,
   1.3444106938820255e-17,
   4.100452616340178e-16,
   8.200905232680356e-15,
   1.2096335218203524e-13,
   1.4031748853116088e-12,
   1.3330161410460284e-11,
   1.0664129128368227e-10,
   7.331588775753156e-10,
   4.398953265451894e-9,
   2.3314452306895037e-8,
   1.1021377454168563e-7,
   4.684085418021639e-7,
   0.0000018015713146237074,
   0.000006305499601182976,
   0.000020177598723785523,
   0.00005927169625111997,
   0.00016038223691479522,
   0.00040095559228698805,
   0.000928528740033025,
   0.0019963367910710034,
   0.003992673582142008,
   0.007440891675810105,
   0.01294068117532192,
   0.02102860690989812,
   0.03196348250304515,
   0.04548649433125655,
   0.06064865910834208,
   0.07581082388542759,
   0.08888165558981166,
   0.09776982114879282,
   0.10092368634714097,
   0.09776982114879282,
   0.08888165558981166,
   0.07581082388542759,
   0.06064865910834208,
   0.04548649433125655,
   0.03196348250304515,
   0.02102860690989812,
   0.01294068117532192,
   0.007440891675810105,
   0.003992673582142008,
   0.0019963367910710034,
   0.000928528740033025,
   0.00040095559228698805,
   0.00016038223691479522,
   0.00005927169625111997,
   0.000020177598723785523,
   0.000006305499601182976,
   0.0000018015713146237074,
   4.684085418021639e-7,
   1.1021377454168563e-7,
   2.3314452306895037e-8,
   4.398953265451894e-9,
   7.331588775753156e-10,
   1.0664129128368227e-10,
   1.3330161410460284e-11,
   1.4031748853116088e-12,
   1.2096335218203524e-13,
   8.200905232680356e-15,
   4.100452616340178e-16,
   1.3444106938820255e-17,
   2.168404344971009e-19
);

vec3 gaussianHorizontal(sampler2D tex, vec2 fragUV) {
	vec3 color = vec3(0.0);
	for(int i = 0; i < gaussian_kernel_size; i++) {
		vec2 offset = pixelSize * vec2(i - floor(gaussian_kernel_size / 2.0), 0.0) * BLOOM_SIZE;
		color += texture2D(tex, fragUV + offset).rgb * gaussian_kernel[i];
	}
	return color;
}

vec3 gaussianVertical(sampler2D tex, vec2 fragUV) {
	vec3 color = vec3(0.0);
	for(int i = 0; i < gaussian_kernel_size; i++) {
		vec2 offset = pixelSize * vec2(0.0, i - floor(gaussian_kernel_size / 2.0)) * BLOOM_SIZE;
		color += texture2D(tex, fragUV + offset).rgb * gaussian_kernel[i];
	}
	return color;
}