#version 450 compatibility


out vec4 reflectionData;

#include "/lib/Head/Common.inc"
#include "/lib/Head/Uniforms.inc"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Material.inc"

#include "/lib/Head/Functions.inc"

#include "/lib/Surface/ReflectionFilter.glsl"

/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel = ivec2(gl_FragCoord.xy);
    reflectionData = texelFetch(colortex2, texel, 0);

	//#if !defined MC_SPECULAR_MAP
	//	if (wetnessCustom < 5e-3) return;
	//#endif

	Material material = GetMaterialData(texelFetch(colortex0, texel, 0).xy);

    if (material.hasReflections && reflectionData.a > 1e-3 && material.isRough) {
		vec3 normal = GetNormals(texel);
		vec3 viewDir = normalize(ScreenToViewSpace(vec3(texel * screenPixelSize, GetDepthT(texel))));
		reflectionData = ReflectionFilter(texel, reflectionData, material.roughness, normal, viewDir, 2.0, vec2(0.0));
	}
}

/* DRAWBUFFERS:2 */
