#version 450 compatibility

#define IS_OVERWORLD


layout(location = 0) out vec2 specularData;
layout(location = 1) out vec3 sceneData;


uniform sampler2DShadow shadowtex1;
uniform sampler2D shadowtex0;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;

in vec2 texcoord;

flat in vec3 colorSunlight;
flat in vec3 colorSkylight;
flat in vec3 colorTorchlight;

flat in vec4 skySHR;
flat in vec4 skySHG;
flat in vec4 skySHB;

//in vec3 worldLightVector;
//in vec3 worldSunVector;

#include "/lib/Head/Common.inc"
uniform sampler2D noisetex;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex3;
uniform sampler2D colortex6;
uniform sampler2D colortex7;

uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex2;

uniform float frameTimeCounter;
uniform float nightVision;
uniform float near;
uniform float far;
uniform float viewWidth;
uniform float viewHeight;
uniform float wetness;
uniform float wetnessCustom;
uniform float eyeAltitude;
uniform float eyeSkylightFix;
uniform float isLightningFlashing;
uniform float worldTimeCounter;

uniform vec3 cameraPosition;
uniform vec3 worldSunVector;
uniform vec3 worldLightVector;
uniform vec3 waterAbsorption;

uniform int frameCounter;
uniform int isEyeInWater;
uniform int heldItemId;
uniform int heldBlockLightValue;
uniform int heldItemId2;
uniform int heldBlockLightValue2;
uniform int moonPhase;

uniform bool cloudMoonlit;

uniform mat4 gbufferProjection;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferModelView;

uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;
uniform mat4 shadowModelView;

uniform vec2 screenPixelSize;
uniform vec2 screenSize;
uniform vec2 taaOffset;

#include "/lib/Atmosphere/Atmosphere.glsl"

/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////FUNCTIONS/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Functions.inc"

/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCTS///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Head/Material.inc"

#include "/lib/Head/Mask.inc"

/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////STRUCT FUNCTIONS//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

#include "/lib/Lighting/SunLighting.glsl"

//#include "/lib/Water/WaterFog.glsl"

#include "/lib/Atmosphere/VolumetricClouds.glsl"

#include "/lib/Atmosphere/PlanarClouds.glsl"

#ifdef GI_ENABLED
	vec4 SpatialFilter(in vec3 normal, in float dist, in float NdotV) {
		ivec2 texel = ivec2(gl_FragCoord.xy) / 2;

		float sumWeight = 0.1;
		vec4 light = texelFetch(colortex0, texel, 0) * sumWeight;

		for (uint i = 0u; i < 16u; ++i) {
			ivec2 offset = offset4x4[i];
			ivec2 sampleTexel = texel + offset * 2;
			if (clamp(sampleTexel, ivec2(1), ivec2(screenSize * 0.5) - 1) != sampleTexel) continue;

			vec4 prevData = texelFetch(colortex0, sampleTexel + ivec2(viewWidth * 0.5, 0), 0);

			float weight = exp2(-dotSelf(offset) * 0.1);
			weight *= exp2(-distance(prevData.w, dist) * 4.0 * NdotV); // Dist
			weight *= pow16(abs(dot(prevData.xyz, normal))); // Normal

			light += texelFetch(colortex0, sampleTexel, 0) * weight;
			sumWeight += weight;
		}

		light /= max(1e-6, sumWeight);
		//light.rgb = SRGBtoLinear(light.rgb);

		return light;
	}
#endif

#ifdef CLOUDS_SHADOW
	float CloudShadow(in vec3 worldPos, in CloudProperties cloudProperties) {
		float cloudDensity = 0.0;
		vec3 checkOrigin = worldPos + vec3(0.0, planetRadius, 0.0);
		#ifdef VC_SHADOW
			float checkRadius = planetRadius + cloudProperties.altitude;
			//vec3 checkPos = worldLightVector / abs(worldLightVector.y) * max0(cloudProperties.maxAltitude - abs(worldPos.y)) + worldPos;
			vec3 checkPos = RaySphereIntersection(checkOrigin, worldLightVector, checkRadius + 0.15 * cloudProperties.thickness).y * worldLightVector + worldPos;
			cloudDensity += CloudVolumeDensitySmooth(cloudProperties, checkPos);

			checkPos = RaySphereIntersection(checkOrigin, worldLightVector, checkRadius + 0.5 * cloudProperties.thickness).y * worldLightVector + worldPos;
			cloudDensity += CloudVolumeDensitySmooth(cloudProperties, checkPos);
			cloudDensity *= 2.0;
		#endif
		#ifdef PC_SHADOW
			vec2 checkPos1 = RaySphereIntersection(checkOrigin, worldLightVector, planetRadius + CLOUD_PLANE_ALTITUDE).y * worldLightVector.xz + worldPos.xz;
			cloudDensity += CloudPlanarDensity(checkPos1) * 20.0;
		#endif
		cloudDensity = mix(0.2, cloudDensity, saturate(sqr(abs(worldLightVector.y) * 2.0)));
		cloudDensity = mix(cloudDensity, 0.9, wetness * 0.5);

		return smoothstep(fma(-0.1, wetness, 0.3), 0.0, cloudDensity);
	}
#endif
/*
vec4 textureCatmullRom(in sampler2D tex, in vec2 coord) {
	vec2 res = textureSize(tex, 0);
	vec2 screenPixelSize = 1.0 / res;

	vec2 position = coord * res;
	vec2 centerPosition = floor(position - 0.5) + 0.5;

	vec2 f = position - centerPosition;

	vec2 w0 = f * (-0.5 + f * (1.0 - 0.5 * f));
	vec2 w1 = 1.0 + f * f * (-2.5 + 1.5 * f);
	vec2 w2 = f * (0.5 + f * (2.0 - 1.5 * f));
	vec2 w3 = f * f * (-0.5 + 0.5 * f);

	vec2 w12 = w1 + w2;

	vec2 tc0 = screenPixelSize * (centerPosition - 1.0);
	vec2 tc3 = screenPixelSize * (centerPosition + 2.0);
	vec2 tc12 = screenPixelSize * (centerPosition + w2 * rcp(w12));

	vec4 color = vec4(0.0);
	color += textureLod(tex, vec2(tc0.x, tc0.y), 0) * w0.x * w0.y;
	color += textureLod(tex, vec2(tc12.x, tc0.y), 0) * w12.x * w0.y;
	color += textureLod(tex, vec2(tc3.x, tc0.y), 0) * w3.x * w0.y;

	color += textureLod(tex, vec2(tc0.x, tc12.y), 0) * w0.x * w12.y;
	color += textureLod(tex, vec2(tc12.x, tc12.y), 0) * w12.x * w12.y;
	color += textureLod(tex, vec2(tc3.x, tc12.y), 0) * w3.x * w12.y;

	color += textureLod(tex, vec2(tc0.x, tc3.y), 0) * w0.x * w3.y;
	color += textureLod(tex, vec2(tc12.x, tc3.y), 0) * w12.x * w3.y;
	color += textureLod(tex, vec2(tc3.x, tc3.y), 0) * w3.x * w3.y;

	return color;
}
*/
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////MAIN///////////////////////////////////////////////////////////////////////////////////////////
void main() {
	ivec2 texel = ivec2(gl_FragCoord.xy);

	vec3 albedoRaw = texelFetch(colortex6, texel, 0).rgb;
	vec3 albedo = SRGBtoLinear(albedoRaw);

	float depth = GetDepthT(texel);

	vec3 viewPos  = ScreenToViewSpace(vec3(texcoord, depth));

	vec3 worldPos = mat3(gbufferModelViewInverse) * viewPos;
	vec3 worldDir = normalize(worldPos);
	// worldPos += gbufferModelViewInverse[3].xyz;

	if (depth >= 1.0) {
		// vec2 uv = texcoord;
		// vec4 col = texture(colortex1, uv);

		// // CAS algorithm
		// float max_g = col.y;
		// float min_g = col.y;
		// vec4 uvoff = vec4(1,0,1,-1) * screenPixelSize.xxyy;
		// vec4 colw;
		// vec4 col1 = texture(colortex1, uv+uvoff.yw);
		// max_g = max(max_g, col1.y);
		// min_g = min(min_g, col1.y);
		// colw = col1;
		// col1 = texture(colortex1, uv+uvoff.xy);
		// max_g = max(max_g, col1.y);
		// min_g = min(min_g, col1.y);
		// colw += col1;
		// col1 = texture(colortex1, uv+uvoff.yz);
		// max_g = max(max_g, col1.y);
		// min_g = min(min_g, col1.y);
		// colw += col1;
		// col1 = texture(colortex1, uv-uvoff.xy);
		// max_g = max(max_g, col1.y);
		// min_g = min(min_g, col1.y);
		// colw += col1;
		// float d_min_g = min_g;
		// float d_max_g = 1.-max_g;
		// float A;
		// max_g = max(0., max_g);
		// if (d_max_g < d_min_g) {
		// 	A = d_max_g / max_g;
		// } else {
		// 	A = d_min_g / max_g;
		// }
		// A = sqrt(max(0., A));
		// A *= mix(-.125, -.2, 0.5);
		// vec4 col_out = (col + colw * A) / (1.+4.*A);
		// col_out = texture(colortex1, uv);
		// vec4 skyColor = col_out;
		
		// Sky & Clouds
		//vec4 skyColor = textureBicubic(colortex1, texcoord + taaOffset * 0.5);
		//vec4 skyColor = textureCatmullRom(colortex1, texcoord + taaOffset * 0.5);
		vec4 skyColor = texelFetch(colortex1, texel, 0);
		sceneData = skyColor.rgb;
		//sceneData = SRGBtoLinear(skyColor.rgb) * 1e4;

		// Sun & Moon
		vec3 sunmoon = physicalSun(worldDir, worldSunVector);
		float visibility = curve(saturate(worldDir.y * 5.0));
		sunmoon += (vec3(GetLuminance(albedo)) + albedo) * visibility * (0.25 + nightVision);
		if (worldDir.y > -0.1) sunmoon += RenderStars(worldDir);

		sceneData += sunmoon * skyColor.a * AtmosphereAbsorption(worldDir, AtmosphereExtent);
	} else {
		sceneData = vec3(0.0);

		vec4 gbuffer7 = texelFetch(colortex7, texel, 0);
		vec4 gbuffer3 = texelFetch(colortex3, texel, 0);

		int materialID = int(gbuffer7.z * 255.0);
		//int materialIDT = int(texelFetch(colortex1, texel, 0).b * 255.0);

		//MaterialMask materialMask = CalculateMasks(materialID);
		bool isGrass = materialID == 6 || materialID == 27 || materialID == 28 || materialID == 33;

		vec2 mcLightmap = gbuffer7.rg;
		mcLightmap.g = cube(mcLightmap.g);

		vec3 normal = DecodeNormal(gbuffer3.xy);
		vec3 worldNormal = mat3(gbufferModelViewInverse) * normal;

		vec4 specTex = vec4(UnpackUnorm2x8(gbuffer3.z), UnpackUnorm2x8(gbuffer3.w));
		Material material = GetMaterialData(specTex);
		specTex.x = sqr(mix(1.0 - specTex.x, 0.0, wetnessCustom * 0.5));
		specularData = specTex.xy;

		float rawNdotL = dot(worldNormal, worldLightVector);

		// Grass points up
		if (isGrass || materialID == 7) worldNormal = vec3(0.0, 1.0, 0.0);

		float opaqueDepth = -viewPos.z;
		//float waterDepth = ScreenToViewSpace(depthT);
		float LdotV = dot(worldLightVector, -worldDir);
		
		//vec3 halfWay = normalize(worldLightVector - worldDir);
		float NdotV = saturate(dot(worldNormal, -worldDir));
		float NdotL = dot(worldNormal, worldLightVector);
		float halfwayNorm = inversesqrt(2.0 * LdotV + 2.0);
		float NdotH = (NdotL + NdotV) * halfwayNorm;
		float LdotH = LdotV * halfwayNorm + halfwayNorm;

		worldPos += gbufferModelViewInverse[3].xyz;

		// Clouds shadow
		float cloudShadow = mix(1.0, 0.03, wetness);

		#ifdef CLOUDS_SHADOW
			CloudProperties cloudProperties = GetGlobalCloudProperties();
			cloudShadow	= max(CloudShadow(worldPos + cameraPosition, cloudProperties), 0.03);
		#endif

		// Sunlight
		vec3 waterTint = isEyeInWater == 1 ? vec3(0.6, 0.9, 1.2) / max(3.0, opaqueDepth * 0.1 * WATER_FOG_DENSITY) : vec3(1.0);	
		vec3 sunlightMult = 1.8e2 * waterTint * SUNLIGHT_INTENSITY * colorSunlight * cloudShadow;
		vec3 diffuse = vec3(1.0);

		#ifdef TAA_ENABLED
			float dither = BlueNoiseTemporal();
		#else
			float dither = InterleavedGradientNoise(gl_FragCoord.xy);
		#endif

		//float sssDepth;

		float dist, distortFactor;
		vec3 shadowProjPos = WorldPosToShadowProjPosBias(worldPos, worldNormal, dist, distortFactor);	

		float distanceFade = saturate(pow16(max(maxOf(abs(shadowProjPos.xy * 2.0 - 1.0)), rcp(shadowDistance * shadowDistance) * dotSelf(viewPos))));

		float spread = rcp(distortFactor * realShadowMapRes);

		float avgDepth = 0.0;
		//float angle = TAU * dither;
		float radius = spread * 1e2 * shadowProjection[0].x;
		for (uint i = 1u; i < 9u; ++i) {
			float fi = float(i) + dither;
			vec2 lookupCoord = shadowProjPos.xy + sincos(TAU * fi * 0.125) * fi * radius;
			float depthSample = texelFetch(shadowtex0, ivec2(lookupCoord * realShadowMapRes), 0).x;
			avgDepth += max0(shadowProjPos.z - depthSample);
		}

		avgDepth *= 0.125;

		if (materialID == 35 || materialID == 36) specTex.ba += 0.2;

		#if TEXTURE_FORMAT == 0 && defined MC_SPECULAR_MAP
			float hasSSScattering = step(64.5 / 255.0, specTex.b);
			float sssAmount = oneMinus(distanceFade) * remap(64.0 / 255.0, 1.0, specTex.b * hasSSScattering) * SUBSERFACE_SCATTERING_STRENTGH;
		#else
			float sssAmount = oneMinus(distanceFade) * remap(64.0 / 255.0, 1.0, specTex.a) * SUBSERFACE_SCATTERING_STRENTGH;
		#endif
		if (sssAmount > 1e-4) {
			vec3 subsurfaceScattering = CalculateSubsurfaceScattering(albedo, sssAmount, avgDepth * shadowProjectionInverse[2].z, LdotV);
			subsurfaceScattering *= eyeSkylightFix;
			sunlightMult *= 1.0 - sssAmount * 0.5;
			sceneData += subsurfaceScattering * sunlightMult;
			spread *= 2.0;
		}

		vec3 shadow = vec3(0.0);
		vec3 specular = vec3(0.0);
		if (NdotL > 1e-3) {
			float scale = max(avgDepth * radius, spread * 0.25);
			shadowProjPos.z -= dist * 1e-3 + dither * 5e-5 + avgDepth * 1e-2;

			shadow = VariablePenumbraShadow(worldPos, shadowProjPos, dither, scale, avgDepth);

			if (maxOf(shadow) > 1e-6) {
				#ifdef SCREEN_SPACE_SHADOWS
					shadow *= ScreenSpaceShadow(viewPos, normal, dither, isGrass ? 0.1 : sssAmount);
				#endif
				diffuse *= DiffuseHammon(LdotV, NdotV, NdotL, NdotH, material.roughness, albedo);

				#ifdef PARALLAX_SHADOW
					shadow *= oneMinus(gbuffer7.a);
				#endif

				specular = SpecularBRDF(LdotH, NdotV, rawNdotL, NdotH, sqr(material.roughness), material.f0) * mix(vec3(1.0), albedo, material.isMetal);
				specular *= SPECULAR_HIGHLIGHT_BRIGHTNESS + wetnessCustom;

				if (isEyeInWater == 0) shadow *= sign(mcLightmap.g);
				shadow *= sunlightMult;
			}
		}

		// Skylight
		if (mcLightmap.g > 1e-5) {
			vec3 skylight = FromSH(skySHR, skySHG, skySHB, worldNormal);
			// skylight *= dot(worldNormal, normalize(worldLightVector + vec3(0.0, 1.0, 0.0))) * 3.0 + 4.5;
			skylight *= worldNormal.y * 3.0 + 4.5;

			//vec3 skySunLight = (worldNormal.y * 0.35 + 0.65) * colorSunlight;
			//skylight += skySunLight;

			//skylight = mix(skylight, skySunLight * 0.35, wetness * 0.7);

			// lightning
			skylight = skylight * (0.8 - wetness * 0.2) + lightningColor * 1.2;

			#ifdef AURORA
				skylight *= 1.0 + vec3(0.0, 2.0, 1.0) * auroraAmount;
			#endif

			sceneData += skylight * mcLightmap.g * SKYLIGHT_INTENSITY;
		}

		// Basic light
		sceneData += BASIC_BRIGHTNESS + nightVision * 0.1;

		// GI AO
		#ifdef GI_ENABLED
			vec4 indirectData = SpatialFilter(normal, opaqueDepth, NdotV);
			float ao = indirectData.a;
		#elif defined SSAO_ENABLED
			float ao = texelFetch(colortex0, texel / 2, 0).a;
		#else
			float ao = 1.0;
		#endif

		#if defined GI_ENABLED
			if (distanceFade > 1e-3) indirectData.rgb = indirectData.rgb * oneMinus(distanceFade) + 0.04 * oneMinus(saturate(NdotL * 1e2)) * distanceFade;
			if (isEyeInWater == 0) indirectData.rgb *= saturate(mcLightmap.g * 5.0);
			sceneData += indirectData.rgb * GI_BRIGHTNESS * sunlightMult * 0.25;
		#else
			float bounce = CalculateFakeBouncedLight(worldNormal);
			sceneData += bounce * sqr(mcLightmap.g) * sunlightMult;
		#endif

		sceneData *= ao;

		// Block light
		#include "/lib/Lighting/BlockLighting.glsl"

		sceneData += shadow * diffuse;
		sceneData *= albedo;

		if (isEyeInWater == 0) material.isMetal *= 0.2 * smoothstep(0.3, 0.8, mcLightmap.g) + 0.8;
		sceneData *= oneMinus(material.isMetal);
		sceneData += shadow * specular;
	}

	sceneData = clamp16F(sceneData);
}

/* DRAWBUFFERS:04 */